/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.common;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.keycloak.authorization.attribute.Attributes;
import org.keycloak.authorization.identity.Identity;
import org.keycloak.authorization.policy.evaluation.EvaluationContext;
import org.keycloak.models.KeycloakSession;

public class DefaultEvaluationContext
implements EvaluationContext {
    protected final KeycloakSession keycloakSession;
    protected final Identity identity;
    private final Map<String, List<String>> claims;

    public DefaultEvaluationContext(Identity identity, KeycloakSession keycloakSession) {
        this(identity, null, keycloakSession);
    }

    public DefaultEvaluationContext(Identity identity, Map<String, List<String>> claims, KeycloakSession keycloakSession) {
        this.identity = identity;
        this.claims = claims;
        this.keycloakSession = keycloakSession;
    }

    public Identity getIdentity() {
        return this.identity;
    }

    public Map<String, Collection<String>> getBaseAttributes() {
        HashMap<String, Collection<String>> attributes = new HashMap<String, Collection<String>>();
        attributes.put("kc.time.date_time", Arrays.asList(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date())));
        attributes.put("kc.client.network.ip_address", Arrays.asList(this.keycloakSession.getContext().getConnection().getRemoteAddr()));
        attributes.put("kc.client.network.host", Arrays.asList(this.keycloakSession.getContext().getConnection().getRemoteHost()));
        List userAgents = this.keycloakSession.getContext().getRequestHeaders().getRequestHeader("User-Agent");
        if (userAgents != null) {
            attributes.put("kc.client.user_agent", userAgents);
        }
        attributes.put("kc.realm.name", Arrays.asList(this.keycloakSession.getContext().getRealm().getName()));
        if (this.claims != null) {
            for (Map.Entry<String, List<String>> entry : this.claims.entrySet()) {
                attributes.put(entry.getKey(), entry.getValue());
            }
        }
        return attributes;
    }

    public Attributes getAttributes() {
        return Attributes.from(this.getBaseAttributes());
    }
}

