/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.keys;

import java.util.List;
import org.jboss.logging.Logger;
import org.keycloak.component.ComponentModel;
import org.keycloak.keys.Attributes;
import org.keycloak.keys.GeneratedHmacKeyProvider;
import org.keycloak.keys.GeneratedSecretKeyProviderFactory;
import org.keycloak.keys.HmacKeyProvider;
import org.keycloak.keys.HmacKeyProviderFactory;
import org.keycloak.keys.SecretKeyProviderUtils;
import org.keycloak.models.KeycloakSession;
import org.keycloak.provider.ProviderConfigProperty;

public class GeneratedHmacKeyProviderFactory
extends GeneratedSecretKeyProviderFactory<HmacKeyProvider>
implements HmacKeyProviderFactory {
    private static final Logger logger = Logger.getLogger(GeneratedHmacKeyProviderFactory.class);
    public static final String ID = "hmac-generated";
    private static final String HELP_TEXT = "Generates HMAC secret key";
    public static final int DEFAULT_HMAC_KEY_SIZE = 32;
    private static final List<ProviderConfigProperty> CONFIG_PROPERTIES = SecretKeyProviderUtils.configurationBuilder().property(Attributes.SECRET_SIZE_PROPERTY).build();

    public HmacKeyProvider create(KeycloakSession session, ComponentModel model) {
        return new GeneratedHmacKeyProvider(model);
    }

    public String getHelpText() {
        return HELP_TEXT;
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return CONFIG_PROPERTIES;
    }

    public String getId() {
        return ID;
    }

    @Override
    protected Logger logger() {
        return logger;
    }

    @Override
    protected int getDefaultKeySize() {
        return 32;
    }
}

