/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.beliefsystem.simple;

import java.io.IOException;
import org.drools.core.beliefsystem.BeliefSet;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.NamedEntryPoint;
import org.drools.core.common.WorkingMemoryAction;
import org.drools.core.marshalling.impl.MarshallerReaderContext;
import org.drools.core.marshalling.impl.MarshallerWriteContext;
import org.drools.core.marshalling.impl.PersisterHelper;
import org.drools.core.marshalling.impl.ProtobufMessages;
import org.drools.core.phreak.PropagationEntry;
import org.drools.core.reteoo.ObjectTypeConf;
import org.drools.core.reteoo.PropertySpecificUtil;
import org.drools.core.spi.Activation;
import org.drools.core.spi.PropagationContext;

public class BeliefSystemLogicalCallback
extends PropagationEntry.AbstractPropagationEntry
implements WorkingMemoryAction {
    private InternalFactHandle handle;
    private PropagationContext context;
    private Activation activation;
    private boolean update;
    private boolean fullyRetract;

    public BeliefSystemLogicalCallback() {
    }

    public BeliefSystemLogicalCallback(InternalFactHandle handle, PropagationContext context, Activation activation, boolean update, boolean fullyRetract) {
        this.handle = handle;
        this.context = context;
        this.activation = activation;
        this.update = update;
        this.fullyRetract = fullyRetract;
    }

    public BeliefSystemLogicalCallback(MarshallerReaderContext context) throws IOException {
        this.handle = context.handles.get(context.readInt());
        this.context = context.propagationContexts.get(context.readLong());
        this.activation = (Activation)context.terminalTupleMap.get(context.readInt()).getContextObject();
    }

    public BeliefSystemLogicalCallback(MarshallerReaderContext context, ProtobufMessages.ActionQueue.Action _action) {
        ProtobufMessages.ActionQueue.LogicalRetract _retract = _action.getLogicalRetract();
        this.handle = context.handles.get(_retract.getHandleId());
        this.activation = (Activation)context.filter.getTuplesCache().get(PersisterHelper.createActivationKey(_retract.getActivation().getPackageName(), _retract.getActivation().getRuleName(), _retract.getActivation().getTuple())).getContextObject();
        this.context = this.activation.getPropagationContext();
        this.fullyRetract = _retract.getFullyRetract();
        this.update = _retract.getUpdate();
    }

    @Override
    public ProtobufMessages.ActionQueue.Action serialize(MarshallerWriteContext context) {
        ProtobufMessages.ActionQueue.LogicalRetract _retract = ProtobufMessages.ActionQueue.LogicalRetract.newBuilder().setHandleId(this.handle.getId()).setActivation(PersisterHelper.createActivation(this.activation.getRule().getPackageName(), this.activation.getRule().getName(), this.activation.getTuple())).setFullyRetract(this.fullyRetract).setUpdate(this.update).build();
        return ProtobufMessages.ActionQueue.Action.newBuilder().setType(ProtobufMessages.ActionQueue.ActionType.LOGICAL_RETRACT).setLogicalRetract(_retract).build();
    }

    public boolean isUpdate() {
        return this.update;
    }

    public void setUpdate(boolean update) {
        this.update = update;
    }

    public boolean isFullyRetract() {
        return this.fullyRetract;
    }

    public void setFullyRetract(boolean fullyRetract) {
        this.fullyRetract = fullyRetract;
    }

    @Override
    public void execute(InternalWorkingMemory workingMemory) {
        NamedEntryPoint nep = (NamedEntryPoint)this.handle.getEntryPoint();
        BeliefSet bs = this.handle.getEqualityKey().getBeliefSet();
        bs.setWorkingMemoryAction(null);
        if (this.update) {
            if (!bs.isEmpty()) {
                ((NamedEntryPoint)this.handle.getEntryPoint()).update(this.handle, this.handle.getObject(), PropertySpecificUtil.allSetButTraitBitMask(), (Class<?>)Object.class, (Activation)null);
            }
        } else if (this.fullyRetract) {
            ((NamedEntryPoint)this.handle.getEntryPoint()).delete(this.handle, this.context.getRuleOrigin(), this.activation);
        } else {
            ObjectTypeConf typeConf = nep.getObjectTypeConfigurationRegistry().getObjectTypeConf(nep.getEntryPoint(), this.handle.getObject());
            ((NamedEntryPoint)this.handle.getEntryPoint()).getEntryPointNode().retractObject(this.handle, this.context, typeConf, workingMemory);
        }
    }
}

