/*
 * Decompiled with CFR 0.152.
 */
package liquibase.sdk.watch;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import liquibase.change.ColumnConfig;
import liquibase.command.AbstractCommand;
import liquibase.command.CommandValidationErrors;
import liquibase.database.Database;
import liquibase.database.DatabaseFactory;
import liquibase.exception.DatabaseException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.executor.Executor;
import liquibase.executor.ExecutorService;
import liquibase.integration.commandline.CommandLineResourceAccessor;
import liquibase.lockservice.LockService;
import liquibase.lockservice.LockServiceFactory;
import liquibase.resource.CompositeResourceAccessor;
import liquibase.sdk.Main;
import liquibase.sdk.TemplateService;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.SnapshotControl;
import liquibase.snapshot.SnapshotGeneratorFactory;
import liquibase.statement.core.SelectFromDatabaseChangeLogStatement;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Schema;
import liquibase.util.ISODateFormat;
import liquibase.util.StringUtils;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.handler.ResourceHandler;

public class WatchCommand
extends AbstractCommand {
    private String url;
    private String username;
    private String password;
    private int port = 8080;
    private Main mainApp;

    public WatchCommand(Main mainApp) {
        this.mainApp = mainApp;
    }

    @Override
    public String getName() {
        return "watch";
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    @Override
    public CommandValidationErrors validate() {
        return new CommandValidationErrors(this);
    }

    @Override
    protected Object run() throws Exception {
        Server server = new Server(this.port);
        ArrayList<URL> jarUrls = new ArrayList<URL>();
        File libDir = new File("../../lib/");
        for (File file : libDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith("jar");
            }
        })) {
            jarUrls.add(file.toURL());
        }
        CompositeResourceAccessor resourceAccessor = new CompositeResourceAccessor(new CommandLineResourceAccessor(new URLClassLoader(jarUrls.toArray(new URL[jarUrls.size()]), this.getClass().getClassLoader())));
        Database database = DatabaseFactory.getInstance().openDatabase(this.url, this.username, this.password, null, resourceAccessor);
        ResourceHandler staticHandler = new ResourceHandler();
        staticHandler.setDirectoriesListed(false);
        staticHandler.setWelcomeFiles(new String[]{"index.html"});
        staticHandler.setResourceBase(this.getClass().getClassLoader().getResource("liquibase/sdk/watch/index.html.vm").toExternalForm().replaceFirst("index.html.vm$", ""));
        HandlerList handlers = new HandlerList();
        handlers.setHandlers(new Handler[]{new DynamicContentHandler(database), staticHandler, new DefaultHandler()});
        server.setHandler((Handler)handlers);
        server.start();
        this.mainApp.out("Liquibase Watch running on http://localhost:" + this.getPort() + "/");
        server.join();
        return "Started";
    }

    private static class DynamicContentHandler
    extends AbstractHandler {
        private final Database database;
        private final Executor executor;

        public DynamicContentHandler(Database database) {
            this.database = database;
            this.executor = ExecutorService.getInstance().getExecutor(database);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handle(String url, Request request, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
            block10: {
                try {
                    if (url.equals("/favicon.ico")) {
                        httpServletResponse.setStatus(404);
                        request.setHandled(true);
                        break block10;
                    }
                    if (url.equals("/index.html") || url.equals("/") || url.equals("")) {
                        HashMap<String, Object> context = new HashMap<String, Object>();
                        this.loadIndexData(context);
                        httpServletResponse.setContentType("text/html");
                        httpServletResponse.setStatus(200);
                        TemplateService.getInstance().write("liquibase/sdk/watch/index.html.vm", httpServletResponse.getWriter(), context);
                        request.setHandled(true);
                        break block10;
                    }
                    if (!url.equals("/liquibase-status.json")) break block10;
                    if (SnapshotGeneratorFactory.getInstance().hasDatabaseChangeLogTable(this.database)) {
                        List<Map<String, ?>> rows;
                        LockService lockService = LockServiceFactory.getInstance().getLockService(this.database);
                        lockService.waitForLock();
                        try {
                            SelectFromDatabaseChangeLogStatement select = new SelectFromDatabaseChangeLogStatement(new ColumnConfig().setName("COUNT(*) AS ROW_COUNT", true), new ColumnConfig().setName("MAX(DATEEXECUTED) AS LAST_EXEC", true));
                            rows = this.executor.queryForList(select);
                        }
                        finally {
                            lockService.releaseLock();
                        }
                        PrintWriter writer = httpServletResponse.getWriter();
                        httpServletResponse.setContentType("application/json");
                        httpServletResponse.setStatus(200);
                        if (rows.size() == 0) {
                            writer.print("{\"count\": 0}");
                        } else {
                            Map<String, ?> row = rows.iterator().next();
                            writer.print("{\"count\":" + row.get("ROW_COUNT") + ", \"lastExec\": \"" + new ISODateFormat().format((Date)row.get("LAST_EXEC")) + "\"}");
                        }
                        request.setHandled(true);
                        break block10;
                    }
                    PrintWriter writer = httpServletResponse.getWriter();
                    httpServletResponse.setContentType("application/json");
                    httpServletResponse.setStatus(200);
                    writer.print("{\"count\": -1}");
                    request.setHandled(true);
                }
                catch (Throwable e) {
                    throw new ServletException(e);
                }
            }
        }

        protected void writeDatabaseChangeLogTab(Map<String, Object> context) throws DatabaseException {
            String outString;
            String changeLogDetails = "";
            if (SnapshotGeneratorFactory.getInstance().hasDatabaseChangeLogTable(this.database)) {
                outString = "<table class='table table-striped table-bordered table-condensed'>";
                outString = outString + "<tr><th>Id</th><th>Author</th><th>Path</th><th>ExecType</th><th>Tag</th></tr>";
                SelectFromDatabaseChangeLogStatement select = new SelectFromDatabaseChangeLogStatement("FILENAME", "AUTHOR", "ID", "MD5SUM", "DATEEXECUTED", "ORDEREXECUTED", "EXECTYPE", "DESCRIPTION", "COMMENTS", "TAG", "LIQUIBASE").setOrderBy("DATEEXECUTED DESC", "ORDEREXECUTED DESC");
                List<Map<String, ?>> ranChangeSets = ExecutorService.getInstance().getExecutor(this.database).queryForList(select);
                for (Map<String, ?> row : ranChangeSets) {
                    String id = this.cleanHtmlId(row.get("ID") + ":" + row.get("AUTHOR") + ":" + row.get("FILENAME"));
                    outString = outString + "<tr><td><a style='color:black' class='object-name' href='#" + id + "'>" + StringUtils.escapeHtml((String)row.get("ID")) + "</a></td>" + "<td><a style='color:black' class='object-name' href='#" + id + "'>" + StringUtils.escapeHtml((String)row.get("AUTHOR")) + "</a></td>" + "<td><a style='color:black' class='object-name' href='#" + id + "'>" + StringUtils.escapeHtml((String)row.get("FILENAME")) + "</a></td>" + "<td><a style='color:black' class='object-name' href='#" + id + "'>" + row.get("EXECTYPE") + "</a></td>" + "<td><a style='color:black' class='object-name' href='#" + id + "'>" + StringUtils.escapeHtml(StringUtils.trimToEmpty((String)row.get("TAG"))) + "</a></td>" + "</tr>";
                    changeLogDetails = changeLogDetails + this.wrapDetails(id, row.get("ID") + " :: " + row.get("AUTHOR") + " :: " + row.get("FILENAME"), this.writeDatabaseChangeLogDetails(row));
                }
                outString = outString + "</table>";
            } else {
                outString = "<h2 style='margin-top:0px; padding-top: 10px; padding-left:10px'>No DatabaseChangeLog Table</h2>";
            }
            context.put("changeLog", outString);
            context.put("changeLogDetails", changeLogDetails);
        }

        private String cleanHtmlId(String id) {
            return id.replaceAll("[^a-zA-Z0-9_\\-]", "_");
        }

        protected String writeDatabaseChangeLogDetails(Map row) throws DatabaseException {
            String outString = "<table class='table table-striped table-bordered table-condensed'>";
            outString = outString + "<tr><td><strong>Id</strong></td><td>" + row.get("ID") + "</td></tr>\n" + "<tr><td><strong>Author</strong></td><td>" + row.get("AUTHOR") + "</td></tr>\n" + "<tr><td><strong>Filename</strong></td><td>" + row.get("FILENAME") + "</td></tr>\n" + "<tr><td><strong>DateExecuted</strong></td><td>" + new ISODateFormat().format((Date)row.get("DATEEXECUTED")) + "</td></tr>\n" + "<tr><td><strong>OrderExecuted</strong></td><td>" + row.get("ORDEREXECUTED") + "</td></tr>\n" + "<tr><td><strong>ExecType</strong></td><td>" + row.get("EXECTYPE") + "</td></tr>\n" + "<tr><td><strong>MD5Sum</strong></td><td>" + row.get("MD5SUM") + "</td></tr>\n" + "<tr><td><strong>Description</strong></td><td>" + row.get("DESCRIPTION") + "</td></tr>\n" + "<tr><td><strong>Comments</strong></td><td>" + row.get("COMMENTS") + "</td></tr>\n" + "<tr><td><strong>Tag</strong></td><td>" + StringUtils.trimToNull((String)row.get("TAG")) + "</td></tr>\n" + "<tr><td><strong>Liquibase</strong></td><td>" + row.get("LIQUIBASE") + "</td></tr>\n";
            outString = outString + "</table>";
            return outString;
        }

        public void loadIndexData(Map<String, Object> context) {
            try {
                DatabaseSnapshot snapshot = SnapshotGeneratorFactory.getInstance().createSnapshot(this.database.getDefaultSchema(), this.database, new SnapshotControl(this.database));
                StringBuilder buffer = new StringBuilder();
                Database database = snapshot.getDatabase();
                buffer.append("<div class='panel panel-primary'>");
                buffer.append("<div class='panel-heading'><h2 style='margin-top:0px; margin-bottom:0px'>").append(StringUtils.escapeHtml(database.getConnection().getURL())).append("</h2></div>\n");
                buffer.append("<div class='panel-body'>");
                buffer.append("<strong>Database type:</strong> ").append(StringUtils.escapeHtml(database.getDatabaseProductName())).append("<br>\n");
                buffer.append("<strong>Database version:</strong> ").append(StringUtils.escapeHtml(database.getDatabaseProductVersion())).append("<br>\n");
                buffer.append("<strong>Database user:</strong> ").append(StringUtils.escapeHtml(database.getConnection().getConnectionUserName())).append("<br>\n");
                Set<Schema> schemas = snapshot.get(Schema.class);
                if (schemas.size() > 1) {
                    throw new UnexpectedLiquibaseException("Can only display one schema");
                }
                Schema schema = schemas.iterator().next();
                if (database.supportsSchemas()) {
                    buffer.append("<strong>Catalog & Schema:</strong> ").append(schema.getCatalogName()).append(" / ").append(schema.getName()).append("<br>\n");
                } else {
                    buffer.append("<strong>Catalog:</strong> ").append(schema.getCatalogName()).append("<br>\n");
                }
                buffer.append("</div>\n");
                buffer.append("</div>\n");
                SnapshotControl snapshotControl = snapshot.getSnapshotControl();
                List includedTypes = this.sort(snapshotControl.getTypesToInclude());
                StringBuilder catalogBuffer = new StringBuilder();
                StringBuilder detailsBuilder = new StringBuilder();
                catalogBuffer.append("<ul class='nav nav-tabs' id='tabs'>\n");
                catalogBuffer.append("<li><a href='#databasechangelog-tab' data-toggle='tab'>DatabaseChangeLog</a></li>\n");
                for (Class type : includedTypes) {
                    if (schema.getDatabaseObjects(type).size() <= 0) continue;
                    catalogBuffer.append("<li><a href='#").append(type.getSimpleName()).append("-tab' data-toggle='tab'>").append(type.getSimpleName()).append("(s)</a></li>\n");
                }
                catalogBuffer.append("</ul>\n");
                catalogBuffer.append("<div class='tab-content' style='margin-bottom:20px;'>\n");
                catalogBuffer.append("<div class='tab-pane' style='border: 1px #ddd solid; border-top:none' id='databasechangelog-tab'>\n");
                this.writeDatabaseChangeLogTab(context);
                detailsBuilder.append(context.get("changeLogDetails"));
                catalogBuffer.append(context.get("changeLog"));
                catalogBuffer.append("</div>");
                for (Class type : includedTypes) {
                    List databaseObjects = this.sort(schema.getDatabaseObjects(type));
                    if (databaseObjects.size() <= 0) continue;
                    catalogBuffer.append("<div class='tab-pane' style='border: 1px #ddd solid; border-top:none' id='").append(type.getSimpleName()).append("-tab'>\n");
                    catalogBuffer.append("<div style='padding:10px; font-color:black'><ol>\n");
                    StringBuilder typeBuffer = new StringBuilder();
                    for (DatabaseObject databaseObject : databaseObjects) {
                        String id = databaseObject.getClass().getName() + "-" + databaseObject.getName();
                        id = this.cleanHtmlId(id);
                        typeBuffer.append("<li><a style='color:black' class='object-name' href='#" + id + "'>").append(StringUtils.escapeHtml(databaseObject.getName())).append("</a></li>\n");
                        detailsBuilder.append(this.wrapDetails(id, type.getSimpleName() + " " + databaseObject.getName(), this.writeDatabaseObject(databaseObject, new HashSet<String>(), databaseObject.getName()))).append("\n");
                    }
                    catalogBuffer.append(StringUtils.indent(typeBuffer.toString(), 4)).append("\n");
                    catalogBuffer.append("</ol></div>\n");
                    catalogBuffer.append("</div>\n");
                }
                catalogBuffer.append("</div>\n");
                buffer.append(StringUtils.indent(catalogBuffer.toString(), 4));
                context.put("snapshot", buffer.toString());
                context.put("details", detailsBuilder.toString());
            }
            catch (Exception e) {
                throw new UnexpectedLiquibaseException(e);
            }
        }

        protected String wrapDetails(String id, String title, String details) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("<div class='modal fade' id='" + id + "'><div class='modal-dialog modal-lg'><div class='modal-content'>");
            buffer.append("<div class='modal-header'><button type='button' class='close' data-dismiss='modal' aria-hidden='true'>&times;</button><h4 class='modal-title'>").append(StringUtils.escapeHtml(title)).append("</h4></div>\n");
            buffer.append("<div class='modal-body'>");
            buffer.append(StringUtils.indent(details, 4));
            buffer.append("</div>");
            buffer.append("<div class='modal-footer'><button type='button' class='btn btn-default' data-dismiss='modal'>Close</button></div>");
            buffer.append("</div></div></div>");
            return buffer.toString();
        }

        protected String writeDatabaseObject(DatabaseObject databaseObject, Set<String> oldParentNames, String newParentName) {
            HashSet<String> parentNames = new HashSet<String>(oldParentNames);
            parentNames.add(newParentName);
            StringBuilder singleValueOut = new StringBuilder();
            StringBuilder multiValueOut = new StringBuilder();
            List attributes = this.sort(databaseObject.getAttributes());
            for (String attribute : attributes) {
                Object value;
                if (attribute.equals("name") || attribute.equals("schema") || (value = databaseObject.getAttribute(attribute, Object.class)) instanceof Schema) continue;
                boolean multiValue = false;
                if (value instanceof DatabaseObject) {
                    value = parentNames.contains(((DatabaseObject)value).getName()) ? null : databaseObject.getSerializableFieldValue(attribute);
                } else if (value instanceof Collection) {
                    if (((Collection)value).size() == 0) {
                        value = null;
                    } else {
                        multiValue = true;
                        Object firstValue = ((Collection)value).iterator().next();
                        if (firstValue instanceof DatabaseObject) {
                            final ArrayList<String> rowAttributes = new ArrayList<String>();
                            rowAttributes.add("name");
                            for (DatabaseObject obj : (Collection)value) {
                                for (String rowAttribute : obj.getAttributes()) {
                                    Class<Object> cellValue;
                                    if (rowAttributes.contains(rowAttribute) || (cellValue = obj.getAttribute(rowAttribute, Object.class)) instanceof DatabaseObject && parentNames.contains(((DatabaseObject)((Object)cellValue)).getName()) || cellValue == null || cellValue instanceof Collection && ((Collection)((Object)cellValue)).size() == 0) continue;
                                    rowAttributes.add(rowAttribute);
                                }
                            }
                            value = StringUtils.join((Collection)value, "\n", new StringUtils.StringUtilsFormatter(){

                                public String toString(Object obj) {
                                    if (obj instanceof DatabaseObject) {
                                        String row = "<tr>";
                                        for (String attribute : rowAttributes) {
                                            if (((DatabaseObject)obj).getAttributes().contains(attribute)) {
                                                row = row + "<td>" + StringUtils.escapeHtml(((DatabaseObject)obj).getSerializableFieldValue(attribute).toString());
                                                continue;
                                            }
                                            row = row + "<td></td>";
                                        }
                                        row = row + "</tr>";
                                        return row;
                                    }
                                    return obj.toString();
                                }
                            });
                            String header = "";
                            for (String rowAttribute : rowAttributes) {
                                header = header + "<th>" + rowAttribute + "</th>";
                            }
                            value = "<div overflow='scroll' style='overflow-x:auto'><table class='table table-bordered table-condensed' style='margin-bottom:0px'><tr>" + header + "</tr>\n" + StringUtils.indent((String)value, 4) + "</table></div>";
                        } else {
                            value = databaseObject.getSerializableFieldValue(attribute);
                        }
                    }
                } else {
                    value = databaseObject.getSerializableFieldValue(attribute);
                }
                if (value == null) continue;
                if (multiValue) {
                    multiValueOut.append("<h4>").append(attribute).append(":</h4>");
                    multiValueOut.append(StringUtils.escapeHtml(value.toString()));
                    multiValueOut.append("<br>");
                    continue;
                }
                singleValueOut.append("<tr><td><strong>").append(attribute).append("</strong></td><td>");
                singleValueOut.append(value);
                singleValueOut.append("</td></tr>");
            }
            String finalOut = singleValueOut.toString();
            if (finalOut.length() > 0) {
                finalOut = "<h4>attributes:</h4><table class='table table-bordered table-condensed'>" + finalOut + "</table><br>";
            }
            finalOut = finalOut + multiValueOut.toString();
            return finalOut;
        }

        private List sort(Collection objects) {
            return this.sort(objects, new Comparator(){

                public int compare(Object o1, Object o2) {
                    if (o1 instanceof Comparable) {
                        return ((Comparable)o1).compareTo(o2);
                    }
                    if (o1 instanceof Class) {
                        return ((Class)o1).getName().compareTo(((Class)o2).getName());
                    }
                    throw new ClassCastException(o1.getClass().getName() + " cannot be cast to java.lang.Comparable or java.lang.Class");
                }
            });
        }

        private <T> List<T> sort(Collection objects, Comparator<T> comparator) {
            ArrayList returnList = new ArrayList(objects);
            Collections.sort(returnList, comparator);
            return returnList;
        }
    }
}

