/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan;

import java.util.Map;
import java.util.Set;
import org.infinispan.Cache;
import org.jboss.logging.Logger;
import org.keycloak.models.cache.infinispan.CacheManager;
import org.keycloak.models.cache.infinispan.UserCacheSession;
import org.keycloak.models.cache.infinispan.entities.Revisioned;
import org.keycloak.models.cache.infinispan.events.InvalidationEvent;
import org.keycloak.models.cache.infinispan.events.UserCacheInvalidationEvent;
import org.keycloak.models.cache.infinispan.stream.InRealmPredicate;

public class UserCacheManager
extends CacheManager {
    private static final Logger logger = Logger.getLogger(UserCacheManager.class);
    protected volatile boolean enabled = true;

    public UserCacheManager(Cache<String, Revisioned> cache, Cache<String, Long> revisions) {
        super(cache, revisions);
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

    @Override
    public void clear() {
        this.cache.clear();
        this.revisions.clear();
    }

    public void userUpdatedInvalidations(String userId, String username, String email, String realmId, Set<String> invalidations) {
        invalidations.add(userId);
        if (email != null) {
            invalidations.add(UserCacheSession.getUserByEmailCacheKey(realmId, email));
        }
        invalidations.add(UserCacheSession.getUserByUsernameCacheKey(realmId, username));
    }

    public void fullUserInvalidation(String userId, String username, String email, String realmId, boolean identityFederationEnabled, Map<String, String> federatedIdentities, Set<String> invalidations) {
        this.userUpdatedInvalidations(userId, username, email, realmId, invalidations);
        if (identityFederationEnabled) {
            for (Map.Entry<String, String> socialLink : federatedIdentities.entrySet()) {
                String fedIdentityCacheKey = UserCacheSession.getUserByFederatedIdentityCacheKey(realmId, socialLink.getKey(), socialLink.getValue());
                invalidations.add(fedIdentityCacheKey);
            }
            invalidations.add(UserCacheSession.getFederatedIdentityLinksCacheKey(userId));
        }
        invalidations.add(UserCacheSession.getConsentCacheKey(userId));
    }

    public void federatedIdentityLinkUpdatedInvalidation(String userId, Set<String> invalidations) {
        invalidations.add(UserCacheSession.getFederatedIdentityLinksCacheKey(userId));
    }

    public void federatedIdentityLinkRemovedInvalidation(String userId, String realmId, String identityProviderId, String socialUserId, Set<String> invalidations) {
        invalidations.add(UserCacheSession.getFederatedIdentityLinksCacheKey(userId));
        if (identityProviderId != null) {
            invalidations.add(UserCacheSession.getUserByFederatedIdentityCacheKey(realmId, identityProviderId, socialUserId));
        }
    }

    public void consentInvalidation(String userId, Set<String> invalidations) {
        invalidations.add(UserCacheSession.getConsentCacheKey(userId));
    }

    @Override
    protected void addInvalidationsFromEvent(InvalidationEvent event, Set<String> invalidations) {
        ((UserCacheInvalidationEvent)((Object)event)).addInvalidations(this, invalidations);
    }

    public void invalidateRealmUsers(String realm, Set<String> invalidations) {
        InRealmPredicate inRealmPredicate = this.getInRealmPredicate(realm);
        this.addInvalidations(inRealmPredicate, invalidations);
    }

    private InRealmPredicate getInRealmPredicate(String realmId) {
        return InRealmPredicate.create().realm(realmId);
    }
}

