/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.util;

import java.util.Set;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.persistence.remote.RemoteStore;
import org.infinispan.remoting.transport.Transport;
import org.keycloak.connections.infinispan.InfinispanConnectionProvider;
import org.keycloak.models.KeycloakSession;

public class InfinispanUtil {
    public static Set<RemoteStore> getRemoteStores(Cache ispnCache) {
        return ((PersistenceManager)ispnCache.getAdvancedCache().getComponentRegistry().getComponent(PersistenceManager.class)).getStores(RemoteStore.class);
    }

    public static RemoteCache getRemoteCache(Cache ispnCache) {
        Set<RemoteStore> remoteStores = InfinispanUtil.getRemoteStores(ispnCache);
        if (remoteStores.isEmpty()) {
            return null;
        }
        return remoteStores.iterator().next().getRemoteCache();
    }

    public static boolean isDistributedCache(Cache ispnCache) {
        CacheMode cacheMode = ispnCache.getCacheConfiguration().clustering().cacheMode();
        return cacheMode.isDistributed();
    }

    public static String getMyAddress(KeycloakSession session) {
        return ((InfinispanConnectionProvider)session.getProvider(InfinispanConnectionProvider.class)).getNodeName();
    }

    public static String getMySite(KeycloakSession session) {
        return ((InfinispanConnectionProvider)session.getProvider(InfinispanConnectionProvider.class)).getSiteName();
    }

    public static String getKeyPrimaryOwnerAddress(Cache ispnCache, Object key) {
        DistributionManager distManager = ispnCache.getAdvancedCache().getDistributionManager();
        if (distManager == null) {
            throw new IllegalArgumentException("Cache '" + ispnCache.getName() + "' is not distributed cache");
        }
        return distManager.getPrimaryLocation(key).toString();
    }

    public static boolean isCoordinator(Cache cache) {
        Transport transport = cache.getCacheManager().getTransport();
        return transport == null || transport.isCoordinator();
    }
}

