/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.console.command.invocation;

import org.jboss.aesh.cl.CommandLine;
import org.jboss.aesh.cl.parser.CommandLineParserException;
import org.jboss.aesh.cl.validator.OptionValidatorException;
import org.jboss.aesh.console.AeshConsoleImpl;
import org.jboss.aesh.console.AeshContext;
import org.jboss.aesh.console.ConsoleCallback;
import org.jboss.aesh.console.Prompt;
import org.jboss.aesh.console.command.Command;
import org.jboss.aesh.console.command.CommandException;
import org.jboss.aesh.console.command.CommandNotFoundException;
import org.jboss.aesh.console.command.CommandOperation;
import org.jboss.aesh.console.command.container.CommandContainer;
import org.jboss.aesh.console.command.invocation.CommandInvocation;
import org.jboss.aesh.console.command.registry.CommandRegistry;
import org.jboss.aesh.console.operator.ControlOperator;
import org.jboss.aesh.parser.AeshLine;
import org.jboss.aesh.parser.Parser;
import org.jboss.aesh.terminal.Shell;

public final class AeshCommandInvocation
implements CommandInvocation {
    private final AeshConsoleImpl aeshConsole;
    private final ControlOperator controlOperator;
    private final ConsoleCallback callback;
    private final int pid;

    public AeshCommandInvocation(AeshConsoleImpl aeshConsole, ControlOperator controlOperator, int pid, ConsoleCallback callback) {
        this.aeshConsole = aeshConsole;
        this.controlOperator = controlOperator;
        this.pid = pid;
        this.callback = callback;
    }

    @Override
    public ControlOperator getControlOperator() {
        return this.controlOperator;
    }

    @Override
    public CommandRegistry getCommandRegistry() {
        return this.aeshConsole.getCommandRegistry();
    }

    @Override
    public Shell getShell() {
        return this.aeshConsole.getShell();
    }

    @Override
    public void setPrompt(Prompt prompt) {
        this.aeshConsole.setPrompt(prompt);
    }

    @Override
    public Prompt getPrompt() {
        return this.aeshConsole.getPrompt();
    }

    @Override
    public String getHelpInfo(String commandName) {
        return this.aeshConsole.getHelpInfo(commandName);
    }

    @Override
    public void stop() {
        this.aeshConsole.stop();
    }

    @Override
    public AeshContext getAeshContext() {
        return this.aeshConsole.getAeshContext();
    }

    @Override
    public CommandOperation getInput() throws InterruptedException {
        return this.callback.getInput();
    }

    @Override
    public String getInputLine() throws InterruptedException {
        return this.callback.getInputLine();
    }

    @Override
    public int getPid() {
        return this.pid;
    }

    @Override
    public void putProcessInBackground() {
        this.aeshConsole.putProcessInBackground(this.pid);
    }

    @Override
    public void putProcessInForeground() {
        this.aeshConsole.putProcessInForeground(this.pid);
    }

    @Override
    public void executeCommand(String input) {
        this.aeshConsole.execute(input);
    }

    @Override
    public void print(String msg) {
        this.aeshConsole.getShell().out().print(msg);
    }

    @Override
    public void println(String msg) {
        this.aeshConsole.getShell().out().println(msg);
    }

    @Override
    public boolean isEchoing() {
        return this.aeshConsole.isEchoing();
    }

    @Override
    public void setEcho(boolean echo) {
        this.aeshConsole.setEcho(echo);
    }

    @Override
    public Command getPopulatedCommand(String commandLine) throws CommandNotFoundException, CommandException, CommandLineParserException, OptionValidatorException {
        if (commandLine == null || commandLine.isEmpty()) {
            return null;
        }
        AeshLine aeshLine = Parser.findAllWords(commandLine);
        if (aeshLine.getWords().isEmpty()) {
            return null;
        }
        String opName = aeshLine.getWords().get(0);
        CommandContainer container = this.aeshConsole.getCommandRegistry().getCommand(opName, commandLine);
        if (container == null) {
            throw new CommandNotFoundException("No command handler for '" + opName + "'.");
        }
        CommandLine<Command> line = container.getParser().parse(commandLine, false);
        if (line == null) {
            throw new CommandException("Invalid Command " + commandLine);
        }
        line.getParser().getCommandPopulator().populateObject(line, this.aeshConsole.getInvocationProviders(), this.getAeshContext(), true);
        return line.getParser().getCommand();
    }
}

