/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan.authorization;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.keycloak.authorization.model.CachedModel;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.models.cache.infinispan.authorization.StoreFactoryCacheSession;
import org.keycloak.models.cache.infinispan.authorization.entities.CachedPolicy;
import org.keycloak.representations.idm.authorization.DecisionStrategy;
import org.keycloak.representations.idm.authorization.Logic;

public class PolicyAdapter
implements Policy,
CachedModel<Policy> {
    protected CachedPolicy cached;
    protected StoreFactoryCacheSession cacheSession;
    protected Policy updated;
    protected boolean invalidated;
    protected Set<Policy> associatedPolicies;
    protected Set<Resource> resources;
    protected Set<Scope> scopes;

    public PolicyAdapter(CachedPolicy cached, StoreFactoryCacheSession cacheSession) {
        this.cached = cached;
        this.cacheSession = cacheSession;
    }

    public Policy getDelegateForUpdate() {
        if (this.updated == null) {
            this.updated = this.cacheSession.getPolicyStoreDelegate().findById(this.cached.getId(), this.cached.getResourceServerId());
            String defaultResourceType = (String)this.updated.getConfig().get("defaultResourceType");
            this.cacheSession.registerPolicyInvalidation(this.cached.getId(), this.cached.getName(), this.cached.getResourcesIds(), this.cached.getScopesIds(), defaultResourceType, this.cached.getResourceServerId());
            if (this.updated == null) {
                throw new IllegalStateException("Not found in database");
            }
        }
        return this.updated;
    }

    protected void invalidateFlag() {
        this.invalidated = true;
    }

    public void invalidate() {
        this.invalidated = true;
        this.getDelegateForUpdate();
    }

    public long getCacheTimestamp() {
        return this.cached.getCacheTimestamp();
    }

    protected boolean isUpdated() {
        if (this.updated != null) {
            return true;
        }
        if (!this.invalidated) {
            return false;
        }
        this.updated = this.cacheSession.getPolicyStoreDelegate().findById(this.cached.getId(), this.cached.getResourceServerId());
        if (this.updated == null) {
            throw new IllegalStateException("Not found in database");
        }
        return true;
    }

    public String getId() {
        if (this.isUpdated()) {
            return this.updated.getId();
        }
        return this.cached.getId();
    }

    public String getName() {
        if (this.isUpdated()) {
            return this.updated.getName();
        }
        return this.cached.getName();
    }

    public void setName(String name) {
        this.getDelegateForUpdate();
        this.cacheSession.registerPolicyInvalidation(this.cached.getId(), name, this.cached.getResourcesIds(), this.cached.getScopesIds(), this.cached.getConfig().get("defaultResourceType"), this.cached.getResourceServerId());
        this.updated.setName(name);
    }

    public ResourceServer getResourceServer() {
        return this.cacheSession.getResourceServerStore().findById(this.cached.getResourceServerId());
    }

    public String getType() {
        if (this.isUpdated()) {
            return this.updated.getType();
        }
        return this.cached.getType();
    }

    public DecisionStrategy getDecisionStrategy() {
        if (this.isUpdated()) {
            return this.updated.getDecisionStrategy();
        }
        return this.cached.getDecisionStrategy();
    }

    public void setDecisionStrategy(DecisionStrategy decisionStrategy) {
        this.getDelegateForUpdate();
        this.updated.setDecisionStrategy(decisionStrategy);
    }

    public Logic getLogic() {
        if (this.isUpdated()) {
            return this.updated.getLogic();
        }
        return this.cached.getLogic();
    }

    public void setLogic(Logic logic) {
        this.getDelegateForUpdate();
        this.updated.setLogic(logic);
    }

    public Map<String, String> getConfig() {
        if (this.isUpdated()) {
            return this.updated.getConfig();
        }
        return this.cached.getConfig();
    }

    public void setConfig(Map<String, String> config) {
        this.getDelegateForUpdate();
        if (config.containsKey("defaultResourceType") || this.cached.getConfig().containsKey("defaultResourceType")) {
            this.cacheSession.registerPolicyInvalidation(this.cached.getId(), this.cached.getName(), this.cached.getResourcesIds(), this.cached.getScopesIds(), this.cached.getConfig().get("defaultResourceType"), this.cached.getResourceServerId());
            this.cacheSession.registerPolicyInvalidation(this.cached.getId(), this.cached.getName(), this.cached.getResourcesIds(), this.cached.getScopesIds(), config.get("defaultResourceType"), this.cached.getResourceServerId());
        }
        this.updated.setConfig(config);
    }

    public void removeConfig(String name) {
        this.getDelegateForUpdate();
        if (name.equals("defaultResourceType")) {
            this.cacheSession.registerPolicyInvalidation(this.cached.getId(), this.cached.getName(), this.cached.getResourcesIds(), this.cached.getScopesIds(), this.cached.getConfig().get("defaultResourceType"), this.cached.getResourceServerId());
        }
        this.updated.removeConfig(name);
    }

    public void putConfig(String name, String value) {
        this.getDelegateForUpdate();
        if (name.equals("defaultResourceType")) {
            this.cacheSession.registerPolicyInvalidation(this.cached.getId(), this.cached.getName(), this.cached.getResourcesIds(), this.cached.getScopesIds(), this.cached.getConfig().get("defaultResourceType"), this.cached.getResourceServerId());
            this.cacheSession.registerPolicyInvalidation(this.cached.getId(), this.cached.getName(), this.cached.getResourcesIds(), this.cached.getScopesIds(), value, this.cached.getResourceServerId());
        }
        this.updated.putConfig(name, value);
    }

    public String getDescription() {
        if (this.isUpdated()) {
            return this.updated.getDescription();
        }
        return this.cached.getDescription();
    }

    public void setDescription(String description) {
        this.getDelegateForUpdate();
        this.updated.setDescription(description);
    }

    public Set<Policy> getAssociatedPolicies() {
        if (this.isUpdated()) {
            return this.updated.getAssociatedPolicies();
        }
        if (this.associatedPolicies != null) {
            return this.associatedPolicies;
        }
        this.associatedPolicies = new HashSet<Policy>();
        for (String scopeId : this.cached.getAssociatedPoliciesIds()) {
            this.associatedPolicies.add(this.cacheSession.getPolicyStore().findById(scopeId, this.cached.getResourceServerId()));
        }
        this.associatedPolicies = Collections.unmodifiableSet(this.associatedPolicies);
        return this.associatedPolicies;
    }

    public Set<Resource> getResources() {
        if (this.isUpdated()) {
            return this.updated.getResources();
        }
        if (this.resources != null) {
            return this.resources;
        }
        this.resources = new HashSet<Resource>();
        for (String resourceId : this.cached.getResourcesIds()) {
            this.resources.add(this.cacheSession.getResourceStore().findById(resourceId, this.cached.getResourceServerId()));
        }
        this.resources = Collections.unmodifiableSet(this.resources);
        return this.resources;
    }

    public void addScope(Scope scope) {
        this.getDelegateForUpdate();
        this.cacheSession.registerPolicyInvalidation(this.cached.getId(), this.cached.getName(), this.cached.getResourcesIds(), new HashSet<String>(Arrays.asList(scope.getId())), this.cached.getConfig().get("defaultResourceType"), this.cached.getResourceServerId());
        this.updated.addScope(scope);
    }

    public void removeScope(Scope scope) {
        this.getDelegateForUpdate();
        this.cacheSession.registerPolicyInvalidation(this.cached.getId(), this.cached.getName(), this.cached.getResourcesIds(), new HashSet<String>(Arrays.asList(scope.getId())), this.cached.getConfig().get("defaultResourceType"), this.cached.getResourceServerId());
        this.updated.removeScope(scope);
    }

    public void addAssociatedPolicy(Policy associatedPolicy) {
        this.getDelegateForUpdate();
        this.updated.addAssociatedPolicy(associatedPolicy);
    }

    public void removeAssociatedPolicy(Policy associatedPolicy) {
        this.getDelegateForUpdate();
        this.updated.removeAssociatedPolicy(associatedPolicy);
    }

    public void addResource(Resource resource) {
        this.getDelegateForUpdate();
        HashSet<String> resources = new HashSet<String>();
        resources.add(resource.getId());
        this.cacheSession.registerPolicyInvalidation(this.cached.getId(), this.cached.getName(), resources, this.cached.getScopesIds(), this.cached.getConfig().get("defaultResourceType"), this.cached.getResourceServerId());
        this.updated.addResource(resource);
    }

    public void removeResource(Resource resource) {
        this.getDelegateForUpdate();
        HashSet<String> resources = new HashSet<String>();
        resources.add(resource.getId());
        this.cacheSession.registerPolicyInvalidation(this.cached.getId(), this.cached.getName(), resources, this.cached.getScopesIds(), this.cached.getConfig().get("defaultResourceType"), this.cached.getResourceServerId());
        this.updated.removeResource(resource);
    }

    public Set<Scope> getScopes() {
        if (this.isUpdated()) {
            return this.updated.getScopes();
        }
        if (this.scopes != null) {
            return this.scopes;
        }
        this.scopes = new HashSet<Scope>();
        for (String scopeId : this.cached.getScopesIds()) {
            this.scopes.add(this.cacheSession.getScopeStore().findById(scopeId, this.cached.getResourceServerId()));
        }
        this.scopes = Collections.unmodifiableSet(this.scopes);
        return this.scopes;
    }

    public String getOwner() {
        if (this.isUpdated()) {
            return this.updated.getOwner();
        }
        return this.cached.getOwner();
    }

    public void setOwner(String owner) {
        this.getDelegateForUpdate();
        this.cacheSession.registerPolicyInvalidation(this.cached.getId(), this.cached.getName(), this.cached.getResourcesIds(), this.cached.getScopesIds(), this.cached.getConfig().get("defaultResourceType"), this.cached.getResourceServerId());
        this.updated.setOwner(owner);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof Policy)) {
            return false;
        }
        Policy that = (Policy)o;
        return that.getId().equals(this.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }
}

