/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.Decision;
import org.keycloak.authorization.identity.Identity;
import org.keycloak.authorization.model.PermissionTicket;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.authorization.permission.ResourcePermission;
import org.keycloak.authorization.policy.evaluation.Result;
import org.keycloak.authorization.store.ResourceStore;
import org.keycloak.authorization.store.ScopeStore;
import org.keycloak.authorization.store.StoreFactory;
import org.keycloak.representations.idm.authorization.AuthorizationRequest;
import org.keycloak.representations.idm.authorization.Permission;
import org.keycloak.services.ErrorResponseException;

public final class Permissions {
    public static List<ResourcePermission> permission(ResourceServer server, Resource resource, Scope scope) {
        return Arrays.asList(new ResourcePermission(resource, Arrays.asList(scope), server));
    }

    public static List<ResourcePermission> all(ResourceServer resourceServer, Identity identity, AuthorizationProvider authorization, AuthorizationRequest request) {
        ArrayList<ResourcePermission> permissions = new ArrayList<ResourcePermission>();
        StoreFactory storeFactory = authorization.getStoreFactory();
        ResourceStore resourceStore = storeFactory.getResourceStore();
        resourceStore.findByOwner(resourceServer.getId(), resourceServer.getId()).stream().forEach(resource -> permissions.addAll(Permissions.createResourcePermissionsWithScopes(resource, new LinkedList<Scope>(resource.getScopes()), authorization, request)));
        resourceStore.findByOwner(identity.getId(), resourceServer.getId()).stream().forEach(resource -> permissions.addAll(Permissions.createResourcePermissionsWithScopes(resource, new LinkedList<Scope>(resource.getScopes()), authorization, request)));
        List tickets = storeFactory.getPermissionTicketStore().findGranted(identity.getId(), resourceServer.getId());
        HashMap<String, ResourcePermission> userManagedPermissions = new HashMap<String, ResourcePermission>();
        for (PermissionTicket ticket : tickets) {
            userManagedPermissions.computeIfAbsent(ticket.getResource().getId(), id -> new ResourcePermission(ticket.getResource(), new ArrayList(), resourceServer, request.getClaims()));
        }
        permissions.addAll(userManagedPermissions.values());
        return permissions;
    }

    public static ResourcePermission createResourcePermissions(Resource resource, Set<String> requestedScopes, AuthorizationProvider authorization, AuthorizationRequest request) {
        List<Object> scopes;
        String type = resource.getType();
        ResourceServer resourceServer = resource.getResourceServer();
        if (requestedScopes.isEmpty()) {
            scopes = new LinkedList(resource.getScopes());
            if (type != null && !resource.getOwner().equals(resourceServer.getId())) {
                StoreFactory storeFactory = authorization.getStoreFactory();
                ResourceStore resourceStore = storeFactory.getResourceStore();
                resourceStore.findByType(type, resourceServer.getId()).forEach(resource1 -> {
                    if (resource1.getOwner().equals(resourceServer.getId())) {
                        for (Scope typeScope : resource1.getScopes()) {
                            if (scopes.contains(typeScope)) continue;
                            scopes.add(typeScope);
                        }
                    }
                });
            }
        } else {
            ScopeStore scopeStore = authorization.getStoreFactory().getScopeStore();
            scopes = requestedScopes.stream().map(scopeName -> {
                Scope byName = scopeStore.findByName(scopeName, resource.getResourceServer().getId());
                if (byName == null) {
                    throw new ErrorResponseException("invalid_scope", "Invalid scope [" + scopeName + "].", Response.Status.BAD_REQUEST);
                }
                return byName;
            }).collect(Collectors.toList());
        }
        return new ResourcePermission(resource, scopes, resource.getResourceServer(), request.getClaims());
    }

    public static List<ResourcePermission> createResourcePermissionsWithScopes(Resource resource, List<Scope> scopes, AuthorizationProvider authorization, AuthorizationRequest request) {
        ArrayList<ResourcePermission> permissions = new ArrayList<ResourcePermission>();
        String type = resource.getType();
        ResourceServer resourceServer = resource.getResourceServer();
        if (type != null && !resource.getOwner().equals(resourceServer.getId())) {
            StoreFactory storeFactory = authorization.getStoreFactory();
            ResourceStore resourceStore = storeFactory.getResourceStore();
            resourceStore.findByType(type, resourceServer.getId()).forEach(resource1 -> {
                if (resource1.getOwner().equals(resourceServer.getId())) {
                    for (Scope typeScope : resource1.getScopes()) {
                        if (scopes.contains(typeScope)) continue;
                        scopes.add(typeScope);
                    }
                }
            });
        }
        permissions.add(new ResourcePermission(resource, scopes, resource.getResourceServer(), request.getClaims()));
        return permissions;
    }

    public static List<Permission> permits(List<Result> evaluation, AuthorizationProvider authorizationProvider, ResourceServer resourceServer) {
        return Permissions.permits(evaluation, null, authorizationProvider, resourceServer);
    }

    public static List<Permission> permits(List<Result> evaluation, AuthorizationRequest.Metadata metadata, AuthorizationProvider authorizationProvider, ResourceServer resourceServer) {
        LinkedHashMap<String, Permission> permissions = new LinkedHashMap<String, Permission>();
        for (Result result : evaluation) {
            Policy policy;
            HashSet deniedScopes = new HashSet();
            HashSet<Scope> grantedScopes = new HashSet<Scope>();
            boolean resourceDenied = false;
            ResourcePermission permission = result.getPermission();
            List results = result.getResults();
            ArrayList<Result.PolicyResult> userManagedPermissions = new ArrayList<Result.PolicyResult>();
            int deniedCount = results.size();
            Resource resource = permission.getResource();
            for (Result.PolicyResult policyResult : results) {
                policy = policyResult.getPolicy();
                Set policyScopes = policy.getScopes();
                if (Decision.Effect.PERMIT.equals((Object)policyResult.getStatus())) {
                    if (Permissions.isScopePermission(policy)) {
                        for (Scope scope : permission.getScopes()) {
                            if (!policyScopes.contains(scope)) continue;
                            grantedScopes.add(scope);
                        }
                    } else if (Permissions.isResourcePermission(policy)) {
                        grantedScopes.addAll(permission.getScopes());
                    }
                    if (resource.isOwnerManagedAccess() && "uma".equals(policy.getType())) {
                        userManagedPermissions.add(policyResult);
                    }
                    --deniedCount;
                    continue;
                }
                if (Permissions.isScopePermission(policy)) {
                    deniedScopes.addAll(policyScopes);
                    continue;
                }
                if (!Permissions.isResourcePermission(policy)) continue;
                resourceDenied = true;
                deniedScopes.addAll(resource.getScopes());
            }
            if (!deniedScopes.isEmpty()) {
                grantedScopes.removeAll(deniedScopes);
            }
            for (Result.PolicyResult policyResult : userManagedPermissions) {
                policy = policyResult.getPolicy();
                grantedScopes.addAll(policy.getScopes());
                resourceDenied = false;
            }
            if (!results.isEmpty()) {
                permission.getScopes().clear();
                permission.getScopes().addAll(grantedScopes);
            }
            if (deniedCount == 0) {
                result.setStatus(Decision.Effect.PERMIT);
                Permissions.grantPermission(authorizationProvider, permissions, permission, resourceServer, metadata);
                continue;
            }
            if (deniedCount == results.size() || resourceDenied || !deniedScopes.isEmpty() && grantedScopes.isEmpty()) {
                result.setStatus(Decision.Effect.DENY);
                continue;
            }
            result.setStatus(Decision.Effect.PERMIT);
            Permissions.grantPermission(authorizationProvider, permissions, permission, resourceServer, metadata);
        }
        return permissions.values().stream().collect(Collectors.toList());
    }

    private static boolean isResourcePermission(Policy policy) {
        return "resource".equals(policy.getType());
    }

    private static boolean isScopePermission(Policy policy) {
        return "scope".equals(policy.getType());
    }

    private static void grantPermission(AuthorizationProvider authorizationProvider, Map<String, Permission> permissions, ResourcePermission permission, ResourceServer resourceServer, AuthorizationRequest.Metadata metadata) {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        Resource resource = permission.getResource();
        Set scopes = permission.getScopes().stream().map(Scope::getName).collect(Collectors.toSet());
        if (resource != null) {
            resources.add(resource);
        } else {
            List permissionScopes = permission.getScopes();
            if (!permissionScopes.isEmpty()) {
                ResourceStore resourceStore = authorizationProvider.getStoreFactory().getResourceStore();
                resources.addAll(resourceStore.findByScope(permissionScopes.stream().map(Scope::getId).collect(Collectors.toList()), resourceServer.getId()));
            }
        }
        if (!resources.isEmpty()) {
            for (Resource allowedResource : resources) {
                String resourceId = allowedResource.getId();
                String resourceName = metadata == null || metadata.getIncludeResourceName() != false ? allowedResource.getName() : null;
                Permission evalPermission = permissions.get(allowedResource.getId());
                if (evalPermission == null) {
                    evalPermission = new Permission(resourceId, resourceName, scopes, permission.getClaims());
                    permissions.put(resourceId, evalPermission);
                }
                if (scopes == null || scopes.isEmpty()) continue;
                HashSet<String> finalScopes = evalPermission.getScopes();
                if (finalScopes == null) {
                    finalScopes = new HashSet<String>();
                    evalPermission.setScopes(finalScopes);
                }
                for (String scopeName : scopes) {
                    if (finalScopes.contains(scopeName)) continue;
                    finalScopes.add(scopeName);
                }
            }
        } else {
            Permission scopePermission = new Permission(null, null, scopes, permission.getClaims());
            permissions.put(scopePermission.toString(), scopePermission);
        }
    }
}

