/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.entities;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.marshall.SerializeWith;
import org.jboss.logging.Logger;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.sessions.infinispan.changes.SessionEntityWrapper;
import org.keycloak.models.sessions.infinispan.entities.AuthenticatedClientSessionStore;
import org.keycloak.models.sessions.infinispan.entities.SessionEntity;
import org.keycloak.models.sessions.infinispan.util.KeycloakMarshallUtil;

@SerializeWith(value=ExternalizerImpl.class)
public class UserSessionEntity
extends SessionEntity {
    public static final Logger logger = Logger.getLogger(UserSessionEntity.class);
    public static final String LAST_SESSION_REFRESH_REMOTE = "lsrr";
    private String id;
    private String user;
    private String brokerSessionId;
    private String brokerUserId;
    private String loginUsername;
    private String ipAddress;
    private String authMethod;
    private boolean rememberMe;
    private int started;
    private int lastSessionRefresh;
    private UserSessionModel.State state;
    private Map<String, String> notes = new ConcurrentHashMap<String, String>();
    private AuthenticatedClientSessionStore authenticatedClientSessions = new AuthenticatedClientSessionStore();

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getLoginUsername() {
        return this.loginUsername;
    }

    public void setLoginUsername(String loginUsername) {
        this.loginUsername = loginUsername;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public String getAuthMethod() {
        return this.authMethod;
    }

    public void setAuthMethod(String authMethod) {
        this.authMethod = authMethod;
    }

    public boolean isRememberMe() {
        return this.rememberMe;
    }

    public void setRememberMe(boolean rememberMe) {
        this.rememberMe = rememberMe;
    }

    public int getStarted() {
        return this.started;
    }

    public void setStarted(int started) {
        this.started = started;
    }

    public int getLastSessionRefresh() {
        return this.lastSessionRefresh;
    }

    public void setLastSessionRefresh(int lastSessionRefresh) {
        this.lastSessionRefresh = lastSessionRefresh;
    }

    public Map<String, String> getNotes() {
        return this.notes;
    }

    public void setNotes(Map<String, String> notes) {
        this.notes = notes;
    }

    public AuthenticatedClientSessionStore getAuthenticatedClientSessions() {
        return this.authenticatedClientSessions;
    }

    public void setAuthenticatedClientSessions(AuthenticatedClientSessionStore authenticatedClientSessions) {
        this.authenticatedClientSessions = authenticatedClientSessions;
    }

    public UserSessionModel.State getState() {
        return this.state;
    }

    public void setState(UserSessionModel.State state) {
        this.state = state;
    }

    public String getBrokerSessionId() {
        return this.brokerSessionId;
    }

    public void setBrokerSessionId(String brokerSessionId) {
        this.brokerSessionId = brokerSessionId;
    }

    public String getBrokerUserId() {
        return this.brokerUserId;
    }

    public void setBrokerUserId(String brokerUserId) {
        this.brokerUserId = brokerUserId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UserSessionEntity)) {
            return false;
        }
        UserSessionEntity that = (UserSessionEntity)o;
        return !(this.id != null ? !this.id.equals(that.id) : that.id != null);
    }

    @Override
    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }

    public String toString() {
        return String.format("UserSessionEntity [id=%s, realm=%s, lastSessionRefresh=%d, clients=%s]", this.getId(), this.getRealmId(), this.getLastSessionRefresh(), new TreeSet<String>(this.authenticatedClientSessions.keySet()));
    }

    @Override
    public SessionEntityWrapper mergeRemoteEntityWithLocalEntity(SessionEntityWrapper localEntityWrapper) {
        SessionEntityWrapper<UserSessionEntity> entityWrapper;
        int lsrRemote = this.getLastSessionRefresh();
        if (localEntityWrapper == null) {
            entityWrapper = new SessionEntityWrapper<UserSessionEntity>(this);
        } else {
            UserSessionEntity localUserSession = (UserSessionEntity)localEntityWrapper.getEntity();
            if (lsrRemote < localUserSession.getLastSessionRefresh()) {
                this.setLastSessionRefresh(localUserSession.getLastSessionRefresh());
            }
            entityWrapper = new SessionEntityWrapper<UserSessionEntity>(localEntityWrapper.getLocalMetadata(), this);
        }
        entityWrapper.putLocalMetadataNoteInt(LAST_SESSION_REFRESH_REMOTE, lsrRemote);
        logger.debugf("Updating session entity '%s'. lastSessionRefresh=%d, lastSessionRefreshRemote=%d", (Object)this.getId(), (Object)this.getLastSessionRefresh(), (Object)lsrRemote);
        return entityWrapper;
    }

    public static class ExternalizerImpl
    implements Externalizer<UserSessionEntity> {
        private static final int VERSION_1 = 1;
        private static final EnumMap<UserSessionModel.State, Integer> STATE_TO_ID = new EnumMap(UserSessionModel.State.class);
        private static final Map<Integer, UserSessionModel.State> ID_TO_STATE = new HashMap<Integer, UserSessionModel.State>();

        public void writeObject(ObjectOutput output, UserSessionEntity session) throws IOException {
            output.writeByte(1);
            MarshallUtil.marshallString((String)session.getAuthMethod(), (ObjectOutput)output);
            MarshallUtil.marshallString((String)session.getBrokerSessionId(), (ObjectOutput)output);
            MarshallUtil.marshallString((String)session.getBrokerUserId(), (ObjectOutput)output);
            MarshallUtil.marshallString((String)session.getId(), (ObjectOutput)output);
            MarshallUtil.marshallString((String)session.getIpAddress(), (ObjectOutput)output);
            MarshallUtil.marshallString((String)session.getLoginUsername(), (ObjectOutput)output);
            MarshallUtil.marshallString((String)session.getRealmId(), (ObjectOutput)output);
            MarshallUtil.marshallString((String)session.getUser(), (ObjectOutput)output);
            MarshallUtil.marshallInt((ObjectOutput)output, (int)session.getLastSessionRefresh());
            MarshallUtil.marshallInt((ObjectOutput)output, (int)session.getStarted());
            output.writeBoolean(session.isRememberMe());
            int state = session.getState() == null ? 0 : STATE_TO_ID.get(session.getState());
            output.writeInt(state);
            Map<String, String> notes = session.getNotes();
            KeycloakMarshallUtil.writeMap(notes, KeycloakMarshallUtil.STRING_EXT, KeycloakMarshallUtil.STRING_EXT, output);
            output.writeObject(session.getAuthenticatedClientSessions());
        }

        public UserSessionEntity readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            switch (input.readByte()) {
                case 1: {
                    return this.readObjectVersion1(input);
                }
            }
            throw new IOException("Unknown version");
        }

        public UserSessionEntity readObjectVersion1(ObjectInput input) throws IOException, ClassNotFoundException {
            UserSessionEntity sessionEntity = new UserSessionEntity();
            sessionEntity.setAuthMethod(MarshallUtil.unmarshallString((ObjectInput)input));
            sessionEntity.setBrokerSessionId(MarshallUtil.unmarshallString((ObjectInput)input));
            sessionEntity.setBrokerUserId(MarshallUtil.unmarshallString((ObjectInput)input));
            String userSessionId = MarshallUtil.unmarshallString((ObjectInput)input);
            sessionEntity.setId(userSessionId);
            sessionEntity.setIpAddress(MarshallUtil.unmarshallString((ObjectInput)input));
            sessionEntity.setLoginUsername(MarshallUtil.unmarshallString((ObjectInput)input));
            sessionEntity.setRealmId(MarshallUtil.unmarshallString((ObjectInput)input));
            sessionEntity.setUser(MarshallUtil.unmarshallString((ObjectInput)input));
            sessionEntity.setLastSessionRefresh(MarshallUtil.unmarshallInt((ObjectInput)input));
            sessionEntity.setStarted(MarshallUtil.unmarshallInt((ObjectInput)input));
            sessionEntity.setRememberMe(input.readBoolean());
            sessionEntity.setState(ID_TO_STATE.get(input.readInt()));
            Object notes = KeycloakMarshallUtil.readMap(input, KeycloakMarshallUtil.STRING_EXT, KeycloakMarshallUtil.STRING_EXT, new KeycloakMarshallUtil.ConcurrentHashMapBuilder());
            sessionEntity.setNotes((Map<String, String>)notes);
            AuthenticatedClientSessionStore authSessions = (AuthenticatedClientSessionStore)input.readObject();
            sessionEntity.setAuthenticatedClientSessions(authSessions);
            return sessionEntity;
        }

        static {
            STATE_TO_ID.put(UserSessionModel.State.LOGGED_IN, 1);
            STATE_TO_ID.put(UserSessionModel.State.LOGGED_OUT, 2);
            STATE_TO_ID.put(UserSessionModel.State.LOGGING_OUT, 3);
            for (Map.Entry<UserSessionModel.State, Integer> entry : STATE_TO_ID.entrySet()) {
                ID_TO_STATE.put(entry.getValue(), entry.getKey());
            }
        }
    }
}

