/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.policy.evaluation;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.Decision;
import org.keycloak.authorization.identity.Identity;
import org.keycloak.authorization.model.PermissionTicket;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.authorization.permission.ResourcePermission;
import org.keycloak.authorization.policy.evaluation.DecisionResultCollector;
import org.keycloak.authorization.policy.evaluation.DefaultEvaluation;
import org.keycloak.authorization.policy.evaluation.Result;
import org.keycloak.authorization.store.ResourceStore;
import org.keycloak.authorization.store.ScopeStore;
import org.keycloak.authorization.store.StoreFactory;
import org.keycloak.representations.idm.authorization.AuthorizationRequest;
import org.keycloak.representations.idm.authorization.PermissionTicketToken;

public class PermissionTicketAwareDecisionResultCollector
extends DecisionResultCollector {
    private final AuthorizationRequest request;
    private PermissionTicketToken ticket;
    private final Identity identity;
    private ResourceServer resourceServer;
    private final AuthorizationProvider authorization;
    private List<Result> results;

    public PermissionTicketAwareDecisionResultCollector(AuthorizationRequest request, PermissionTicketToken ticket, Identity identity, ResourceServer resourceServer, AuthorizationProvider authorization) {
        this.request = request;
        this.ticket = ticket;
        this.identity = identity;
        this.resourceServer = resourceServer;
        this.authorization = authorization;
    }

    @Override
    public void onDecision(DefaultEvaluation evaluation) {
        super.onDecision(evaluation);
        this.removePermissionsIfGranted(evaluation);
    }

    private void removePermissionsIfGranted(DefaultEvaluation evaluation) {
        Policy policy;
        if (Decision.Effect.PERMIT.equals((Object)evaluation.getEffect()) && "uma".equals((policy = evaluation.getParentPolicy()).getType())) {
            ResourcePermission grantedPermission = evaluation.getPermission();
            List permissions = this.ticket.getResources();
            Iterator itPermissions = permissions.iterator();
            while (itPermissions.hasNext()) {
                PermissionTicketToken.ResourcePermission permission = (PermissionTicketToken.ResourcePermission)itPermissions.next();
                if (!permission.getResourceId().equals(grantedPermission.getResource().getId())) continue;
                Set scopes = permission.getScopes();
                Iterator itScopes = scopes.iterator();
                while (itScopes.hasNext()) {
                    Scope scope = this.authorization.getStoreFactory().getScopeStore().findByName((String)itScopes.next(), this.resourceServer.getId());
                    if (!policy.getScopes().contains(scope)) continue;
                    itScopes.remove();
                }
                if (!scopes.isEmpty()) continue;
                itPermissions.remove();
            }
        }
    }

    @Override
    public void onComplete() {
        super.onComplete();
        if (this.request.isSubmitRequest()) {
            StoreFactory storeFactory = this.authorization.getStoreFactory();
            ResourceStore resourceStore = storeFactory.getResourceStore();
            List permissions = this.ticket.getResources();
            if (permissions != null) {
                for (PermissionTicketToken.ResourcePermission permission : permissions) {
                    Resource resource = resourceStore.findById(permission.getResourceId(), this.resourceServer.getId());
                    if (resource == null) {
                        resource = resourceStore.findByName(permission.getResourceId(), this.identity.getId(), this.resourceServer.getId());
                    }
                    if (resource == null || !resource.isOwnerManagedAccess() || resource.getOwner().equals(this.identity.getId()) || resource.getOwner().equals(this.resourceServer.getId())) continue;
                    Set scopes = permission.getScopes();
                    if (scopes.isEmpty()) {
                        scopes = resource.getScopes().stream().map(Scope::getName).collect(Collectors.toSet());
                    }
                    if (scopes.isEmpty()) {
                        HashMap<String, String> filters = new HashMap<String, String>();
                        filters.put("resource.id", resource.getId());
                        filters.put("requester", this.identity.getId());
                        filters.put("scope_is_null", Boolean.TRUE.toString());
                        List<PermissionTicket> tickets = this.authorization.getStoreFactory().getPermissionTicketStore().find(filters, resource.getResourceServer().getId(), -1, -1);
                        if (!tickets.isEmpty()) continue;
                        this.authorization.getStoreFactory().getPermissionTicketStore().create(resource.getId(), null, this.identity.getId(), resource.getResourceServer());
                        continue;
                    }
                    ScopeStore scopeStore = this.authorization.getStoreFactory().getScopeStore();
                    for (String scopeId : scopes) {
                        Scope scope = scopeStore.findByName(scopeId, this.resourceServer.getId());
                        if (scope == null) {
                            scope = scopeStore.findById(scopeId, this.resourceServer.getId());
                        }
                        HashMap<String, String> filters = new HashMap<String, String>();
                        filters.put("resource.id", resource.getId());
                        filters.put("requester", this.identity.getId());
                        filters.put("scope.id", scope.getId());
                        List<PermissionTicket> tickets = this.authorization.getStoreFactory().getPermissionTicketStore().find(filters, resource.getResourceServer().getId(), -1, -1);
                        if (!tickets.isEmpty()) continue;
                        this.authorization.getStoreFactory().getPermissionTicketStore().create(resource.getId(), scope.getId(), this.identity.getId(), resource.getResourceServer());
                    }
                }
            }
        }
    }

    @Override
    protected void onComplete(List<Result> results) {
        this.results = results;
    }

    public List<Result> results() {
        return this.results;
    }
}

