/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.saml;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicNameValuePair;
import org.jboss.logging.Logger;
import org.keycloak.connections.httpclient.HttpClientProvider;
import org.keycloak.dom.saml.v2.assertion.AssertionType;
import org.keycloak.dom.saml.v2.assertion.AttributeStatementType;
import org.keycloak.dom.saml.v2.assertion.StatementAbstractType;
import org.keycloak.dom.saml.v2.protocol.ResponseType;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientSessionContext;
import org.keycloak.models.KeyManager;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.LoginProtocol;
import org.keycloak.protocol.ProtocolMapper;
import org.keycloak.protocol.saml.JaxrsSAML2BindingBuilder;
import org.keycloak.protocol.saml.SamlClient;
import org.keycloak.protocol.saml.SamlProtocolUtils;
import org.keycloak.protocol.saml.SamlService;
import org.keycloak.protocol.saml.SamlSessionUtils;
import org.keycloak.protocol.saml.mappers.SAMLAttributeStatementMapper;
import org.keycloak.protocol.saml.mappers.SAMLLoginResponseMapper;
import org.keycloak.protocol.saml.mappers.SAMLRoleListMapper;
import org.keycloak.saml.SAML2ErrorResponseBuilder;
import org.keycloak.saml.SAML2LoginResponseBuilder;
import org.keycloak.saml.SAML2LogoutRequestBuilder;
import org.keycloak.saml.SAML2LogoutResponseBuilder;
import org.keycloak.saml.SamlProtocolExtensionsAwareBuilder;
import org.keycloak.saml.SignatureAlgorithm;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;
import org.keycloak.saml.common.exceptions.ConfigurationException;
import org.keycloak.saml.common.exceptions.ParsingException;
import org.keycloak.saml.common.exceptions.ProcessingException;
import org.keycloak.saml.common.util.XmlKeyInfoKeyNameTransformer;
import org.keycloak.saml.processing.core.util.KeycloakKeySamlExtensionGenerator;
import org.keycloak.services.ErrorPage;
import org.keycloak.services.managers.AuthenticationSessionManager;
import org.keycloak.services.managers.ResourceAdminManager;
import org.keycloak.services.resources.RealmsResource;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.sessions.CommonClientSessionModel;
import org.w3c.dom.Document;

public class SamlProtocol
implements LoginProtocol {
    protected static final Logger logger = Logger.getLogger(SamlProtocol.class);
    public static final String ATTRIBUTE_TRUE_VALUE = "true";
    public static final String ATTRIBUTE_FALSE_VALUE = "false";
    public static final String SAML_ASSERTION_CONSUMER_URL_POST_ATTRIBUTE = "saml_assertion_consumer_url_post";
    public static final String SAML_ASSERTION_CONSUMER_URL_REDIRECT_ATTRIBUTE = "saml_assertion_consumer_url_redirect";
    public static final String SAML_SINGLE_LOGOUT_SERVICE_URL_POST_ATTRIBUTE = "saml_single_logout_service_url_post";
    public static final String SAML_SINGLE_LOGOUT_SERVICE_URL_REDIRECT_ATTRIBUTE = "saml_single_logout_service_url_redirect";
    public static final String LOGIN_PROTOCOL = "saml";
    public static final String SAML_BINDING = "saml_binding";
    public static final String SAML_IDP_INITIATED_LOGIN = "saml_idp_initiated_login";
    public static final String SAML_POST_BINDING = "post";
    public static final String SAML_SOAP_BINDING = "soap";
    public static final String SAML_REDIRECT_BINDING = "get";
    public static final String SAML_REQUEST_ID = "SAML_REQUEST_ID";
    public static final String SAML_LOGOUT_BINDING = "saml.logout.binding";
    public static final String SAML_LOGOUT_ADD_EXTENSIONS_ELEMENT_WITH_KEY_INFO = "saml.logout.addExtensionsElementWithKeyInfo";
    public static final String SAML_SERVER_SIGNATURE_KEYINFO_KEY_NAME_TRANSFORMER = "SAML_SERVER_SIGNATURE_KEYINFO_KEY_NAME_TRANSFORMER";
    public static final String SAML_LOGOUT_REQUEST_ID = "SAML_LOGOUT_REQUEST_ID";
    public static final String SAML_LOGOUT_RELAY_STATE = "SAML_LOGOUT_RELAY_STATE";
    public static final String SAML_LOGOUT_CANONICALIZATION = "SAML_LOGOUT_CANONICALIZATION";
    public static final String SAML_LOGOUT_BINDING_URI = "SAML_LOGOUT_BINDING_URI";
    public static final String SAML_LOGOUT_SIGNATURE_ALGORITHM = "saml.logout.signature.algorithm";
    public static final String SAML_NAME_ID = "SAML_NAME_ID";
    public static final String SAML_NAME_ID_FORMAT = "SAML_NAME_ID_FORMAT";
    public static final String SAML_DEFAULT_NAMEID_FORMAT = JBossSAMLURIConstants.NAMEID_FORMAT_UNSPECIFIED.get();
    public static final String SAML_PERSISTENT_NAME_ID_FOR = "saml.persistent.name.id.for";
    public static final String SAML_IDP_INITIATED_SSO_RELAY_STATE = "saml_idp_initiated_sso_relay_state";
    public static final String SAML_IDP_INITIATED_SSO_URL_NAME = "saml_idp_initiated_sso_url_name";
    protected KeycloakSession session;
    protected RealmModel realm;
    protected UriInfo uriInfo;
    protected HttpHeaders headers;
    protected EventBuilder event;

    public SamlProtocol setSession(KeycloakSession session) {
        this.session = session;
        return this;
    }

    public SamlProtocol setRealm(RealmModel realm) {
        this.realm = realm;
        return this;
    }

    public SamlProtocol setUriInfo(UriInfo uriInfo) {
        this.uriInfo = uriInfo;
        return this;
    }

    public SamlProtocol setHttpHeaders(HttpHeaders headers) {
        this.headers = headers;
        return this;
    }

    public SamlProtocol setEventBuilder(EventBuilder event) {
        this.event = event;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response sendError(AuthenticationSessionModel authSession, LoginProtocol.Error error) {
        try {
            ClientModel client = authSession.getClient();
            if (ATTRIBUTE_TRUE_VALUE.equals(authSession.getClientNote(SAML_IDP_INITIATED_LOGIN))) {
                if (error == LoginProtocol.Error.CANCELLED_BY_USER) {
                    UriBuilder builder = RealmsResource.protocolUrl(this.uriInfo).path(SamlService.class, "idpInitiatedSSO");
                    HashMap<String, String> params = new HashMap<String, String>();
                    params.put("realm", this.realm.getName());
                    params.put("protocol", LOGIN_PROTOCOL);
                    params.put("client", client.getAttribute(SAML_IDP_INITIATED_SSO_URL_NAME));
                    URI redirect = builder.buildFromMap(params);
                    Response response = Response.status((int)302).location(redirect).build();
                    return response;
                }
                Response response = ErrorPage.error(this.session, authSession, Response.Status.BAD_REQUEST, this.translateErrorToIdpInitiatedErrorMessage(error), new Object[0]);
                return response;
            }
            Response response = this.samlErrorMessage(authSession, new SamlClient(client), this.isPostBinding(authSession), authSession.getRedirectUri(), this.translateErrorToSAMLStatus(error), authSession.getClientNote("RelayState"));
            return response;
        }
        finally {
            new AuthenticationSessionManager(this.session).removeAuthenticationSession(this.realm, authSession, true);
        }
    }

    private Response samlErrorMessage(AuthenticationSessionModel authSession, SamlClient samlClient, boolean isPostBinding, String destination, JBossSAMLURIConstants statusDetail, String relayState) {
        JaxrsSAML2BindingBuilder binding = (JaxrsSAML2BindingBuilder)new JaxrsSAML2BindingBuilder().relayState(relayState);
        SAML2ErrorResponseBuilder builder = new SAML2ErrorResponseBuilder().destination(destination).issuer(this.getResponseIssuer(this.realm)).status(statusDetail.get());
        KeyManager keyManager = this.session.keys();
        if (samlClient.requiresRealmSignature()) {
            KeyManager.ActiveRsaKey keys = keyManager.getActiveRsaKey(this.realm);
            String keyName = samlClient.getXmlSigKeyInfoKeyNameTransformer().getKeyName(keys.getKid(), keys.getCertificate());
            String canonicalization = samlClient.getCanonicalizationMethod();
            if (canonicalization != null) {
                binding.canonicalizationMethod(canonicalization);
            }
            ((JaxrsSAML2BindingBuilder)((JaxrsSAML2BindingBuilder)binding.signatureAlgorithm(samlClient.getSignatureAlgorithm())).signWith(keyName, keys.getPrivateKey(), keys.getPublicKey(), keys.getCertificate())).signDocument();
        }
        try {
            Document document = builder.buildDocument();
            return this.buildErrorResponse(isPostBinding, destination, binding, document);
        }
        catch (Exception e) {
            return ErrorPage.error(this.session, authSession, Response.Status.BAD_REQUEST, "failedToProcessResponseMessage", new Object[0]);
        }
    }

    protected Response buildErrorResponse(boolean isPostBinding, String destination, JaxrsSAML2BindingBuilder binding, Document document) throws ConfigurationException, ProcessingException, IOException {
        if (isPostBinding) {
            return binding.postBinding(document).response(destination);
        }
        return binding.redirectBinding(document).response(destination);
    }

    private JBossSAMLURIConstants translateErrorToSAMLStatus(LoginProtocol.Error error) {
        switch (error) {
            case CANCELLED_BY_USER: 
            case CONSENT_DENIED: {
                return JBossSAMLURIConstants.STATUS_REQUEST_DENIED;
            }
            case PASSIVE_INTERACTION_REQUIRED: 
            case PASSIVE_LOGIN_REQUIRED: {
                return JBossSAMLURIConstants.STATUS_NO_PASSIVE;
            }
        }
        logger.warn((Object)("Untranslated protocol Error: " + error.name() + " so we return default SAML error"));
        return JBossSAMLURIConstants.STATUS_REQUEST_DENIED;
    }

    private String translateErrorToIdpInitiatedErrorMessage(LoginProtocol.Error error) {
        switch (error) {
            case CONSENT_DENIED: {
                return "consentDenied";
            }
            case PASSIVE_INTERACTION_REQUIRED: 
            case PASSIVE_LOGIN_REQUIRED: {
                return "unexpectedErrorHandlingRequestMessage";
            }
        }
        logger.warn((Object)("Untranslated protocol Error: " + error.name() + " so we return default error message"));
        return "unexpectedErrorHandlingRequestMessage";
    }

    protected String getResponseIssuer(RealmModel realm) {
        return RealmsResource.realmBaseUrl(this.uriInfo).build(new Object[]{realm.getName()}).toString();
    }

    protected boolean isPostBinding(AuthenticationSessionModel authSession) {
        ClientModel client = authSession.getClient();
        SamlClient samlClient = new SamlClient(client);
        return SAML_POST_BINDING.equals(authSession.getClientNote(SAML_BINDING)) || samlClient.forcePostBinding();
    }

    protected boolean isPostBinding(AuthenticatedClientSessionModel clientSession) {
        ClientModel client = clientSession.getClient();
        SamlClient samlClient = new SamlClient(client);
        return SAML_POST_BINDING.equals(clientSession.getNote(SAML_BINDING)) || samlClient.forcePostBinding();
    }

    public static boolean isLogoutPostBindingForInitiator(UserSessionModel session) {
        String note = session.getNote(SAML_LOGOUT_BINDING);
        return SAML_POST_BINDING.equals(note);
    }

    protected boolean isLogoutPostBindingForClient(AuthenticatedClientSessionModel clientSession) {
        ClientModel client = clientSession.getClient();
        SamlClient samlClient = new SamlClient(client);
        String logoutPostUrl = client.getAttribute(SAML_SINGLE_LOGOUT_SERVICE_URL_POST_ATTRIBUTE);
        String logoutRedirectUrl = client.getAttribute(SAML_SINGLE_LOGOUT_SERVICE_URL_REDIRECT_ATTRIBUTE);
        if (logoutPostUrl == null || logoutPostUrl.trim().isEmpty()) {
            return logoutRedirectUrl == null || logoutRedirectUrl.trim().isEmpty();
        }
        if (samlClient.forcePostBinding()) {
            return true;
        }
        String bindingType = clientSession.getNote(SAML_BINDING);
        if (SAML_POST_BINDING.equals(bindingType)) {
            return true;
        }
        return logoutRedirectUrl == null || logoutRedirectUrl.trim().isEmpty();
    }

    protected String getNameIdFormat(SamlClient samlClient, AuthenticatedClientSessionModel clientSession) {
        String nameIdFormat = clientSession.getNote("NAMEID_FORMAT");
        boolean forceFormat = samlClient.forceNameIDFormat();
        String configuredNameIdFormat = samlClient.getNameIDFormat();
        if ((nameIdFormat == null || forceFormat) && configuredNameIdFormat != null) {
            nameIdFormat = configuredNameIdFormat;
        }
        if (nameIdFormat == null) {
            return SAML_DEFAULT_NAMEID_FORMAT;
        }
        return nameIdFormat;
    }

    protected String getNameId(String nameIdFormat, CommonClientSessionModel clientSession, UserSessionModel userSession) {
        if (nameIdFormat.equals(JBossSAMLURIConstants.NAMEID_FORMAT_EMAIL.get())) {
            String email = userSession.getUser().getEmail();
            if (email == null) {
                logger.debugf("E-mail of the user %s has to be set for %s NameIDFormat", (Object)userSession.getUser().getUsername(), (Object)JBossSAMLURIConstants.NAMEID_FORMAT_EMAIL.get());
            }
            return email;
        }
        if (nameIdFormat.equals(JBossSAMLURIConstants.NAMEID_FORMAT_TRANSIENT.get())) {
            return "G-" + UUID.randomUUID().toString();
        }
        if (nameIdFormat.equals(JBossSAMLURIConstants.NAMEID_FORMAT_PERSISTENT.get())) {
            return this.getPersistentNameId(clientSession, userSession);
        }
        if (nameIdFormat.equals(JBossSAMLURIConstants.NAMEID_FORMAT_UNSPECIFIED.get())) {
            return userSession.getUser().getUsername();
        }
        return userSession.getUser().getUsername();
    }

    protected String getPersistentNameId(CommonClientSessionModel clientSession, UserSessionModel userSession) {
        UserModel user = userSession.getUser();
        String clientNameId = String.format("%s.%s", SAML_PERSISTENT_NAME_ID_FOR, clientSession.getClient().getClientId());
        String samlPersistentNameId = user.getFirstAttribute(clientNameId);
        if (samlPersistentNameId != null) {
            return samlPersistentNameId;
        }
        String wildcardNameId = String.format("%s.*", SAML_PERSISTENT_NAME_ID_FOR);
        samlPersistentNameId = user.getFirstAttribute(wildcardNameId);
        if (samlPersistentNameId != null) {
            return samlPersistentNameId;
        }
        samlPersistentNameId = "G-" + UUID.randomUUID().toString();
        user.setSingleAttribute(clientNameId, samlPersistentNameId);
        return samlPersistentNameId;
    }

    public Response authenticated(UserSessionModel userSession, ClientSessionContext clientSessionCtx) {
        String canonicalization;
        AuthenticatedClientSessionModel clientSession = clientSessionCtx.getClientSession();
        ClientModel client = clientSession.getClient();
        SamlClient samlClient = new SamlClient(client);
        String requestID = clientSession.getNote(SAML_REQUEST_ID);
        String relayState = clientSession.getNote("RelayState");
        String redirectUri = clientSession.getRedirectUri();
        String responseIssuer = this.getResponseIssuer(this.realm);
        String nameIdFormat = this.getNameIdFormat(samlClient, clientSession);
        String nameId = this.getNameId(nameIdFormat, (CommonClientSessionModel)clientSession, userSession);
        if (nameId == null) {
            return this.samlErrorMessage(null, samlClient, this.isPostBinding(clientSession), redirectUri, JBossSAMLURIConstants.STATUS_INVALID_NAMEIDPOLICY, relayState);
        }
        clientSession.setNote(SAML_NAME_ID, nameId);
        clientSession.setNote(SAML_NAME_ID_FORMAT, nameIdFormat);
        SAML2LoginResponseBuilder builder = new SAML2LoginResponseBuilder();
        builder.requestID(requestID).destination(redirectUri).issuer(responseIssuer).assertionExpiration(this.realm.getAccessCodeLifespan()).subjectExpiration(this.realm.getAccessTokenLifespan()).requestIssuer(clientSession.getClient().getClientId()).nameIdentifier(nameIdFormat, nameId).authMethod(JBossSAMLURIConstants.AC_UNSPECIFIED.get());
        String sessionIndex = SamlSessionUtils.getSessionIndex(clientSession);
        builder.sessionIndex(sessionIndex);
        if (!samlClient.includeAuthnStatement()) {
            builder.disableAuthnStatement(true);
        }
        builder.includeOneTimeUseCondition(samlClient.includeOneTimeUseCondition());
        LinkedList<ProtocolMapperProcessor<SAMLAttributeStatementMapper>> attributeStatementMappers = new LinkedList<ProtocolMapperProcessor<SAMLAttributeStatementMapper>>();
        LinkedList<ProtocolMapperProcessor<SAMLLoginResponseMapper>> loginResponseMappers = new LinkedList<ProtocolMapperProcessor<SAMLLoginResponseMapper>>();
        ProtocolMapperProcessor<SAMLRoleListMapper> roleListMapper = null;
        Set mappings = clientSessionCtx.getProtocolMappers();
        for (ProtocolMapperModel mapping : mappings) {
            ProtocolMapper mapper = (ProtocolMapper)this.session.getKeycloakSessionFactory().getProviderFactory(ProtocolMapper.class, mapping.getProtocolMapper());
            if (mapper == null) continue;
            if (mapper instanceof SAMLAttributeStatementMapper) {
                attributeStatementMappers.add(new ProtocolMapperProcessor<SAMLAttributeStatementMapper>((SAMLAttributeStatementMapper)mapper, mapping));
            }
            if (mapper instanceof SAMLLoginResponseMapper) {
                loginResponseMappers.add(new ProtocolMapperProcessor<SAMLLoginResponseMapper>((SAMLLoginResponseMapper)mapper, mapping));
            }
            if (!(mapper instanceof SAMLRoleListMapper)) continue;
            roleListMapper = new ProtocolMapperProcessor<SAMLRoleListMapper>((SAMLRoleListMapper)mapper, mapping);
        }
        Document samlDocument = null;
        KeyManager keyManager = this.session.keys();
        KeyManager.ActiveRsaKey keys = keyManager.getActiveRsaKey(this.realm);
        boolean postBinding = this.isPostBinding(clientSession);
        String keyName = samlClient.getXmlSigKeyInfoKeyNameTransformer().getKeyName(keys.getKid(), keys.getCertificate());
        try {
            if (!postBinding && samlClient.requiresRealmSignature() && samlClient.addExtensionsElementWithKeyInfo()) {
                builder.addExtension((SamlProtocolExtensionsAwareBuilder.NodeGenerator)new KeycloakKeySamlExtensionGenerator(keyName));
            }
            ResponseType samlModel = builder.buildModel();
            AttributeStatementType attributeStatement = this.populateAttributeStatements(attributeStatementMappers, this.session, userSession, clientSession);
            this.populateRoles(roleListMapper, this.session, userSession, clientSessionCtx, attributeStatement);
            if (attributeStatement.getAttributes().size() > 0) {
                AssertionType assertion = ((ResponseType.RTChoiceType)samlModel.getAssertions().get(0)).getAssertion();
                assertion.addStatement((StatementAbstractType)attributeStatement);
            }
            samlModel = this.transformLoginResponse(loginResponseMappers, samlModel, this.session, userSession, clientSession);
            samlDocument = builder.buildDocument(samlModel);
        }
        catch (Exception e) {
            logger.error((Object)"failed", (Throwable)e);
            return ErrorPage.error(this.session, null, Response.Status.BAD_REQUEST, "failedToProcessResponseMessage", new Object[0]);
        }
        JaxrsSAML2BindingBuilder bindingBuilder = new JaxrsSAML2BindingBuilder();
        bindingBuilder.relayState(relayState);
        if (samlClient.requiresRealmSignature()) {
            canonicalization = samlClient.getCanonicalizationMethod();
            if (canonicalization != null) {
                bindingBuilder.canonicalizationMethod(canonicalization);
            }
            ((JaxrsSAML2BindingBuilder)((JaxrsSAML2BindingBuilder)bindingBuilder.signatureAlgorithm(samlClient.getSignatureAlgorithm())).signWith(keyName, keys.getPrivateKey(), keys.getPublicKey(), keys.getCertificate())).signDocument();
        }
        if (samlClient.requiresAssertionSignature()) {
            canonicalization = samlClient.getCanonicalizationMethod();
            if (canonicalization != null) {
                bindingBuilder.canonicalizationMethod(canonicalization);
            }
            ((JaxrsSAML2BindingBuilder)((JaxrsSAML2BindingBuilder)bindingBuilder.signatureAlgorithm(samlClient.getSignatureAlgorithm())).signWith(keyName, keys.getPrivateKey(), keys.getPublicKey(), keys.getCertificate())).signAssertions();
        }
        if (samlClient.requiresEncryption()) {
            PublicKey publicKey = null;
            try {
                publicKey = SamlProtocolUtils.getEncryptionKey(client);
            }
            catch (Exception e) {
                logger.error((Object)"failed", (Throwable)e);
                return ErrorPage.error(this.session, null, Response.Status.BAD_REQUEST, "failedToProcessResponseMessage", new Object[0]);
            }
            bindingBuilder.encrypt(publicKey);
        }
        try {
            return this.buildAuthenticatedResponse(clientSession, redirectUri, samlDocument, bindingBuilder);
        }
        catch (Exception e) {
            logger.error((Object)"failed", (Throwable)e);
            return ErrorPage.error(this.session, null, Response.Status.BAD_REQUEST, "failedToProcessResponseMessage", new Object[0]);
        }
    }

    protected Response buildAuthenticatedResponse(AuthenticatedClientSessionModel clientSession, String redirectUri, Document samlDocument, JaxrsSAML2BindingBuilder bindingBuilder) throws ConfigurationException, ProcessingException, IOException {
        if (this.isPostBinding(clientSession)) {
            return bindingBuilder.postBinding(samlDocument).response(redirectUri);
        }
        return bindingBuilder.redirectBinding(samlDocument).response(redirectUri);
    }

    public AttributeStatementType populateAttributeStatements(List<ProtocolMapperProcessor<SAMLAttributeStatementMapper>> attributeStatementMappers, KeycloakSession session, UserSessionModel userSession, AuthenticatedClientSessionModel clientSession) {
        AttributeStatementType attributeStatement = new AttributeStatementType();
        for (ProtocolMapperProcessor<SAMLAttributeStatementMapper> processor : attributeStatementMappers) {
            ((SAMLAttributeStatementMapper)processor.mapper).transformAttributeStatement(attributeStatement, processor.model, session, userSession, clientSession);
        }
        return attributeStatement;
    }

    public ResponseType transformLoginResponse(List<ProtocolMapperProcessor<SAMLLoginResponseMapper>> mappers, ResponseType response, KeycloakSession session, UserSessionModel userSession, AuthenticatedClientSessionModel clientSession) {
        for (ProtocolMapperProcessor<SAMLLoginResponseMapper> processor : mappers) {
            response = ((SAMLLoginResponseMapper)processor.mapper).transformLoginResponse(response, processor.model, session, userSession, clientSession);
        }
        return response;
    }

    public void populateRoles(ProtocolMapperProcessor<SAMLRoleListMapper> roleListMapper, KeycloakSession session, UserSessionModel userSession, ClientSessionContext clientSessionCtx, AttributeStatementType existingAttributeStatement) {
        if (roleListMapper == null) {
            return;
        }
        ((SAMLRoleListMapper)roleListMapper.mapper).mapRoles(existingAttributeStatement, roleListMapper.model, session, userSession, clientSessionCtx);
    }

    public static String getLogoutServiceUrl(UriInfo uriInfo, ClientModel client, String bindingType) {
        String logoutServiceUrl = null;
        logoutServiceUrl = SAML_POST_BINDING.equals(bindingType) ? client.getAttribute(SAML_SINGLE_LOGOUT_SERVICE_URL_POST_ATTRIBUTE) : client.getAttribute(SAML_SINGLE_LOGOUT_SERVICE_URL_REDIRECT_ATTRIBUTE);
        if (logoutServiceUrl == null) {
            logoutServiceUrl = client.getManagementUrl();
        }
        if (logoutServiceUrl == null || logoutServiceUrl.trim().equals("")) {
            return null;
        }
        return ResourceAdminManager.resolveUri(uriInfo.getRequestUri(), client.getRootUrl(), logoutServiceUrl);
    }

    public Response frontchannelLogout(UserSessionModel userSession, AuthenticatedClientSessionModel clientSession) {
        ClientModel client = clientSession.getClient();
        SamlClient samlClient = new SamlClient(client);
        try {
            boolean postBinding = this.isLogoutPostBindingForClient(clientSession);
            String bindingUri = SamlProtocol.getLogoutServiceUrl(this.uriInfo, client, postBinding ? SAML_POST_BINDING : SAML_REDIRECT_BINDING);
            if (bindingUri == null) {
                logger.warnf("Failed to logout client %s, skipping this client.  Please configure the logout service url in the admin console for your client applications.", (Object)client.getClientId());
                return null;
            }
            if (postBinding) {
                SAML2LogoutRequestBuilder logoutBuilder = this.createLogoutRequest(bindingUri, clientSession, client);
                JaxrsSAML2BindingBuilder binding = this.createBindingBuilder(samlClient);
                return binding.postBinding(logoutBuilder.buildDocument()).request(bindingUri);
            }
            logger.debug((Object)"frontchannel redirect binding");
            SAML2LogoutRequestBuilder logoutBuilder = this.createLogoutRequest(bindingUri, clientSession, client);
            if (samlClient.requiresRealmSignature() && samlClient.addExtensionsElementWithKeyInfo()) {
                KeyManager.ActiveRsaKey keys = this.session.keys().getActiveRsaKey(this.realm);
                String keyName = samlClient.getXmlSigKeyInfoKeyNameTransformer().getKeyName(keys.getKid(), keys.getCertificate());
                logoutBuilder.addExtension((SamlProtocolExtensionsAwareBuilder.NodeGenerator)new KeycloakKeySamlExtensionGenerator(keyName));
            }
            JaxrsSAML2BindingBuilder binding = this.createBindingBuilder(samlClient);
            return binding.redirectBinding(logoutBuilder.buildDocument()).request(bindingUri);
        }
        catch (ConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (ProcessingException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (ParsingException e) {
            throw new RuntimeException(e);
        }
    }

    public Response finishLogout(UserSessionModel userSession) {
        Response response;
        logger.debug((Object)"finishLogout");
        String logoutBindingUri = userSession.getNote(SAML_LOGOUT_BINDING_URI);
        if (logoutBindingUri == null) {
            logger.error((Object)"Can't finish SAML logout as there is no logout binding set.  Please configure the logout service url in the admin console for your client applications.");
            return ErrorPage.error(this.session, null, Response.Status.BAD_REQUEST, "failedLogout", new Object[0]);
        }
        String logoutRelayState = userSession.getNote(SAML_LOGOUT_RELAY_STATE);
        SAML2LogoutResponseBuilder builder = new SAML2LogoutResponseBuilder();
        builder.logoutRequestID(userSession.getNote(SAML_LOGOUT_REQUEST_ID));
        builder.destination(logoutBindingUri);
        builder.issuer(this.getResponseIssuer(this.realm));
        JaxrsSAML2BindingBuilder binding = new JaxrsSAML2BindingBuilder();
        binding.relayState(logoutRelayState);
        String signingAlgorithm = userSession.getNote(SAML_LOGOUT_SIGNATURE_ALGORITHM);
        boolean postBinding = SamlProtocol.isLogoutPostBindingForInitiator(userSession);
        if (signingAlgorithm != null) {
            boolean addExtension;
            SignatureAlgorithm algorithm = SignatureAlgorithm.valueOf((String)signingAlgorithm);
            String canonicalization = userSession.getNote(SAML_LOGOUT_CANONICALIZATION);
            if (canonicalization != null) {
                binding.canonicalizationMethod(canonicalization);
            }
            KeyManager.ActiveRsaKey keys = this.session.keys().getActiveRsaKey(this.realm);
            XmlKeyInfoKeyNameTransformer transformer = XmlKeyInfoKeyNameTransformer.from((String)userSession.getNote(SAML_SERVER_SIGNATURE_KEYINFO_KEY_NAME_TRANSFORMER), (XmlKeyInfoKeyNameTransformer)SamlClient.DEFAULT_XML_KEY_INFO_KEY_NAME_TRANSFORMER);
            String keyName = transformer.getKeyName(keys.getKid(), keys.getCertificate());
            ((JaxrsSAML2BindingBuilder)((JaxrsSAML2BindingBuilder)binding.signatureAlgorithm(algorithm)).signWith(keyName, keys.getPrivateKey(), keys.getPublicKey(), keys.getCertificate())).signDocument();
            boolean bl = addExtension = !postBinding && Objects.equals(ATTRIBUTE_TRUE_VALUE, userSession.getNote(SAML_LOGOUT_ADD_EXTENSIONS_ELEMENT_WITH_KEY_INFO));
            if (addExtension) {
                builder.addExtension((SamlProtocolExtensionsAwareBuilder.NodeGenerator)new KeycloakKeySamlExtensionGenerator(keyName));
            }
        }
        try {
            response = this.buildLogoutResponse(userSession, logoutBindingUri, builder, binding);
        }
        catch (IOException | ConfigurationException | ProcessingException e) {
            throw new RuntimeException(e);
        }
        if (logoutBindingUri != null) {
            this.event.detail("redirect_uri", logoutBindingUri);
        }
        this.event.event(EventType.LOGOUT).detail("auth_method", userSession.getAuthMethod()).client(this.session.getContext().getClient()).user(userSession.getUser()).session(userSession).detail("username", userSession.getLoginUsername()).detail("response_mode", postBinding ? SAML_POST_BINDING : SAML_REDIRECT_BINDING).detail(SAML_LOGOUT_REQUEST_ID, userSession.getNote(SAML_LOGOUT_REQUEST_ID)).success();
        return response;
    }

    protected Response buildLogoutResponse(UserSessionModel userSession, String logoutBindingUri, SAML2LogoutResponseBuilder builder, JaxrsSAML2BindingBuilder binding) throws ConfigurationException, ProcessingException, IOException {
        if (SamlProtocol.isLogoutPostBindingForInitiator(userSession)) {
            return binding.postBinding(builder.buildDocument()).response(logoutBindingUri);
        }
        return binding.redirectBinding(builder.buildDocument()).response(logoutBindingUri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void backchannelLogout(UserSessionModel userSession, AuthenticatedClientSessionModel clientSession) {
        ClientModel client = clientSession.getClient();
        SamlClient samlClient = new SamlClient(client);
        String logoutUrl = SamlProtocol.getLogoutServiceUrl(this.uriInfo, client, SAML_POST_BINDING);
        if (logoutUrl == null) {
            logger.warnf("Can't do backchannel logout. No SingleLogoutService POST Binding registered for client: %s", (Object)client.getClientId());
            return;
        }
        SAML2LogoutRequestBuilder logoutBuilder = this.createLogoutRequest(logoutUrl, clientSession, client);
        String logoutRequestString = null;
        try {
            JaxrsSAML2BindingBuilder binding = this.createBindingBuilder(samlClient);
            logoutRequestString = binding.postBinding(logoutBuilder.buildDocument()).encoded();
        }
        catch (Exception e) {
            logger.warn((Object)"failed to send saml logout", (Throwable)e);
            return;
        }
        HttpClient httpClient = ((HttpClientProvider)this.session.getProvider(HttpClientProvider.class)).getHttpClient();
        for (int i = 0; i < 2; ++i) {
            try {
                ArrayList<BasicNameValuePair> formparams = new ArrayList<BasicNameValuePair>();
                formparams.add(new BasicNameValuePair("SAMLRequest", logoutRequestString));
                formparams.add(new BasicNameValuePair("BACK_CHANNEL_LOGOUT", "BACK_CHANNEL_LOGOUT"));
                UrlEncodedFormEntity form = new UrlEncodedFormEntity(formparams, "UTF-8");
                HttpPost post = new HttpPost(logoutUrl);
                post.setEntity((HttpEntity)form);
                HttpResponse response = httpClient.execute((HttpUriRequest)post);
                try {
                    int status = response.getStatusLine().getStatusCode();
                    if (status != 302 || logoutUrl.endsWith("/")) break;
                    String redirect = response.getFirstHeader("Location").getValue();
                    String withSlash = logoutUrl + "/";
                    if (!withSlash.equals(redirect)) break;
                    logoutUrl = withSlash;
                    continue;
                }
                finally {
                    InputStream is;
                    HttpEntity entity = response.getEntity();
                    if (entity != null && (is = entity.getContent()) != null) {
                        is.close();
                    }
                }
            }
            catch (IOException e) {
                logger.warn((Object)"failed to send saml logout", (Throwable)e);
                break;
            }
        }
    }

    protected SAML2LogoutRequestBuilder createLogoutRequest(String logoutUrl, AuthenticatedClientSessionModel clientSession, ClientModel client) {
        SAML2LogoutRequestBuilder logoutBuilder = new SAML2LogoutRequestBuilder().assertionExpiration(this.realm.getAccessCodeLifespan()).issuer(this.getResponseIssuer(this.realm)).userPrincipal(clientSession.getNote(SAML_NAME_ID), clientSession.getNote(SAML_NAME_ID_FORMAT)).destination(logoutUrl);
        String sessionIndex = SamlSessionUtils.getSessionIndex(clientSession);
        logoutBuilder.sessionIndex(sessionIndex);
        return logoutBuilder;
    }

    public boolean requireReauthentication(UserSessionModel userSession, AuthenticationSessionModel authSession) {
        return false;
    }

    private JaxrsSAML2BindingBuilder createBindingBuilder(SamlClient samlClient) {
        JaxrsSAML2BindingBuilder binding = new JaxrsSAML2BindingBuilder();
        if (samlClient.requiresRealmSignature()) {
            KeyManager.ActiveRsaKey keys = this.session.keys().getActiveRsaKey(this.realm);
            String keyName = samlClient.getXmlSigKeyInfoKeyNameTransformer().getKeyName(keys.getKid(), keys.getCertificate());
            ((JaxrsSAML2BindingBuilder)((JaxrsSAML2BindingBuilder)binding.signatureAlgorithm(samlClient.getSignatureAlgorithm())).signWith(keyName, keys.getPrivateKey(), keys.getPublicKey(), keys.getCertificate())).signDocument();
        }
        return binding;
    }

    public void close() {
    }

    public static class ProtocolMapperProcessor<T> {
        public final T mapper;
        public final ProtocolMapperModel model;

        public ProtocolMapperProcessor(T mapper, ProtocolMapperModel model) {
            this.mapper = mapper;
            this.model = model;
        }
    }
}

