/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.keys;

import java.security.Key;
import java.security.KeyPair;
import java.util.Collections;
import java.util.List;
import org.jboss.logging.Logger;
import org.keycloak.common.util.KeyUtils;
import org.keycloak.common.util.Time;
import org.keycloak.crypto.KeyStatus;
import org.keycloak.crypto.KeyUse;
import org.keycloak.crypto.KeyWrapper;
import org.keycloak.keys.KeyProvider;

public class FailsafeRsaKeyProvider
implements KeyProvider {
    private static final Logger logger = Logger.getLogger(FailsafeRsaKeyProvider.class);
    private static KeyWrapper KEY;
    private static long EXPIRES;
    private KeyWrapper key;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FailsafeRsaKeyProvider() {
        logger.errorv("No active keys found, using failsafe provider, please login to admin console to add keys. Clustering is not supported.", new Object[0]);
        Class<FailsafeRsaKeyProvider> clazz = FailsafeRsaKeyProvider.class;
        synchronized (FailsafeRsaKeyProvider.class) {
            if (EXPIRES < (long)Time.currentTime()) {
                KEY = this.createKeyWrapper();
                EXPIRES = Time.currentTime() + 600;
                if (EXPIRES > 0L) {
                    logger.warnv("Keys expired, re-generated kid={0}", (Object)KEY.getKid());
                }
            }
            this.key = KEY;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public List<KeyWrapper> getKeys() {
        return Collections.singletonList(this.key);
    }

    private KeyWrapper createKeyWrapper() {
        KeyPair keyPair = KeyUtils.generateRsaKeyPair((int)2048);
        KeyWrapper key = new KeyWrapper();
        key.setKid(KeyUtils.createKeyId((Key)keyPair.getPublic()));
        key.setUse(KeyUse.SIG);
        key.setType("RSA");
        key.setAlgorithms(new String[]{"RS256", "RS384", "RS512"});
        key.setStatus(KeyStatus.ACTIVE);
        key.setSignKey((Key)keyPair.getPrivate());
        key.setVerifyKey((Key)keyPair.getPublic());
        return key;
    }
}

