/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.url;

import javax.ws.rs.core.UriInfo;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.urls.HostnameProvider;

public class FixedHostnameProvider
implements HostnameProvider {
    private final KeycloakSession session;
    private final String globalHostname;
    private final int httpPort;
    private final int httpsPort;

    public FixedHostnameProvider(KeycloakSession session, String globalHostname, int httpPort, int httpsPort) {
        this.session = session;
        this.globalHostname = globalHostname;
        this.httpPort = httpPort;
        this.httpsPort = httpsPort;
    }

    public String getHostname(UriInfo originalUriInfo) {
        String realmHostname;
        RealmModel realm = this.session.getContext().getRealm();
        if (realm != null && (realmHostname = this.session.getContext().getRealm().getAttribute("hostname")) != null && !realmHostname.isEmpty()) {
            return realmHostname;
        }
        return this.globalHostname;
    }

    public int getPort(UriInfo originalUriInfo) {
        return originalUriInfo.getRequestUri().getScheme().equals("https") ? this.httpsPort : this.httpPort;
    }
}

