/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.changes.sessions;

import org.infinispan.Cache;
import org.keycloak.cluster.ClusterListener;
import org.keycloak.cluster.ClusterProvider;
import org.keycloak.common.util.Time;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.sessions.infinispan.changes.SessionEntityWrapper;
import org.keycloak.models.sessions.infinispan.changes.sessions.LastSessionRefreshListener;
import org.keycloak.models.sessions.infinispan.changes.sessions.LastSessionRefreshStore;
import org.keycloak.models.sessions.infinispan.entities.UserSessionEntity;
import org.keycloak.timer.TimerProvider;

public class LastSessionRefreshStoreFactory {
    public static final long DEFAULT_TIMER_INTERVAL_MS = 5000L;
    public static final int DEFAULT_MAX_INTERVAL_BETWEEN_MESSAGES_SECONDS = 60;
    public static final int DEFAULT_MAX_COUNT = 100;
    public static final String LSR_PERIODIC_TASK_NAME = "lastSessionRefreshes";
    public static final String LSR_OFFLINE_PERIODIC_TASK_NAME = "lastSessionRefreshes-offline";

    public LastSessionRefreshStore createAndInit(KeycloakSession kcSession, Cache<String, SessionEntityWrapper<UserSessionEntity>> cache, boolean offline) {
        return this.createAndInit(kcSession, cache, 5000L, 60, 100, offline);
    }

    public LastSessionRefreshStore createAndInit(KeycloakSession kcSession, Cache<String, SessionEntityWrapper<UserSessionEntity>> cache, long timerIntervalMs, int maxIntervalBetweenMessagesSeconds, int maxCount, boolean offline) {
        String eventKey = offline ? LSR_OFFLINE_PERIODIC_TASK_NAME : LSR_PERIODIC_TASK_NAME;
        LastSessionRefreshStore store = this.createStoreInstance(maxIntervalBetweenMessagesSeconds, maxCount, eventKey);
        ClusterProvider cluster = (ClusterProvider)kcSession.getProvider(ClusterProvider.class);
        cluster.registerListener(eventKey, (ClusterListener)new LastSessionRefreshListener(kcSession, cache, offline));
        TimerProvider timer = (TimerProvider)kcSession.getProvider(TimerProvider.class);
        timer.scheduleTask(keycloakSession -> store.checkSendingMessage(keycloakSession, Time.currentTime()), timerIntervalMs, eventKey);
        return store;
    }

    protected LastSessionRefreshStore createStoreInstance(int maxIntervalBetweenMessagesSeconds, int maxCount, String eventKey) {
        return new LastSessionRefreshStore(maxIntervalBetweenMessagesSeconds, maxCount, eventKey);
    }
}

