/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.broker.oidc;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.GET;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.keycloak.broker.oidc.OAuth2IdentityProviderConfig;
import org.keycloak.broker.provider.AbstractIdentityProvider;
import org.keycloak.broker.provider.AuthenticationRequest;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.broker.provider.ExchangeExternalToken;
import org.keycloak.broker.provider.ExchangeTokenToIdentityProviderToken;
import org.keycloak.broker.provider.IdentityBrokerException;
import org.keycloak.broker.provider.IdentityProvider;
import org.keycloak.broker.provider.util.SimpleHttp;
import org.keycloak.common.ClientConnection;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.models.ClientModel;
import org.keycloak.models.FederatedIdentityModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.representations.AccessTokenResponse;
import org.keycloak.services.ErrorPage;
import org.keycloak.services.ErrorResponseException;
import org.keycloak.sessions.AuthenticationSessionModel;

public abstract class AbstractOAuth2IdentityProvider<C extends OAuth2IdentityProviderConfig>
extends AbstractIdentityProvider<C>
implements ExchangeTokenToIdentityProviderToken,
ExchangeExternalToken {
    protected static final Logger logger = Logger.getLogger(AbstractOAuth2IdentityProvider.class);
    public static final String OAUTH2_GRANT_TYPE_REFRESH_TOKEN = "refresh_token";
    public static final String OAUTH2_GRANT_TYPE_AUTHORIZATION_CODE = "authorization_code";
    public static final String FEDERATED_REFRESH_TOKEN = "FEDERATED_REFRESH_TOKEN";
    public static final String FEDERATED_TOKEN_EXPIRATION = "FEDERATED_TOKEN_EXPIRATION";
    public static final String ACCESS_DENIED = "access_denied";
    protected static ObjectMapper mapper = new ObjectMapper();
    public static final String OAUTH2_PARAMETER_ACCESS_TOKEN = "access_token";
    public static final String OAUTH2_PARAMETER_SCOPE = "scope";
    public static final String OAUTH2_PARAMETER_STATE = "state";
    public static final String OAUTH2_PARAMETER_RESPONSE_TYPE = "response_type";
    public static final String OAUTH2_PARAMETER_REDIRECT_URI = "redirect_uri";
    public static final String OAUTH2_PARAMETER_CODE = "code";
    public static final String OAUTH2_PARAMETER_CLIENT_ID = "client_id";
    public static final String OAUTH2_PARAMETER_CLIENT_SECRET = "client_secret";
    public static final String OAUTH2_PARAMETER_GRANT_TYPE = "grant_type";

    public AbstractOAuth2IdentityProvider(KeycloakSession session, C config) {
        super(session, config);
        if (((OAuth2IdentityProviderConfig)((Object)config)).getDefaultScope() == null || ((OAuth2IdentityProviderConfig)((Object)config)).getDefaultScope().isEmpty()) {
            ((OAuth2IdentityProviderConfig)((Object)config)).setDefaultScope(this.getDefaultScopes());
        }
    }

    public Object callback(RealmModel realm, IdentityProvider.AuthenticationCallback callback, EventBuilder event) {
        return new Endpoint(callback, realm, event);
    }

    public Response performLogin(AuthenticationRequest request) {
        try {
            URI authorizationUrl = this.createAuthorizationUrl(request).build(new Object[0]);
            return Response.seeOther((URI)authorizationUrl).build();
        }
        catch (Exception e) {
            throw new IdentityBrokerException("Could not create authentication request.", (Throwable)e);
        }
    }

    public Response retrieveToken(KeycloakSession session, FederatedIdentityModel identity) {
        return Response.ok((Object)identity.getToken()).build();
    }

    public C getConfig() {
        return (C)((Object)((OAuth2IdentityProviderConfig)super.getConfig()));
    }

    protected String extractTokenFromResponse(String response, String tokenName) {
        if (response == null) {
            return null;
        }
        if (response.startsWith("{")) {
            try {
                JsonNode node = mapper.readTree(response);
                if (node.has(tokenName)) {
                    String s = node.get(tokenName).textValue();
                    if (s == null || s.trim().isEmpty()) {
                        return null;
                    }
                    return s;
                }
                return null;
            }
            catch (IOException e) {
                throw new IdentityBrokerException("Could not extract token [" + tokenName + "] from response [" + response + "] due: " + e.getMessage(), (Throwable)e);
            }
        }
        Matcher matcher = Pattern.compile(tokenName + "=([^&]+)").matcher(response);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    public Response exchangeFromToken(UriInfo uriInfo, EventBuilder event, ClientModel authorizedClient, UserSessionModel tokenUserSession, UserModel tokenSubject, MultivaluedMap<String, String> params) {
        Response tokenResponse = this.hasExternalExchangeToken(event, tokenUserSession, params);
        if (tokenResponse != null) {
            return tokenResponse;
        }
        String requestedType = (String)params.getFirst((Object)"requested_token_type");
        if (requestedType != null && !requestedType.equals("urn:ietf:params:oauth:token-type:access_token")) {
            event.detail("reason", "requested_token_type unsupported");
            event.error("invalid_request");
            return this.exchangeUnsupportedRequiredType();
        }
        if (!this.getConfig().isStoreToken()) {
            String brokerId = tokenUserSession.getNote("identity_provider");
            String string = brokerId = brokerId == null ? tokenUserSession.getNote("EXTERNAL_IDENTITY_PROVIDER") : brokerId;
            if (brokerId == null || !brokerId.equals(this.getConfig().getAlias())) {
                event.detail("reason", "requested_issuer has not linked");
                event.error("invalid_request");
                return this.exchangeNotLinkedNoStore(uriInfo, authorizedClient, tokenUserSession, tokenSubject);
            }
            return this.exchangeSessionToken(uriInfo, event, authorizedClient, tokenUserSession, tokenSubject);
        }
        return this.exchangeStoredToken(uriInfo, event, authorizedClient, tokenUserSession, tokenSubject);
    }

    protected Response hasExternalExchangeToken(EventBuilder event, UserSessionModel tokenUserSession, MultivaluedMap<String, String> params) {
        if (this.getConfig().getAlias().equals(tokenUserSession.getNote("EXCHANGE_PROVIDER"))) {
            String idToken;
            String requestedType = (String)params.getFirst((Object)"requested_token_type");
            if (requestedType == null || requestedType.equals("urn:ietf:params:oauth:token-type:access_token")) {
                String accessToken = tokenUserSession.getNote("FEDERATED_ACCESS_TOKEN");
                if (accessToken != null) {
                    AccessTokenResponse tokenResponse = new AccessTokenResponse();
                    tokenResponse.setToken(accessToken);
                    tokenResponse.setIdToken(null);
                    tokenResponse.setRefreshToken(null);
                    tokenResponse.setRefreshExpiresIn(0L);
                    tokenResponse.setExpiresIn(0L);
                    tokenResponse.getOtherClaims().clear();
                    tokenResponse.getOtherClaims().put("issued_token_type", "urn:ietf:params:oauth:token-type:access_token");
                    event.success();
                    return Response.ok((Object)tokenResponse).type(MediaType.APPLICATION_JSON_TYPE).build();
                }
            } else if ("urn:ietf:params:oauth:token-type:id_token".equals(requestedType) && (idToken = tokenUserSession.getNote("FEDERATED_ID_TOKEN")) != null) {
                AccessTokenResponse tokenResponse = new AccessTokenResponse();
                tokenResponse.setToken(null);
                tokenResponse.setIdToken(idToken);
                tokenResponse.setRefreshToken(null);
                tokenResponse.setRefreshExpiresIn(0L);
                tokenResponse.setExpiresIn(0L);
                tokenResponse.getOtherClaims().clear();
                tokenResponse.getOtherClaims().put("issued_token_type", "urn:ietf:params:oauth:token-type:id_token");
                event.success();
                return Response.ok((Object)tokenResponse).type(MediaType.APPLICATION_JSON_TYPE).build();
            }
        }
        return null;
    }

    protected Response exchangeStoredToken(UriInfo uriInfo, EventBuilder event, ClientModel authorizedClient, UserSessionModel tokenUserSession, UserModel tokenSubject) {
        FederatedIdentityModel model = this.session.users().getFederatedIdentity(tokenSubject, this.getConfig().getAlias(), authorizedClient.getRealm());
        if (model == null || model.getToken() == null) {
            event.detail("reason", "requested_issuer is not linked");
            event.error("invalid_token");
            return this.exchangeNotLinked(uriInfo, authorizedClient, tokenUserSession, tokenSubject);
        }
        String accessToken = this.extractTokenFromResponse(model.getToken(), this.getAccessTokenResponseParameter());
        if (accessToken == null) {
            model.setToken(null);
            this.session.users().updateFederatedIdentity(authorizedClient.getRealm(), tokenSubject, model);
            event.detail("reason", "requested_issuer token expired");
            event.error("invalid_token");
            return this.exchangeTokenExpired(uriInfo, authorizedClient, tokenUserSession, tokenSubject);
        }
        AccessTokenResponse tokenResponse = new AccessTokenResponse();
        tokenResponse.setToken(accessToken);
        tokenResponse.setIdToken(null);
        tokenResponse.setRefreshToken(null);
        tokenResponse.setRefreshExpiresIn(0L);
        tokenResponse.getOtherClaims().clear();
        tokenResponse.getOtherClaims().put("issued_token_type", "urn:ietf:params:oauth:token-type:access_token");
        tokenResponse.getOtherClaims().put("account-link-url", this.getLinkingUrl(uriInfo, authorizedClient, tokenUserSession));
        event.success();
        return Response.ok((Object)tokenResponse).type(MediaType.APPLICATION_JSON_TYPE).build();
    }

    protected Response exchangeSessionToken(UriInfo uriInfo, EventBuilder event, ClientModel authorizedClient, UserSessionModel tokenUserSession, UserModel tokenSubject) {
        String accessToken = tokenUserSession.getNote("FEDERATED_ACCESS_TOKEN");
        if (accessToken == null) {
            event.detail("reason", "requested_issuer is not linked");
            event.error("invalid_token");
            return this.exchangeTokenExpired(uriInfo, authorizedClient, tokenUserSession, tokenSubject);
        }
        AccessTokenResponse tokenResponse = new AccessTokenResponse();
        tokenResponse.setToken(accessToken);
        tokenResponse.setIdToken(null);
        tokenResponse.setRefreshToken(null);
        tokenResponse.setRefreshExpiresIn(0L);
        tokenResponse.getOtherClaims().clear();
        tokenResponse.getOtherClaims().put("issued_token_type", "urn:ietf:params:oauth:token-type:access_token");
        tokenResponse.getOtherClaims().put("account-link-url", this.getLinkingUrl(uriInfo, authorizedClient, tokenUserSession));
        event.success();
        return Response.ok((Object)tokenResponse).type(MediaType.APPLICATION_JSON_TYPE).build();
    }

    public BrokeredIdentityContext getFederatedIdentity(String response) {
        String accessToken = this.extractTokenFromResponse(response, this.getAccessTokenResponseParameter());
        if (accessToken == null) {
            throw new IdentityBrokerException("No access token available in OAuth server response: " + response);
        }
        BrokeredIdentityContext context = this.doGetFederatedIdentity(accessToken);
        context.getContextData().put("FEDERATED_ACCESS_TOKEN", accessToken);
        return context;
    }

    protected String getAccessTokenResponseParameter() {
        return OAUTH2_PARAMETER_ACCESS_TOKEN;
    }

    protected BrokeredIdentityContext doGetFederatedIdentity(String accessToken) {
        return null;
    }

    protected UriBuilder createAuthorizationUrl(AuthenticationRequest request) {
        String nonce;
        String prompt;
        UriBuilder uriBuilder = UriBuilder.fromUri((String)this.getConfig().getAuthorizationUrl()).queryParam(OAUTH2_PARAMETER_SCOPE, new Object[]{this.getConfig().getDefaultScope()}).queryParam(OAUTH2_PARAMETER_STATE, new Object[]{request.getState().getEncoded()}).queryParam(OAUTH2_PARAMETER_RESPONSE_TYPE, new Object[]{OAUTH2_PARAMETER_CODE}).queryParam(OAUTH2_PARAMETER_CLIENT_ID, new Object[]{this.getConfig().getClientId()}).queryParam(OAUTH2_PARAMETER_REDIRECT_URI, new Object[]{request.getRedirectUri()});
        String loginHint = request.getAuthenticationSession().getClientNote("login_hint");
        if (this.getConfig().isLoginHint() && loginHint != null) {
            uriBuilder.queryParam("login_hint", new Object[]{loginHint});
        }
        if ((prompt = this.getConfig().getPrompt()) == null || prompt.isEmpty()) {
            prompt = request.getAuthenticationSession().getClientNote("prompt");
        }
        if (prompt != null) {
            uriBuilder.queryParam("prompt", new Object[]{prompt});
        }
        if ((nonce = request.getAuthenticationSession().getClientNote("nonce")) == null || nonce.isEmpty()) {
            nonce = UUID.randomUUID().toString();
            request.getAuthenticationSession().setClientNote("nonce", nonce);
        }
        uriBuilder.queryParam("nonce", new Object[]{nonce});
        String acr = request.getAuthenticationSession().getClientNote("acr_values");
        if (acr != null) {
            uriBuilder.queryParam("acr_values", new Object[]{acr});
        }
        String forwardParameterConfig = this.getConfig().getForwardParameters() != null ? this.getConfig().getForwardParameters() : "";
        List<String> forwardParameters = Arrays.asList(forwardParameterConfig.split("\\s*,\\s*"));
        for (String forwardParameter : forwardParameters) {
            String name = "client_request_param_" + forwardParameter.trim();
            String parameter = request.getAuthenticationSession().getClientNote(name);
            if (parameter == null || parameter.isEmpty()) continue;
            uriBuilder.queryParam(forwardParameter, new Object[]{parameter});
        }
        return uriBuilder;
    }

    public String getJsonProperty(JsonNode jsonNode, String name) {
        if (jsonNode.has(name) && !jsonNode.get(name).isNull()) {
            String s = jsonNode.get(name).asText();
            if (s != null && !s.isEmpty()) {
                return s;
            }
            return null;
        }
        return null;
    }

    public JsonNode asJsonNode(String json) throws IOException {
        return mapper.readTree(json);
    }

    protected abstract String getDefaultScopes();

    public void authenticationFinished(AuthenticationSessionModel authSession, BrokeredIdentityContext context) {
        String token = (String)context.getContextData().get("FEDERATED_ACCESS_TOKEN");
        if (token != null) {
            authSession.setUserSessionNote("FEDERATED_ACCESS_TOKEN", token);
        }
    }

    protected String getProfileEndpointForValidation(EventBuilder event) {
        event.detail("reason", "exchange unsupported");
        event.error("invalid_token");
        throw new ErrorResponseException("invalid_token", "invalid token", Response.Status.BAD_REQUEST);
    }

    protected BrokeredIdentityContext extractIdentityFromProfile(EventBuilder event, JsonNode node) {
        return null;
    }

    protected BrokeredIdentityContext validateExternalTokenThroughUserInfo(EventBuilder event, String subjectToken, String subjectTokenType) {
        event.detail("validation_method", "user info");
        SimpleHttp.Response response = null;
        int status = 0;
        try {
            String userInfoUrl = this.getProfileEndpointForValidation(event);
            response = this.buildUserInfoRequest(subjectToken, userInfoUrl).asResponse();
            status = response.getStatus();
        }
        catch (IOException e) {
            logger.debug((Object)"Failed to invoke user info for external exchange", (Throwable)e);
        }
        if (status != 200) {
            logger.debug((Object)("Failed to invoke user info status: " + status));
            event.detail("reason", "user info call failure");
            event.error("invalid_token");
            throw new ErrorResponseException("invalid_token", "invalid token", Response.Status.BAD_REQUEST);
        }
        JsonNode profile = null;
        try {
            profile = response.asJson();
        }
        catch (IOException e) {
            event.detail("reason", "user info call failure");
            event.error("invalid_token");
            throw new ErrorResponseException("invalid_token", "invalid token", Response.Status.BAD_REQUEST);
        }
        BrokeredIdentityContext context = this.extractIdentityFromProfile(event, profile);
        if (context.getId() == null) {
            event.detail("reason", "user info call failure");
            event.error("invalid_token");
            throw new ErrorResponseException("invalid_token", "invalid token", Response.Status.BAD_REQUEST);
        }
        return context;
    }

    protected SimpleHttp buildUserInfoRequest(String subjectToken, String userInfoUrl) {
        return SimpleHttp.doGet((String)userInfoUrl, (KeycloakSession)this.session).header("Authorization", "Bearer " + subjectToken);
    }

    protected boolean supportsExternalExchange() {
        return false;
    }

    public boolean isIssuer(String issuer, MultivaluedMap<String, String> params) {
        if (!this.supportsExternalExchange()) {
            return false;
        }
        String requestedIssuer = (String)params.getFirst((Object)"subject_issuer");
        if (requestedIssuer == null) {
            requestedIssuer = issuer;
        }
        return requestedIssuer.equals(this.getConfig().getAlias());
    }

    public final BrokeredIdentityContext exchangeExternal(EventBuilder event, MultivaluedMap<String, String> params) {
        if (!this.supportsExternalExchange()) {
            return null;
        }
        BrokeredIdentityContext context = this.exchangeExternalImpl(event, params);
        if (context != null) {
            context.setIdp((IdentityProvider)this);
            context.setIdpConfig(this.getConfig());
        }
        return context;
    }

    protected BrokeredIdentityContext exchangeExternalImpl(EventBuilder event, MultivaluedMap<String, String> params) {
        return this.exchangeExternalUserInfoValidationOnly(event, params);
    }

    protected BrokeredIdentityContext exchangeExternalUserInfoValidationOnly(EventBuilder event, MultivaluedMap<String, String> params) {
        String subjectToken = (String)params.getFirst((Object)"subject_token");
        if (subjectToken == null) {
            event.detail("reason", "subject_token param unset");
            event.error("invalid_token");
            throw new ErrorResponseException("invalid_token", "token not set", Response.Status.BAD_REQUEST);
        }
        String subjectTokenType = (String)params.getFirst((Object)"subject_token_type");
        if (subjectTokenType == null) {
            subjectTokenType = "urn:ietf:params:oauth:token-type:access_token";
        }
        if (!"urn:ietf:params:oauth:token-type:access_token".equals(subjectTokenType)) {
            event.detail("reason", "subject_token_type invalid");
            event.error("invalid_token_type");
            throw new ErrorResponseException("invalid_token", "invalid token type", Response.Status.BAD_REQUEST);
        }
        return this.validateExternalTokenThroughUserInfo(event, subjectToken, subjectTokenType);
    }

    public void exchangeExternalComplete(UserSessionModel userSession, BrokeredIdentityContext context, MultivaluedMap<String, String> params) {
        if (context.getContextData().containsKey("VALIDATED_ID_TOKEN")) {
            userSession.setNote("FEDERATED_ACCESS_TOKEN", (String)params.getFirst((Object)"subject_token"));
        }
        if (context.getContextData().containsKey("VALIDATED_ID_TOKEN")) {
            userSession.setNote("FEDERATED_ID_TOKEN", (String)params.getFirst((Object)"subject_token"));
        }
        userSession.setNote("EXCHANGE_PROVIDER", this.getConfig().getAlias());
    }

    protected class Endpoint {
        protected IdentityProvider.AuthenticationCallback callback;
        protected RealmModel realm;
        protected EventBuilder event;
        @Context
        protected KeycloakSession session;
        @Context
        protected ClientConnection clientConnection;
        @Context
        protected HttpHeaders headers;

        public Endpoint(IdentityProvider.AuthenticationCallback callback, RealmModel realm, EventBuilder event) {
            this.callback = callback;
            this.realm = realm;
            this.event = event;
        }

        @GET
        public Response authResponse(@QueryParam(value="state") String state, @QueryParam(value="code") String authorizationCode, @QueryParam(value="error") String error) {
            if (error != null) {
                if (error.equals(AbstractOAuth2IdentityProvider.ACCESS_DENIED)) {
                    logger.error((Object)("access_denied for broker login " + AbstractOAuth2IdentityProvider.this.getConfig().getProviderId()));
                    return this.callback.cancelled(state);
                }
                logger.error((Object)(error + " for broker login " + AbstractOAuth2IdentityProvider.this.getConfig().getProviderId()));
                return this.callback.error(state, "identityProviderUnexpectedErrorMessage");
            }
            try {
                if (authorizationCode != null) {
                    String response = this.generateTokenRequest(authorizationCode).asString();
                    BrokeredIdentityContext federatedIdentity = AbstractOAuth2IdentityProvider.this.getFederatedIdentity(response);
                    if (AbstractOAuth2IdentityProvider.this.getConfig().isStoreToken() && federatedIdentity.getToken() == null) {
                        federatedIdentity.setToken(response);
                    }
                    federatedIdentity.setIdpConfig(AbstractOAuth2IdentityProvider.this.getConfig());
                    federatedIdentity.setIdp((IdentityProvider)AbstractOAuth2IdentityProvider.this);
                    federatedIdentity.setCode(state);
                    return this.callback.authenticated(federatedIdentity);
                }
            }
            catch (WebApplicationException e) {
                return e.getResponse();
            }
            catch (Exception e) {
                logger.error((Object)"Failed to make identity provider oauth callback", (Throwable)e);
            }
            this.event.event(EventType.LOGIN);
            this.event.error("identity_provider_login_failure");
            return ErrorPage.error(this.session, null, Response.Status.BAD_GATEWAY, "identityProviderUnexpectedErrorMessage", new Object[0]);
        }

        public SimpleHttp generateTokenRequest(String authorizationCode) {
            return SimpleHttp.doPost((String)AbstractOAuth2IdentityProvider.this.getConfig().getTokenUrl(), (KeycloakSession)this.session).param(AbstractOAuth2IdentityProvider.OAUTH2_PARAMETER_CODE, authorizationCode).param(AbstractOAuth2IdentityProvider.OAUTH2_PARAMETER_CLIENT_ID, AbstractOAuth2IdentityProvider.this.getConfig().getClientId()).param(AbstractOAuth2IdentityProvider.OAUTH2_PARAMETER_CLIENT_SECRET, AbstractOAuth2IdentityProvider.this.getConfig().getClientSecret()).param(AbstractOAuth2IdentityProvider.OAUTH2_PARAMETER_REDIRECT_URI, this.session.getContext().getUri().getAbsolutePath().toString()).param(AbstractOAuth2IdentityProvider.OAUTH2_PARAMETER_GRANT_TYPE, AbstractOAuth2IdentityProvider.OAUTH2_GRANT_TYPE_AUTHORIZATION_CODE);
        }
    }
}

