/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.keycloak.authentication.ClientAuthenticator;
import org.keycloak.authentication.ClientAuthenticatorFactory;
import org.keycloak.jose.jws.Algorithm;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakUriInfo;
import org.keycloak.models.RealmModel;
import org.keycloak.protocol.oidc.OIDCLoginProtocolService;
import org.keycloak.protocol.oidc.endpoints.TokenEndpoint;
import org.keycloak.protocol.oidc.representations.OIDCConfigurationRepresentation;
import org.keycloak.provider.ProviderFactory;
import org.keycloak.services.Urls;
import org.keycloak.services.clientregistration.ClientRegistrationService;
import org.keycloak.services.resources.RealmsResource;
import org.keycloak.wellknown.WellKnownProvider;

public class OIDCWellKnownProvider
implements WellKnownProvider {
    public static final List<String> DEFAULT_ID_TOKEN_SIGNING_ALG_VALUES_SUPPORTED = OIDCWellKnownProvider.list(Algorithm.RS256.toString());
    public static final List<String> DEFAULT_USER_INFO_SIGNING_ALG_VALUES_SUPPORTED = OIDCWellKnownProvider.list(Algorithm.RS256.toString());
    public static final List<String> DEFAULT_REQUEST_OBJECT_SIGNING_ALG_VALUES_SUPPORTED = OIDCWellKnownProvider.list(Algorithm.none.toString(), Algorithm.RS256.toString());
    public static final List<String> DEFAULT_GRANT_TYPES_SUPPORTED = OIDCWellKnownProvider.list("authorization_code", "implicit", "refresh_token", "password", "client_credentials");
    public static final List<String> DEFAULT_RESPONSE_TYPES_SUPPORTED = OIDCWellKnownProvider.list("code", "none", "id_token", "token", "id_token token", "code id_token", "code token", "code id_token token");
    public static final List<String> DEFAULT_SUBJECT_TYPES_SUPPORTED = OIDCWellKnownProvider.list("public", "pairwise");
    public static final List<String> DEFAULT_RESPONSE_MODES_SUPPORTED = OIDCWellKnownProvider.list("query", "fragment", "form_post");
    public static final List<String> DEFAULT_CLIENT_AUTH_SIGNING_ALG_VALUES_SUPPORTED = OIDCWellKnownProvider.list(Algorithm.RS256.toString());
    public static final List<String> DEFAULT_CLAIMS_SUPPORTED = OIDCWellKnownProvider.list("sub", "iss", "auth_time", "name", "given_name", "family_name", "preferred_username", "email");
    public static final List<String> DEFAULT_CLAIM_TYPES_SUPPORTED = OIDCWellKnownProvider.list("normal");
    public static final List<String> DEFAULT_CODE_CHALLENGE_METHODS_SUPPORTED = OIDCWellKnownProvider.list("plain", "S256");
    private KeycloakSession session;

    public OIDCWellKnownProvider(KeycloakSession session) {
        this.session = session;
    }

    @Override
    public Object getConfig() {
        KeycloakUriInfo uriInfo = this.session.getContext().getUri();
        RealmModel realm = this.session.getContext().getRealm();
        UriBuilder uriBuilder = RealmsResource.protocolUrl((UriInfo)uriInfo);
        OIDCConfigurationRepresentation config = new OIDCConfigurationRepresentation();
        config.setIssuer(Urls.realmIssuer(uriInfo.getBaseUri(), realm.getName()));
        config.setAuthorizationEndpoint(uriBuilder.clone().path(OIDCLoginProtocolService.class, "auth").build(new Object[]{realm.getName(), "openid-connect"}).toString());
        config.setTokenEndpoint(uriBuilder.clone().path(OIDCLoginProtocolService.class, "token").build(new Object[]{realm.getName(), "openid-connect"}).toString());
        config.setTokenIntrospectionEndpoint(uriBuilder.clone().path(OIDCLoginProtocolService.class, "token").path(TokenEndpoint.class, "introspect").build(new Object[]{realm.getName(), "openid-connect"}).toString());
        config.setUserinfoEndpoint(uriBuilder.clone().path(OIDCLoginProtocolService.class, "issueUserInfo").build(new Object[]{realm.getName(), "openid-connect"}).toString());
        config.setLogoutEndpoint(uriBuilder.clone().path(OIDCLoginProtocolService.class, "logout").build(new Object[]{realm.getName(), "openid-connect"}).toString());
        config.setJwksUri(uriBuilder.clone().path(OIDCLoginProtocolService.class, "certs").build(new Object[]{realm.getName(), "openid-connect"}).toString());
        config.setCheckSessionIframe(uriBuilder.clone().path(OIDCLoginProtocolService.class, "getLoginStatusIframe").build(new Object[]{realm.getName(), "openid-connect"}).toString());
        config.setRegistrationEndpoint(RealmsResource.clientRegistrationUrl((UriInfo)uriInfo).path(ClientRegistrationService.class, "provider").build(new Object[]{realm.getName(), "openid-connect"}).toString());
        config.setIdTokenSigningAlgValuesSupported(DEFAULT_ID_TOKEN_SIGNING_ALG_VALUES_SUPPORTED);
        config.setUserInfoSigningAlgValuesSupported(DEFAULT_USER_INFO_SIGNING_ALG_VALUES_SUPPORTED);
        config.setRequestObjectSigningAlgValuesSupported(DEFAULT_REQUEST_OBJECT_SIGNING_ALG_VALUES_SUPPORTED);
        config.setResponseTypesSupported(DEFAULT_RESPONSE_TYPES_SUPPORTED);
        config.setSubjectTypesSupported(DEFAULT_SUBJECT_TYPES_SUPPORTED);
        config.setResponseModesSupported(DEFAULT_RESPONSE_MODES_SUPPORTED);
        config.setGrantTypesSupported(DEFAULT_GRANT_TYPES_SUPPORTED);
        config.setTokenEndpointAuthMethodsSupported(this.getClientAuthMethodsSupported());
        config.setTokenEndpointAuthSigningAlgValuesSupported(DEFAULT_CLIENT_AUTH_SIGNING_ALG_VALUES_SUPPORTED);
        config.setClaimsSupported(DEFAULT_CLAIMS_SUPPORTED);
        config.setClaimTypesSupported(DEFAULT_CLAIM_TYPES_SUPPORTED);
        config.setClaimsParameterSupported(false);
        List scopes = realm.getClientScopes();
        LinkedList<String> scopeNames = new LinkedList<String>();
        for (ClientScopeModel clientScope : scopes) {
            if (!clientScope.getProtocol().equals("openid-connect")) continue;
            scopeNames.add(clientScope.getName());
        }
        scopeNames.add(0, "openid");
        config.setScopesSupported(scopeNames);
        config.setRequestParameterSupported(true);
        config.setRequestUriParameterSupported(true);
        config.setCodeChallengeMethodsSupported(DEFAULT_CODE_CHALLENGE_METHODS_SUPPORTED);
        config.setTlsClientCertificateBoundAccessTokens(true);
        return config;
    }

    public void close() {
    }

    private static List<String> list(String ... values) {
        LinkedList<String> s = new LinkedList<String>();
        for (String v : values) {
            s.add(v);
        }
        return s;
    }

    private List<String> getClientAuthMethodsSupported() {
        ArrayList<String> result = new ArrayList<String>();
        List providerFactories = this.session.getKeycloakSessionFactory().getProviderFactories(ClientAuthenticator.class);
        for (ProviderFactory factory : providerFactories) {
            ClientAuthenticatorFactory clientAuthFactory = (ClientAuthenticatorFactory)factory;
            result.addAll(clientAuthFactory.getProtocolAuthenticatorMethods("openid-connect"));
        }
        return result;
    }
}

