/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.jpa.updater.liquibase.lock;

import java.sql.Connection;
import java.sql.SQLException;
import liquibase.Liquibase;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import org.jboss.logging.Logger;
import org.keycloak.connections.jpa.JpaConnectionProvider;
import org.keycloak.connections.jpa.JpaConnectionProviderFactory;
import org.keycloak.connections.jpa.updater.liquibase.conn.LiquibaseConnectionProvider;
import org.keycloak.connections.jpa.updater.liquibase.lock.CustomLockService;
import org.keycloak.connections.jpa.updater.liquibase.lock.LiquibaseDBLockProviderFactory;
import org.keycloak.connections.jpa.updater.liquibase.lock.LockRetryException;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.dblock.DBLockProvider;
import org.keycloak.models.utils.KeycloakModelUtils;

public class LiquibaseDBLockProvider
implements DBLockProvider {
    private static final Logger logger = Logger.getLogger(LiquibaseDBLockProvider.class);
    private int DEFAULT_MAX_ATTEMPTS = 3;
    private final LiquibaseDBLockProviderFactory factory;
    private final KeycloakSession session;
    private CustomLockService lockService;
    private Connection dbConnection;
    private boolean initialized = false;
    private int maxAttempts = this.DEFAULT_MAX_ATTEMPTS;

    public LiquibaseDBLockProvider(LiquibaseDBLockProviderFactory factory, KeycloakSession session) {
        this.factory = factory;
        this.session = session;
    }

    private void lazyInit() {
        if (!this.initialized) {
            LiquibaseConnectionProvider liquibaseProvider = (LiquibaseConnectionProvider)this.session.getProvider(LiquibaseConnectionProvider.class);
            JpaConnectionProviderFactory jpaProviderFactory = (JpaConnectionProviderFactory)this.session.getKeycloakSessionFactory().getProviderFactory(JpaConnectionProvider.class);
            this.dbConnection = jpaProviderFactory.getConnection();
            String defaultSchema = jpaProviderFactory.getSchema();
            try {
                Liquibase liquibase = liquibaseProvider.getLiquibase(this.dbConnection, defaultSchema);
                this.lockService = new CustomLockService();
                this.lockService.setChangeLogLockWaitTime(this.factory.getLockWaitTimeoutMillis());
                this.lockService.setDatabase(liquibase.getDatabase());
                this.initialized = true;
            }
            catch (LiquibaseException exception) {
                this.safeRollbackConnection();
                this.safeCloseConnection();
                throw new IllegalStateException(exception);
            }
        }
    }

    private void restart() {
        this.safeCloseConnection();
        this.dbConnection = null;
        this.lockService = null;
        this.initialized = false;
        this.lazyInit();
    }

    public void waitForLock() {
        KeycloakModelUtils.suspendJtaTransaction((KeycloakSessionFactory)this.session.getKeycloakSessionFactory(), () -> {
            this.lazyInit();
            while (this.maxAttempts > 0) {
                try {
                    this.lockService.waitForLock();
                    this.factory.setHasLock(true);
                    this.maxAttempts = this.DEFAULT_MAX_ATTEMPTS;
                    return;
                }
                catch (LockRetryException le) {
                    this.safeRollbackConnection();
                    this.restart();
                    --this.maxAttempts;
                }
                catch (RuntimeException re) {
                    this.safeRollbackConnection();
                    this.safeCloseConnection();
                    throw re;
                }
            }
        });
    }

    public void releaseLock() {
        KeycloakModelUtils.suspendJtaTransaction((KeycloakSessionFactory)this.session.getKeycloakSessionFactory(), () -> {
            this.lazyInit();
            this.lockService.releaseLock();
            this.lockService.reset();
            this.factory.setHasLock(false);
        });
    }

    public boolean hasLock() {
        return this.factory.hasLock();
    }

    public boolean supportsForcedUnlock() {
        return false;
    }

    public void destroyLockInfo() {
        KeycloakModelUtils.suspendJtaTransaction((KeycloakSessionFactory)this.session.getKeycloakSessionFactory(), () -> {
            this.lazyInit();
            try {
                this.lockService.destroy();
                this.dbConnection.commit();
                logger.debug((Object)"Destroyed lock table");
            }
            catch (SQLException | DatabaseException de) {
                logger.error((Object)"Failed to destroy lock table");
                this.safeRollbackConnection();
            }
        });
    }

    public void close() {
        KeycloakModelUtils.suspendJtaTransaction((KeycloakSessionFactory)this.session.getKeycloakSessionFactory(), () -> this.safeCloseConnection());
    }

    private void safeRollbackConnection() {
        if (this.dbConnection != null) {
            try {
                this.dbConnection.rollback();
            }
            catch (SQLException se) {
                logger.warn((Object)"Failed to rollback connection after error", (Throwable)se);
            }
        }
    }

    private void safeCloseConnection() {
        if (this.dbConnection != null) {
            try {
                this.dbConnection.close();
            }
            catch (SQLException e) {
                logger.warn((Object)"Failed to close connection", (Throwable)e);
            }
        }
    }
}

