/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.policy.evaluation;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.keycloak.authorization.Decision;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.permission.ResourcePermission;
import org.keycloak.authorization.policy.evaluation.DefaultEvaluation;
import org.keycloak.authorization.policy.evaluation.Result;
import org.keycloak.representations.idm.authorization.DecisionStrategy;

public abstract class AbstractDecisionCollector
implements Decision<DefaultEvaluation> {
    protected final Map<ResourcePermission, Result> results = new LinkedHashMap<ResourcePermission, Result>();

    @Override
    public void onDecision(DefaultEvaluation evaluation) {
        Policy parentPolicy = evaluation.getParentPolicy();
        if (parentPolicy != null) {
            if (parentPolicy.equals(evaluation.getPolicy())) {
                Result.PolicyResult cached = this.results.computeIfAbsent(evaluation.getPermission(), permission -> new Result((ResourcePermission)permission, evaluation)).policy(parentPolicy);
                for (Result result : this.results.values()) {
                    Result.PolicyResult policyResult = result.getPolicy(parentPolicy);
                    if (policyResult == null) continue;
                    for (Result.PolicyResult associatePolicy : policyResult.getAssociatedPolicies()) {
                        cached.policy(associatePolicy.getPolicy(), associatePolicy.getEffect());
                    }
                }
            } else {
                this.results.computeIfAbsent(evaluation.getPermission(), permission -> new Result((ResourcePermission)permission, evaluation)).policy(parentPolicy).policy(evaluation.getPolicy(), evaluation.getEffect());
            }
        } else {
            this.results.computeIfAbsent(evaluation.getPermission(), permission -> new Result((ResourcePermission)permission, evaluation)).setStatus(evaluation.getEffect());
        }
    }

    @Override
    public void onComplete() {
        this.onComplete(this.results.values());
    }

    @Override
    public void onComplete(ResourcePermission permission) {
        Result result = this.results.get(permission);
        if (result != null) {
            this.onComplete(result);
        }
    }

    protected void onComplete(Result result) {
    }

    protected void onComplete(Collection<Result> permissions) {
    }

    protected boolean isGranted(Result.PolicyResult policyResult) {
        Policy policy = policyResult.getPolicy();
        DecisionStrategy decisionStrategy = policy.getDecisionStrategy();
        switch (decisionStrategy) {
            case AFFIRMATIVE: {
                for (Result.PolicyResult decision : policyResult.getAssociatedPolicies()) {
                    if (!Decision.Effect.PERMIT.equals((Object)decision.getEffect())) continue;
                    return true;
                }
                return false;
            }
            case CONSENSUS: {
                int grantCount = 0;
                int denyCount = policy.getAssociatedPolicies().size();
                for (Result.PolicyResult decision : policyResult.getAssociatedPolicies()) {
                    if (!decision.getEffect().equals((Object)Decision.Effect.PERMIT)) continue;
                    ++grantCount;
                    --denyCount;
                }
                return grantCount > denyCount;
            }
        }
        for (Result.PolicyResult decision : policyResult.getAssociatedPolicies()) {
            if (!Decision.Effect.DENY.equals((Object)decision.getEffect())) continue;
            return false;
        }
        return true;
    }
}

