/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.policy.evaluation;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.keycloak.authorization.Decision;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.permission.ResourcePermission;
import org.keycloak.authorization.policy.evaluation.Evaluation;

public class Result {
    private final ResourcePermission permission;
    private final Map<String, PolicyResult> results = new LinkedHashMap<String, PolicyResult>();
    private final Evaluation evaluation;
    private Decision.Effect status = Decision.Effect.DENY;

    public Result(ResourcePermission permission, Evaluation evaluation) {
        this.permission = permission;
        this.evaluation = evaluation;
    }

    public ResourcePermission getPermission() {
        return this.permission;
    }

    public Collection<PolicyResult> getResults() {
        return this.results.values();
    }

    public Evaluation getEvaluation() {
        return this.evaluation;
    }

    public PolicyResult policy(Policy policy) {
        return this.results.computeIfAbsent(policy.getId(), id -> new PolicyResult(policy));
    }

    public void setStatus(Decision.Effect status) {
        this.status = status;
    }

    public Decision.Effect getEffect() {
        return this.status;
    }

    public PolicyResult getPolicy(Policy policy) {
        return this.results.get(policy.getId());
    }

    public static class PolicyResult {
        private final Policy policy;
        private final Map<String, PolicyResult> associatedPolicies = new HashMap<String, PolicyResult>();
        private Decision.Effect effect = Decision.Effect.DENY;

        public PolicyResult(Policy policy, Decision.Effect status) {
            this.policy = policy;
            this.effect = status;
        }

        public PolicyResult(Policy policy) {
            this(policy, Decision.Effect.DENY);
        }

        public PolicyResult policy(Policy policy, Decision.Effect effect) {
            PolicyResult result = this.associatedPolicies.computeIfAbsent(policy.getId(), id -> new PolicyResult(policy, effect));
            result.setEffect(effect);
            return result;
        }

        public Policy getPolicy() {
            return this.policy;
        }

        public Collection<PolicyResult> getAssociatedPolicies() {
            return this.associatedPolicies.values();
        }

        public Decision.Effect getEffect() {
            return this.effect;
        }

        public void setEffect(Decision.Effect status) {
            this.effect = status;
        }
    }
}

