/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.url;

import org.keycloak.Config;
import org.keycloak.models.KeycloakSession;
import org.keycloak.url.FixedHostnameProvider;
import org.keycloak.urls.HostnameProvider;
import org.keycloak.urls.HostnameProviderFactory;

public class FixedHostnameProviderFactory
implements HostnameProviderFactory {
    private String hostname;
    private int httpPort;
    private int httpsPort;

    public HostnameProvider create(KeycloakSession session) {
        return new FixedHostnameProvider(session, this.hostname, this.httpPort, this.httpsPort);
    }

    public void init(Config.Scope config) {
        this.hostname = config.get("hostname");
        if (this.hostname == null) {
            throw new RuntimeException("hostname not set");
        }
        this.httpPort = config.getInt("httpPort", Integer.valueOf(-1));
        this.httpsPort = config.getInt("httpsPort", Integer.valueOf(-1));
    }

    public String getId() {
        return "fixed";
    }
}

