/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc;

import java.io.IOException;
import java.net.URI;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.keycloak.TokenIdGenerator;
import org.keycloak.common.util.Time;
import org.keycloak.connections.httpclient.HttpClientProvider;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientSessionContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.LoginProtocol;
import org.keycloak.protocol.oidc.OIDCAdvancedConfigWrapper;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.protocol.oidc.utils.OIDCRedirectUriBuilder;
import org.keycloak.protocol.oidc.utils.OIDCResponseMode;
import org.keycloak.protocol.oidc.utils.OIDCResponseType;
import org.keycloak.representations.AccessTokenResponse;
import org.keycloak.representations.adapters.action.PushNotBeforeAction;
import org.keycloak.services.ServicesLogger;
import org.keycloak.services.managers.AuthenticationSessionManager;
import org.keycloak.services.managers.ClientSessionCode;
import org.keycloak.services.managers.ResourceAdminManager;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.util.TokenUtil;

public class OIDCLoginProtocol
implements LoginProtocol {
    public static final String LOGIN_PROTOCOL = "openid-connect";
    public static final String STATE_PARAM = "state";
    public static final String LOGOUT_STATE_PARAM = "OIDC_LOGOUT_STATE_PARAM";
    public static final String SCOPE_PARAM = "scope";
    public static final String CODE_PARAM = "code";
    public static final String RESPONSE_TYPE_PARAM = "response_type";
    public static final String GRANT_TYPE_PARAM = "grant_type";
    public static final String REDIRECT_URI_PARAM = "redirect_uri";
    public static final String CLIENT_ID_PARAM = "client_id";
    public static final String NONCE_PARAM = "nonce";
    public static final String MAX_AGE_PARAM = "max_age";
    public static final String PROMPT_PARAM = "prompt";
    public static final String LOGIN_HINT_PARAM = "login_hint";
    public static final String REQUEST_PARAM = "request";
    public static final String REQUEST_URI_PARAM = "request_uri";
    public static final String UI_LOCALES_PARAM = "ui_locales";
    public static final String CLAIMS_PARAM = "claims";
    public static final String ACR_PARAM = "acr_values";
    public static final String LOGOUT_REDIRECT_URI = "OIDC_LOGOUT_REDIRECT_URI";
    public static final String ISSUER = "iss";
    public static final String RESPONSE_MODE_PARAM = "response_mode";
    public static final String PROMPT_VALUE_NONE = "none";
    public static final String PROMPT_VALUE_LOGIN = "login";
    public static final String PROMPT_VALUE_CONSENT = "consent";
    public static final String PROMPT_VALUE_SELECT_ACCOUNT = "select_account";
    public static final String CLIENT_SECRET_BASIC = "client_secret_basic";
    public static final String CLIENT_SECRET_POST = "client_secret_post";
    public static final String CLIENT_SECRET_JWT = "client_secret_jwt";
    public static final String PRIVATE_KEY_JWT = "private_key_jwt";
    public static final String CODE_CHALLENGE_PARAM = "code_challenge";
    public static final String CODE_CHALLENGE_METHOD_PARAM = "code_challenge_method";
    public static final int PKCE_CODE_CHALLENGE_MIN_LENGTH = 43;
    public static final int PKCE_CODE_CHALLENGE_MAX_LENGTH = 128;
    public static final int PKCE_CODE_VERIFIER_MIN_LENGTH = 43;
    public static final int PKCE_CODE_VERIFIER_MAX_LENGTH = 128;
    public static final String PKCE_METHOD_PLAIN = "plain";
    public static final String PKCE_METHOD_S256 = "S256";
    private static final Logger logger = Logger.getLogger(OIDCLoginProtocol.class);
    protected KeycloakSession session;
    protected RealmModel realm;
    protected UriInfo uriInfo;
    protected HttpHeaders headers;
    protected EventBuilder event;
    protected OIDCResponseType responseType;
    protected OIDCResponseMode responseMode;

    public OIDCLoginProtocol(KeycloakSession session, RealmModel realm, UriInfo uriInfo, HttpHeaders headers, EventBuilder event) {
        this.session = session;
        this.realm = realm;
        this.uriInfo = uriInfo;
        this.headers = headers;
        this.event = event;
    }

    public OIDCLoginProtocol() {
    }

    private void setupResponseTypeAndMode(String responseType, String responseMode) {
        this.responseType = OIDCResponseType.parse(responseType);
        this.responseMode = OIDCResponseMode.parse(responseMode, this.responseType);
        this.event.detail(RESPONSE_TYPE_PARAM, responseType);
        this.event.detail(RESPONSE_MODE_PARAM, this.responseMode.toString().toLowerCase());
    }

    public OIDCLoginProtocol setSession(KeycloakSession session) {
        this.session = session;
        return this;
    }

    public OIDCLoginProtocol setRealm(RealmModel realm) {
        this.realm = realm;
        return this;
    }

    public OIDCLoginProtocol setUriInfo(UriInfo uriInfo) {
        this.uriInfo = uriInfo;
        return this;
    }

    public OIDCLoginProtocol setHttpHeaders(HttpHeaders headers) {
        this.headers = headers;
        return this;
    }

    public OIDCLoginProtocol setEventBuilder(EventBuilder event) {
        this.event = event;
        return this;
    }

    public Response authenticated(UserSessionModel userSession, ClientSessionContext clientSessionCtx) {
        OIDCAdvancedConfigWrapper clientConfig;
        AuthenticatedClientSessionModel clientSession = clientSessionCtx.getClientSession();
        ClientSessionCode<AuthenticatedClientSessionModel> accessCode = new ClientSessionCode<AuthenticatedClientSessionModel>(this.session, this.realm, clientSession);
        String responseTypeParam = clientSession.getNote(RESPONSE_TYPE_PARAM);
        String responseModeParam = clientSession.getNote(RESPONSE_MODE_PARAM);
        this.setupResponseTypeAndMode(responseTypeParam, responseModeParam);
        String redirect = clientSession.getRedirectUri();
        OIDCRedirectUriBuilder redirectUri = OIDCRedirectUriBuilder.fromUri(redirect, this.responseMode);
        String state = clientSession.getNote(STATE_PARAM);
        logger.debugv("redirectAccessCode: state: {0}", (Object)state);
        if (state != null) {
            redirectUri.addParam(STATE_PARAM, state);
        }
        if (!(clientConfig = OIDCAdvancedConfigWrapper.fromClientModel(clientSession.getClient())).isExcludeSessionStateFromAuthResponse()) {
            redirectUri.addParam("session_state", userSession.getId());
        }
        String code = null;
        if (this.responseType.hasResponseType(CODE_PARAM)) {
            code = accessCode.getOrGenerateCode();
            redirectUri.addParam(CODE_PARAM, code);
        }
        if (this.responseType.isImplicitOrHybridFlow()) {
            TokenManager tokenManager = new TokenManager();
            TokenManager.AccessTokenResponseBuilder responseBuilder = tokenManager.responseBuilder(this.realm, clientSession.getClient(), this.event, this.session, userSession, clientSessionCtx).generateAccessToken();
            if (this.responseType.hasResponseType("id_token")) {
                responseBuilder.generateIDToken();
                if (this.responseType.hasResponseType("token")) {
                    responseBuilder.generateAccessTokenHash();
                }
                if (this.responseType.hasResponseType(CODE_PARAM)) {
                    responseBuilder.generateCodeHash(code);
                }
                if (state != null && !state.isEmpty()) {
                    responseBuilder.generateStateHash(state);
                }
            }
            AccessTokenResponse res = responseBuilder.build();
            if (this.responseType.hasResponseType("id_token")) {
                redirectUri.addParam("id_token", res.getIdToken());
            }
            if (this.responseType.hasResponseType("token")) {
                redirectUri.addParam("access_token", res.getToken());
                if (this.responseType.isImplicitFlow()) {
                    redirectUri.addParam("token_type", res.getTokenType());
                    redirectUri.addParam("expires_in", String.valueOf(res.getExpiresIn()));
                }
            }
        }
        return redirectUri.build();
    }

    public Response sendError(AuthenticationSessionModel authSession, LoginProtocol.Error error) {
        String responseTypeParam = authSession.getClientNote(RESPONSE_TYPE_PARAM);
        String responseModeParam = authSession.getClientNote(RESPONSE_MODE_PARAM);
        this.setupResponseTypeAndMode(responseTypeParam, responseModeParam);
        String redirect = authSession.getRedirectUri();
        String state = authSession.getClientNote(STATE_PARAM);
        OIDCRedirectUriBuilder redirectUri = OIDCRedirectUriBuilder.fromUri(redirect, this.responseMode).addParam("error", this.translateError(error));
        if (state != null) {
            redirectUri.addParam(STATE_PARAM, state);
        }
        new AuthenticationSessionManager(this.session).removeAuthenticationSession(this.realm, authSession, true);
        return redirectUri.build();
    }

    private String translateError(LoginProtocol.Error error) {
        switch (error) {
            case CANCELLED_BY_USER: 
            case CONSENT_DENIED: {
                return "access_denied";
            }
            case PASSIVE_INTERACTION_REQUIRED: {
                return "interaction_required";
            }
            case PASSIVE_LOGIN_REQUIRED: {
                return "login_required";
            }
        }
        ServicesLogger.LOGGER.untranslatedProtocol(error.name());
        return "server_error";
    }

    public void backchannelLogout(UserSessionModel userSession, AuthenticatedClientSessionModel clientSession) {
        ClientModel client = clientSession.getClient();
        new ResourceAdminManager(this.session).logoutClientSession(this.uriInfo.getRequestUri(), this.realm, client, clientSession);
    }

    public Response frontchannelLogout(UserSessionModel userSession, AuthenticatedClientSessionModel clientSession) {
        throw new RuntimeException("NOT IMPLEMENTED");
    }

    public Response finishLogout(UserSessionModel userSession) {
        String redirectUri = userSession.getNote(LOGOUT_REDIRECT_URI);
        String state = userSession.getNote(LOGOUT_STATE_PARAM);
        this.event.event(EventType.LOGOUT);
        if (redirectUri != null) {
            this.event.detail(REDIRECT_URI_PARAM, redirectUri);
        }
        this.event.user(userSession.getUser()).session(userSession).success();
        if (redirectUri != null) {
            UriBuilder uriBuilder = UriBuilder.fromUri((String)redirectUri);
            if (state != null) {
                uriBuilder.queryParam(STATE_PARAM, new Object[]{state});
            }
            return Response.status((int)302).location(uriBuilder.build(new Object[0])).build();
        }
        return Response.ok().build();
    }

    public boolean requireReauthentication(UserSessionModel userSession, AuthenticationSessionModel authSession) {
        return this.isPromptLogin(authSession) || this.isAuthTimeExpired(userSession, authSession);
    }

    protected boolean isPromptLogin(AuthenticationSessionModel authSession) {
        String prompt = authSession.getClientNote(PROMPT_PARAM);
        return TokenUtil.hasPrompt((String)prompt, (String)PROMPT_VALUE_LOGIN);
    }

    protected boolean isAuthTimeExpired(UserSessionModel userSession, AuthenticationSessionModel authSession) {
        int maxAgeInt;
        String authTime = userSession.getNote("AUTH_TIME");
        String maxAge = authSession.getClientNote(MAX_AGE_PARAM);
        if (maxAge == null) {
            return false;
        }
        int authTimeInt = authTime == null ? 0 : Integer.parseInt(authTime);
        if (authTimeInt + (maxAgeInt = Integer.parseInt(maxAge)) < Time.currentTime()) {
            logger.debugf("Authentication time is expired, needs to reauthenticate. userSession=%s, clientId=%s, maxAge=%d, authTime=%d", new Object[]{userSession.getId(), authSession.getClient().getId(), maxAgeInt, authTimeInt});
            return true;
        }
        return false;
    }

    public boolean sendPushRevocationPolicyRequest(RealmModel realm, ClientModel resource, int notBefore, String managementUrl) {
        PushNotBeforeAction adminAction = new PushNotBeforeAction(TokenIdGenerator.generateId(), Time.currentTime() + 30, resource.getClientId(), notBefore);
        String token = new TokenManager().encodeToken(this.session, realm, adminAction);
        logger.debugv("pushRevocation resource: {0} url: {1}", (Object)resource.getClientId(), (Object)managementUrl);
        URI target = UriBuilder.fromUri((String)managementUrl).path("k_push_not_before").build(new Object[0]);
        try {
            int status = ((HttpClientProvider)this.session.getProvider(HttpClientProvider.class)).postText(target.toString(), token);
            boolean success = status == 204 || status == 200;
            logger.debugf("pushRevocation success for %s: %s", (Object)managementUrl, (Object)success);
            return success;
        }
        catch (IOException e) {
            ServicesLogger.LOGGER.failedToSendRevocation(e);
            return false;
        }
    }

    public void close() {
    }
}

