/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin.permissions;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jboss.logging.Logger;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.common.ClientModelIdentity;
import org.keycloak.authorization.common.DefaultEvaluationContext;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.models.AdminRoles;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.services.ForbiddenException;
import org.keycloak.services.resources.admin.permissions.ClientPermissionEvaluator;
import org.keycloak.services.resources.admin.permissions.ClientPermissionManagement;
import org.keycloak.services.resources.admin.permissions.Helper;
import org.keycloak.services.resources.admin.permissions.MgmtPermissions;
import org.keycloak.storage.StorageId;

class ClientPermissions
implements ClientPermissionEvaluator,
ClientPermissionManagement {
    private static final Logger logger = Logger.getLogger(ClientPermissions.class);
    protected final KeycloakSession session;
    protected final RealmModel realm;
    protected final AuthorizationProvider authz;
    protected final MgmtPermissions root;

    public ClientPermissions(KeycloakSession session, RealmModel realm, AuthorizationProvider authz, MgmtPermissions root) {
        this.session = session;
        this.realm = realm;
        this.authz = authz;
        this.root = root;
    }

    private String getResourceName(ClientModel client) {
        return "client.resource." + client.getId();
    }

    private String getManagePermissionName(ClientModel client) {
        return "manage.permission.client." + client.getId();
    }

    private String getConfigurePermissionName(ClientModel client) {
        return "configure.permission.client." + client.getId();
    }

    private String getViewPermissionName(ClientModel client) {
        return "view.permission.client." + client.getId();
    }

    private String getMapRolesPermissionName(ClientModel client) {
        return "map-roles.permission.client." + client.getId();
    }

    private String getMapRolesClientScopePermissionName(ClientModel client) {
        return "map-roles-client-scope.permission.client." + client.getId();
    }

    private String getMapRolesCompositePermissionName(ClientModel client) {
        return "map-roles-composite.permission.client." + client.getId();
    }

    private String getExchangeToPermissionName(ClientModel client) {
        return "token-exchange.permission.client." + client.getId();
    }

    private void initialize(ClientModel client) {
        Scope mapRoleScope;
        Scope viewScope;
        ResourceServer server = this.root.findOrCreateResourceServer(client);
        Scope manageScope = this.manageScope(server);
        if (manageScope == null) {
            manageScope = this.authz.getStoreFactory().getScopeStore().create("manage", server);
        }
        if ((viewScope = this.viewScope(server)) == null) {
            viewScope = this.authz.getStoreFactory().getScopeStore().create("view", server);
        }
        if ((mapRoleScope = this.mapRolesScope(server)) == null) {
            mapRoleScope = this.authz.getStoreFactory().getScopeStore().create("map-roles", server);
        }
        Scope mapRoleClientScope = this.root.initializeScope("map-roles-client-scope", server);
        Scope mapRoleCompositeScope = this.root.initializeScope("map-roles-composite", server);
        Scope configureScope = this.root.initializeScope("configure", server);
        Scope exchangeToScope = this.root.initializeScope("token-exchange", server);
        String resourceName = this.getResourceName(client);
        Resource resource = this.authz.getStoreFactory().getResourceStore().findByName(resourceName, server.getId());
        if (resource == null) {
            resource = this.authz.getStoreFactory().getResourceStore().create(resourceName, server, server.getId());
            resource.setType("Client");
            HashSet<Scope> scopeset = new HashSet<Scope>();
            scopeset.add(configureScope);
            scopeset.add(manageScope);
            scopeset.add(viewScope);
            scopeset.add(mapRoleScope);
            scopeset.add(mapRoleClientScope);
            scopeset.add(mapRoleCompositeScope);
            scopeset.add(exchangeToScope);
            resource.updateScopes(scopeset);
        }
        String managePermissionName = this.getManagePermissionName(client);
        Policy managePermission = this.authz.getStoreFactory().getPolicyStore().findByName(managePermissionName, server.getId());
        if (managePermission == null) {
            Helper.addEmptyScopePermission(this.authz, server, managePermissionName, resource, manageScope);
        }
        String configurePermissionName = this.getConfigurePermissionName(client);
        Policy configurePermission = this.authz.getStoreFactory().getPolicyStore().findByName(configurePermissionName, server.getId());
        if (configurePermission == null) {
            Helper.addEmptyScopePermission(this.authz, server, configurePermissionName, resource, configureScope);
        }
        String viewPermissionName = this.getViewPermissionName(client);
        Policy viewPermission = this.authz.getStoreFactory().getPolicyStore().findByName(viewPermissionName, server.getId());
        if (viewPermission == null) {
            Helper.addEmptyScopePermission(this.authz, server, viewPermissionName, resource, viewScope);
        }
        String mapRolePermissionName = this.getMapRolesPermissionName(client);
        Policy mapRolePermission = this.authz.getStoreFactory().getPolicyStore().findByName(mapRolePermissionName, server.getId());
        if (mapRolePermission == null) {
            Helper.addEmptyScopePermission(this.authz, server, mapRolePermissionName, resource, mapRoleScope);
        }
        String mapRoleClientScopePermissionName = this.getMapRolesClientScopePermissionName(client);
        Policy mapRoleClientScopePermission = this.authz.getStoreFactory().getPolicyStore().findByName(mapRoleClientScopePermissionName, server.getId());
        if (mapRoleClientScopePermission == null) {
            Helper.addEmptyScopePermission(this.authz, server, mapRoleClientScopePermissionName, resource, mapRoleClientScope);
        }
        String mapRoleCompositePermissionName = this.getMapRolesCompositePermissionName(client);
        Policy mapRoleCompositePermission = this.authz.getStoreFactory().getPolicyStore().findByName(mapRoleCompositePermissionName, server.getId());
        if (mapRoleCompositePermission == null) {
            Helper.addEmptyScopePermission(this.authz, server, mapRoleCompositePermissionName, resource, mapRoleCompositeScope);
        }
        String exchangeToPermissionName = this.getExchangeToPermissionName(client);
        Policy exchangeToPermission = this.authz.getStoreFactory().getPolicyStore().findByName(exchangeToPermissionName, server.getId());
        if (exchangeToPermission == null) {
            Helper.addEmptyScopePermission(this.authz, server, exchangeToPermissionName, resource, exchangeToScope);
        }
    }

    private void deletePolicy(String name, ResourceServer server) {
        Policy policy = this.authz.getStoreFactory().getPolicyStore().findByName(name, server.getId());
        if (policy != null) {
            this.authz.getStoreFactory().getPolicyStore().delete(policy.getId());
        }
    }

    private void deletePermissions(ClientModel client) {
        ResourceServer server = this.resourceServer(client);
        if (server == null) {
            return;
        }
        this.deletePolicy(this.getManagePermissionName(client), server);
        this.deletePolicy(this.getViewPermissionName(client), server);
        this.deletePolicy(this.getMapRolesPermissionName(client), server);
        this.deletePolicy(this.getMapRolesClientScopePermissionName(client), server);
        this.deletePolicy(this.getMapRolesCompositePermissionName(client), server);
        this.deletePolicy(this.getConfigurePermissionName(client), server);
        this.deletePolicy(this.getExchangeToPermissionName(client), server);
        Resource resource = this.authz.getStoreFactory().getResourceStore().findByName(this.getResourceName(client), server.getId());
        if (resource != null) {
            this.authz.getStoreFactory().getResourceStore().delete(resource.getId());
        }
    }

    @Override
    public boolean isPermissionsEnabled(ClientModel client) {
        ResourceServer server = this.resourceServer(client);
        if (server == null) {
            return false;
        }
        return this.authz.getStoreFactory().getResourceStore().findByName(this.getResourceName(client), server.getId()) != null;
    }

    @Override
    public void setPermissionsEnabled(ClientModel client, boolean enable) {
        if (enable) {
            this.initialize(client);
        } else {
            this.deletePermissions(client);
        }
    }

    private Scope manageScope(ResourceServer server) {
        return this.authz.getStoreFactory().getScopeStore().findByName("manage", server.getId());
    }

    private Scope exchangeToScope(ResourceServer server) {
        return this.authz.getStoreFactory().getScopeStore().findByName("token-exchange", server.getId());
    }

    private Scope configureScope(ResourceServer server) {
        return this.authz.getStoreFactory().getScopeStore().findByName("configure", server.getId());
    }

    private Scope viewScope(ResourceServer server) {
        return this.authz.getStoreFactory().getScopeStore().findByName("view", server.getId());
    }

    private Scope mapRolesScope(ResourceServer server) {
        return this.authz.getStoreFactory().getScopeStore().findByName("map-roles", server.getId());
    }

    @Override
    public boolean canList() {
        return this.root.hasAnyAdminRole();
    }

    @Override
    public void requireList() {
        if (!this.canList()) {
            throw new ForbiddenException();
        }
    }

    @Override
    public boolean canListClientScopes() {
        return this.root.hasAnyAdminRole();
    }

    @Override
    public void requireListClientScopes() {
        if (!this.canListClientScopes()) {
            throw new ForbiddenException();
        }
    }

    public boolean canManageClientsDefault() {
        return this.root.hasOneAdminRole(AdminRoles.MANAGE_CLIENTS);
    }

    public boolean canViewClientDefault() {
        return this.root.hasOneAdminRole(AdminRoles.MANAGE_CLIENTS, AdminRoles.VIEW_CLIENTS);
    }

    @Override
    public boolean canManage() {
        return this.canManageClientsDefault();
    }

    @Override
    public void requireManage() {
        if (!this.canManage()) {
            throw new ForbiddenException();
        }
    }

    @Override
    public boolean canView() {
        return this.canManageClientsDefault() || this.canViewClientDefault();
    }

    @Override
    public void requireView() {
        if (!this.canView()) {
            throw new ForbiddenException();
        }
    }

    @Override
    public Resource resource(ClientModel client) {
        ResourceServer server = this.resourceServer(client);
        if (server == null) {
            return null;
        }
        Resource resource = this.authz.getStoreFactory().getResourceStore().findByName(this.getResourceName(client), server.getId());
        if (resource == null) {
            return null;
        }
        return resource;
    }

    @Override
    public Map<String, String> getPermissions(ClientModel client) {
        this.initialize(client);
        LinkedHashMap<String, String> scopes = new LinkedHashMap<String, String>();
        scopes.put("view", this.viewPermission(client).getId());
        scopes.put("manage", this.managePermission(client).getId());
        scopes.put("configure", this.configurePermission(client).getId());
        scopes.put("map-roles", this.mapRolesPermission(client).getId());
        scopes.put("map-roles-client-scope", this.mapRolesClientScopePermission(client).getId());
        scopes.put("map-roles-composite", this.mapRolesCompositePermission(client).getId());
        scopes.put("token-exchange", this.exchangeToPermission(client).getId());
        return scopes;
    }

    @Override
    public boolean canExchangeTo(final ClientModel authorizedClient, ClientModel to) {
        if (!authorizedClient.equals(to)) {
            ResourceServer server = this.resourceServer(to);
            if (server == null) {
                logger.debug((Object)"No resource server set up for target client");
                return false;
            }
            Resource resource = this.authz.getStoreFactory().getResourceStore().findByName(this.getResourceName(to), server.getId());
            if (resource == null) {
                logger.debug((Object)"No resource object set up for target client");
                return false;
            }
            Policy policy = this.authz.getStoreFactory().getPolicyStore().findByName(this.getExchangeToPermissionName(to), server.getId());
            if (policy == null) {
                logger.debug((Object)"No permission object set up for target client");
                return false;
            }
            Set associatedPolicies = policy.getAssociatedPolicies();
            if (associatedPolicies == null || associatedPolicies.isEmpty()) {
                logger.debug((Object)"No policies set up for permission on target client");
                return false;
            }
            Scope scope = this.exchangeToScope(server);
            if (scope == null) {
                logger.debug((Object)"token-exchange not initialized");
                return false;
            }
            ClientModelIdentity identity = new ClientModelIdentity(this.session, authorizedClient);
            DefaultEvaluationContext context = new DefaultEvaluationContext(identity, this.session){

                @Override
                public Map<String, Collection<String>> getBaseAttributes() {
                    Map<String, Collection<String>> attributes = super.getBaseAttributes();
                    attributes.put("kc.client.id", Arrays.asList(authorizedClient.getClientId()));
                    return attributes;
                }
            };
            return this.root.evaluatePermission(resource, scope, server, context);
        }
        return true;
    }

    @Override
    public boolean canManage(ClientModel client) {
        if (this.canManageClientsDefault()) {
            return true;
        }
        if (!this.root.isAdminSameRealm()) {
            return false;
        }
        ResourceServer server = this.resourceServer(client);
        if (server == null) {
            return false;
        }
        Resource resource = this.authz.getStoreFactory().getResourceStore().findByName(this.getResourceName(client), server.getId());
        if (resource == null) {
            return false;
        }
        Policy policy = this.authz.getStoreFactory().getPolicyStore().findByName(this.getManagePermissionName(client), server.getId());
        if (policy == null) {
            return false;
        }
        Set associatedPolicies = policy.getAssociatedPolicies();
        if (associatedPolicies == null || associatedPolicies.isEmpty()) {
            return false;
        }
        Scope scope = this.manageScope(server);
        return this.root.evaluatePermission(resource, scope, server);
    }

    @Override
    public boolean canConfigure(ClientModel client) {
        if (this.canManage(client)) {
            return true;
        }
        if (!this.root.isAdminSameRealm()) {
            return false;
        }
        ResourceServer server = this.resourceServer(client);
        if (server == null) {
            return false;
        }
        Resource resource = this.authz.getStoreFactory().getResourceStore().findByName(this.getResourceName(client), server.getId());
        if (resource == null) {
            return false;
        }
        Policy policy = this.authz.getStoreFactory().getPolicyStore().findByName(this.getConfigurePermissionName(client), server.getId());
        if (policy == null) {
            return false;
        }
        Set associatedPolicies = policy.getAssociatedPolicies();
        if (associatedPolicies == null || associatedPolicies.isEmpty()) {
            return false;
        }
        Scope scope = this.configureScope(server);
        return this.root.evaluatePermission(resource, scope, server);
    }

    @Override
    public void requireConfigure(ClientModel client) {
        if (!this.canConfigure(client)) {
            throw new ForbiddenException();
        }
    }

    @Override
    public void requireManage(ClientModel client) {
        if (!this.canManage(client)) {
            throw new ForbiddenException();
        }
    }

    @Override
    public boolean canView(ClientModel client) {
        return this.hasView(client) || this.canConfigure(client);
    }

    private boolean hasView(ClientModel client) {
        if (this.canView()) {
            return true;
        }
        if (!this.root.isAdminSameRealm()) {
            return false;
        }
        ResourceServer server = this.resourceServer(client);
        if (server == null) {
            return false;
        }
        Resource resource = this.authz.getStoreFactory().getResourceStore().findByName(this.getResourceName(client), server.getId());
        if (resource == null) {
            return false;
        }
        Policy policy = this.authz.getStoreFactory().getPolicyStore().findByName(this.getViewPermissionName(client), server.getId());
        if (policy == null) {
            return false;
        }
        Set associatedPolicies = policy.getAssociatedPolicies();
        if (associatedPolicies == null || associatedPolicies.isEmpty()) {
            return false;
        }
        Scope scope = this.viewScope(server);
        return this.root.evaluatePermission(resource, scope, server);
    }

    @Override
    public void requireView(ClientModel client) {
        if (!this.canView(client)) {
            throw new ForbiddenException();
        }
    }

    @Override
    public boolean canViewClientScopes() {
        return this.canView();
    }

    @Override
    public boolean canManageClientScopes() {
        return this.canManageClientsDefault();
    }

    @Override
    public void requireManageClientScopes() {
        if (!this.canManageClientScopes()) {
            throw new ForbiddenException();
        }
    }

    @Override
    public void requireViewClientScopes() {
        if (!this.canViewClientScopes()) {
            throw new ForbiddenException();
        }
    }

    @Override
    public boolean canManage(ClientScopeModel clientScope) {
        return this.canManageClientsDefault();
    }

    @Override
    public void requireManage(ClientScopeModel clientScope) {
        if (!this.canManage(clientScope)) {
            throw new ForbiddenException();
        }
    }

    @Override
    public boolean canView(ClientScopeModel clientScope) {
        return this.canViewClientDefault();
    }

    @Override
    public void requireView(ClientScopeModel clientScope) {
        if (!this.canView(clientScope)) {
            throw new ForbiddenException();
        }
    }

    @Override
    public boolean canMapRoles(ClientModel client) {
        ResourceServer server = this.resourceServer(client);
        if (server == null) {
            return false;
        }
        Resource resource = this.authz.getStoreFactory().getResourceStore().findByName(this.getResourceName(client), server.getId());
        if (resource == null) {
            return false;
        }
        Policy policy = this.authz.getStoreFactory().getPolicyStore().findByName(this.getMapRolesPermissionName(client), server.getId());
        if (policy == null) {
            return false;
        }
        Set associatedPolicies = policy.getAssociatedPolicies();
        if (associatedPolicies == null || associatedPolicies.isEmpty()) {
            return false;
        }
        Scope scope = this.mapRolesScope(server);
        return this.root.evaluatePermission(resource, scope, server);
    }

    @Override
    public Policy exchangeToPermission(ClientModel client) {
        ResourceServer server = this.resourceServer(client);
        if (server == null) {
            return null;
        }
        return this.authz.getStoreFactory().getPolicyStore().findByName(this.getExchangeToPermissionName(client), server.getId());
    }

    @Override
    public Policy mapRolesPermission(ClientModel client) {
        ResourceServer server = this.resourceServer(client);
        if (server == null) {
            return null;
        }
        return this.authz.getStoreFactory().getPolicyStore().findByName(this.getMapRolesPermissionName(client), server.getId());
    }

    @Override
    public Policy mapRolesClientScopePermission(ClientModel client) {
        ResourceServer server = this.resourceServer(client);
        if (server == null) {
            return null;
        }
        return this.authz.getStoreFactory().getPolicyStore().findByName(this.getMapRolesClientScopePermissionName(client), server.getId());
    }

    @Override
    public Policy mapRolesCompositePermission(ClientModel client) {
        ResourceServer server = this.resourceServer(client);
        if (server == null) {
            return null;
        }
        return this.authz.getStoreFactory().getPolicyStore().findByName(this.getMapRolesCompositePermissionName(client), server.getId());
    }

    @Override
    public Policy managePermission(ClientModel client) {
        ResourceServer server = this.resourceServer(client);
        if (server == null) {
            return null;
        }
        return this.authz.getStoreFactory().getPolicyStore().findByName(this.getManagePermissionName(client), server.getId());
    }

    @Override
    public Policy configurePermission(ClientModel client) {
        ResourceServer server = this.resourceServer(client);
        if (server == null) {
            return null;
        }
        return this.authz.getStoreFactory().getPolicyStore().findByName(this.getConfigurePermissionName(client), server.getId());
    }

    @Override
    public Policy viewPermission(ClientModel client) {
        ResourceServer server = this.resourceServer(client);
        if (server == null) {
            return null;
        }
        return this.authz.getStoreFactory().getPolicyStore().findByName(this.getViewPermissionName(client), server.getId());
    }

    @Override
    public ResourceServer resourceServer(ClientModel client) {
        return this.root.resourceServer(client);
    }

    @Override
    public boolean canMapCompositeRoles(ClientModel client) {
        ResourceServer server = this.resourceServer(client);
        if (server == null) {
            return false;
        }
        Resource resource = this.authz.getStoreFactory().getResourceStore().findByName(this.getResourceName(client), server.getId());
        if (resource == null) {
            return false;
        }
        Policy policy = this.authz.getStoreFactory().getPolicyStore().findByName(this.getMapRolesCompositePermissionName(client), server.getId());
        if (policy == null) {
            return false;
        }
        Set associatedPolicies = policy.getAssociatedPolicies();
        if (associatedPolicies == null || associatedPolicies.isEmpty()) {
            return false;
        }
        Scope scope = this.authz.getStoreFactory().getScopeStore().findByName("map-roles-composite", server.getId());
        return this.root.evaluatePermission(resource, scope, server);
    }

    @Override
    public boolean canMapClientScopeRoles(ClientModel client) {
        ResourceServer server = this.resourceServer(client);
        if (server == null) {
            return false;
        }
        Resource resource = this.authz.getStoreFactory().getResourceStore().findByName(this.getResourceName(client), server.getId());
        if (resource == null) {
            return false;
        }
        Policy policy = this.authz.getStoreFactory().getPolicyStore().findByName(this.getMapRolesClientScopePermissionName(client), server.getId());
        if (policy == null) {
            return false;
        }
        Set associatedPolicies = policy.getAssociatedPolicies();
        if (associatedPolicies == null || associatedPolicies.isEmpty()) {
            return false;
        }
        Scope scope = this.authz.getStoreFactory().getScopeStore().findByName("map-roles-client-scope", server.getId());
        return this.root.evaluatePermission(resource, scope, server);
    }

    @Override
    public Map<String, Boolean> getAccess(ClientModel client) {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        map.put("view", this.canView(client));
        map.put("manage", StorageId.isLocalStorage((ClientModel)client) && this.canManage(client));
        map.put("configure", StorageId.isLocalStorage((ClientModel)client) && this.canConfigure(client));
        return map;
    }
}

