/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.sessions.infinispan.InfinispanUserSessionProvider;
import org.keycloak.models.sessions.infinispan.entities.SessionEntity;
import org.keycloak.models.sessions.infinispan.entities.UserSessionEntity;

public class Consumers {
    private Consumers() {
    }

    public static UserSessionModelsConsumer userSessionModels(InfinispanUserSessionProvider provider, RealmModel realm, boolean offline) {
        return new UserSessionModelsConsumer(provider, realm, offline);
    }

    public static class UserSessionModelsConsumer
    implements Consumer<Map.Entry<String, SessionEntity>> {
        private InfinispanUserSessionProvider provider;
        private RealmModel realm;
        private boolean offline;
        private List<UserSessionModel> sessions = new LinkedList<UserSessionModel>();

        private UserSessionModelsConsumer(InfinispanUserSessionProvider provider, RealmModel realm, boolean offline) {
            this.provider = provider;
            this.realm = realm;
            this.offline = offline;
        }

        @Override
        public void accept(Map.Entry<String, SessionEntity> entry) {
            SessionEntity e = entry.getValue();
            this.sessions.add(this.provider.wrap(this.realm, (UserSessionEntity)e, this.offline));
        }

        public List<UserSessionModel> getSessions() {
            return this.sessions;
        }
    }
}

