/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo.compiled;

import java.util.stream.Stream;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.reteoo.AlphaNode;
import org.drools.core.reteoo.ModifyPreviousTuples;
import org.drools.core.reteoo.compiled.AbstractCompilerHandler;
import org.drools.core.rule.IndexableConstraint;
import org.drools.core.spi.InternalReadAccessor;
import org.drools.core.spi.PropagationContext;

public abstract class SwitchCompilerHandler
extends AbstractCompilerHandler {
    protected static final String MODIFY_PREVIOUS_TUPLE_NAME = ModifyPreviousTuples.class.getName();
    protected static final String MODIFY_PREVIOUS_TUPLE_PARAM_NAME = "modifyPreviousTuples";
    protected final StringBuilder builder;
    private Class fieldType;
    static final String LOCAL_FACT_VAR_NAME = "fact";
    protected static final String FACT_HANDLE_PARAM_TYPE = InternalFactHandle.class.getName();
    protected static final String PROP_CONTEXT_PARAM_TYPE = PropagationContext.class.getName();
    protected static final String WORKING_MEMORY_PARAM_TYPE = InternalWorkingMemory.class.getName();
    static final String FACT_HANDLE_PARAM_NAME = "handle";
    static final String PROP_CONTEXT_PARAM_NAME = "context";
    static final String WORKING_MEMORY_PARAM_NAME = "wm";
    static final String ASSERT_METHOD_SIGNATURE = "public final void assertObject(" + FACT_HANDLE_PARAM_TYPE + " " + "handle" + "," + PROP_CONTEXT_PARAM_TYPE + " " + "context" + "," + WORKING_MEMORY_PARAM_TYPE + " " + "wm" + "){";

    protected SwitchCompilerHandler(StringBuilder builder) {
        this.builder = builder;
    }

    protected void generateSwitch(IndexableConstraint indexableConstraint) {
        InternalReadAccessor fieldExtractor = indexableConstraint.getFieldExtractor();
        this.fieldType = fieldExtractor.getExtractToClass();
        if (this.canInlineValue()) {
            String switchVar = "switchVar";
            this.builder.append(this.fieldType.getCanonicalName()).append(" ").append(switchVar);
            this.builder.append(" = ").append("(" + this.fieldType.getCanonicalName() + ")").append("readAccessor.getValue(").append(LOCAL_FACT_VAR_NAME).append(");").append("\n");
            if (this.fieldType.isPrimitive()) {
                this.builder.append("if(true) {").append("\n");
            } else {
                this.builder.append("if(switchVar != null) {").append("\n");
            }
            this.builder.append("switch(").append(switchVar).append(")").append("{").append("\n");
        } else {
            String localVariableName = "NodeId";
            this.builder.append("Integer ").append(localVariableName);
            this.builder.append(" = (Integer)").append(this.getVariableName()).append(".get(").append("readAccessor.getValue(").append(LOCAL_FACT_VAR_NAME).append(")").append(");").append("\n");
            this.builder.append("if(").append(localVariableName).append(" != null) {").append("\n");
            this.builder.append("switch(").append(localVariableName).append(".intValue()) {").append("\n");
        }
    }

    protected void generateSwitchCase(AlphaNode hashedAlpha, Object hashedValue) {
        if (this.canInlineValue()) {
            Object quotedHashedValue = hashedValue instanceof String ? String.format("\"%s\"", hashedValue) : hashedValue;
            this.builder.append("case ").append(quotedHashedValue).append(" : ").append("\n");
        } else {
            this.builder.append("case ").append(hashedAlpha.getId()).append(" : ").append("\n");
        }
    }

    protected boolean canInlineValue() {
        return Stream.of(String.class, Integer.class, Integer.TYPE).anyMatch(c -> c.isAssignableFrom(this.fieldType));
    }

    @Override
    public void nullCaseAlphaNodeStart(AlphaNode hashedAlpha) {
        if (this.canInlineValue()) {
            this.builder.append("else { ");
        }
    }

    @Override
    public void nullCaseAlphaNodeEnd(AlphaNode hashedAlpha) {
        if (this.canInlineValue()) {
            this.builder.append("}").append("\n");
        }
    }
}

