/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models;

import java.util.Map;
import java.util.Set;
import org.keycloak.common.util.ObjectUtil;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.ProtocolMapperContainerModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.ScopeContainerModel;

public interface ClientModel
extends ClientScopeModel,
RoleContainerModel,
ProtocolMapperContainerModel,
ScopeContainerModel {
    public static final String PRIVATE_KEY = "privateKey";
    public static final String PUBLIC_KEY = "publicKey";
    public static final String X509CERTIFICATE = "X509Certificate";

    public void updateClient();

    @Override
    public String getId();

    public String getClientId();

    public void setClientId(String var1);

    @Override
    public String getName();

    @Override
    public void setName(String var1);

    @Override
    public String getDescription();

    @Override
    public void setDescription(String var1);

    public boolean isEnabled();

    public void setEnabled(boolean var1);

    public boolean isSurrogateAuthRequired();

    public void setSurrogateAuthRequired(boolean var1);

    public Set<String> getWebOrigins();

    public void setWebOrigins(Set<String> var1);

    public void addWebOrigin(String var1);

    public void removeWebOrigin(String var1);

    public Set<String> getRedirectUris();

    public void setRedirectUris(Set<String> var1);

    public void addRedirectUri(String var1);

    public void removeRedirectUri(String var1);

    public String getManagementUrl();

    public void setManagementUrl(String var1);

    public String getRootUrl();

    public void setRootUrl(String var1);

    public String getBaseUrl();

    public void setBaseUrl(String var1);

    public boolean isBearerOnly();

    public void setBearerOnly(boolean var1);

    public int getNodeReRegistrationTimeout();

    public void setNodeReRegistrationTimeout(int var1);

    public String getClientAuthenticatorType();

    public void setClientAuthenticatorType(String var1);

    public boolean validateSecret(String var1);

    public String getSecret();

    public void setSecret(String var1);

    public String getRegistrationToken();

    public void setRegistrationToken(String var1);

    @Override
    public String getProtocol();

    @Override
    public void setProtocol(String var1);

    @Override
    public void setAttribute(String var1, String var2);

    @Override
    public void removeAttribute(String var1);

    @Override
    public String getAttribute(String var1);

    @Override
    public Map<String, String> getAttributes();

    public String getAuthenticationFlowBindingOverride(String var1);

    public Map<String, String> getAuthenticationFlowBindingOverrides();

    public void removeAuthenticationFlowBindingOverride(String var1);

    public void setAuthenticationFlowBindingOverride(String var1, String var2);

    public boolean isFrontchannelLogout();

    public void setFrontchannelLogout(boolean var1);

    public boolean isFullScopeAllowed();

    public void setFullScopeAllowed(boolean var1);

    public boolean isPublicClient();

    public void setPublicClient(boolean var1);

    public boolean isConsentRequired();

    public void setConsentRequired(boolean var1);

    public boolean isStandardFlowEnabled();

    public void setStandardFlowEnabled(boolean var1);

    public boolean isImplicitFlowEnabled();

    public void setImplicitFlowEnabled(boolean var1);

    public boolean isDirectAccessGrantsEnabled();

    public void setDirectAccessGrantsEnabled(boolean var1);

    public boolean isServiceAccountsEnabled();

    public void setServiceAccountsEnabled(boolean var1);

    @Override
    public RealmModel getRealm();

    public void addClientScope(ClientScopeModel var1, boolean var2);

    public void removeClientScope(ClientScopeModel var1);

    public Map<String, ClientScopeModel> getClientScopes(boolean var1, boolean var2);

    public int getNotBefore();

    public void setNotBefore(int var1);

    public Map<String, Integer> getRegisteredNodes();

    public void registerNode(String var1, int var2);

    public void unregisterNode(String var1);

    @Override
    default public boolean isDisplayOnConsentScreen() {
        String displayVal = this.getAttribute("display.on.consent.screen");
        return displayVal == null ? false : Boolean.parseBoolean(displayVal);
    }

    @Override
    default public String getConsentScreenText() {
        String consentScreenText = ClientScopeModel.super.getConsentScreenText();
        if (ObjectUtil.isBlank((CharSequence)consentScreenText)) {
            consentScreenText = this.getClientId();
        }
        return consentScreenText;
    }
}

