/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.stream;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;
import java.util.function.Predicate;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.marshall.SerializeWith;
import org.keycloak.models.sessions.infinispan.changes.SessionEntityWrapper;
import org.keycloak.models.sessions.infinispan.entities.UserSessionEntity;
import org.keycloak.models.sessions.infinispan.util.KeycloakMarshallUtil;

@SerializeWith(value=ExternalizerImpl.class)
public class UserSessionPredicate
implements Predicate<Map.Entry<String, SessionEntityWrapper<UserSessionEntity>>> {
    private final String realm;
    private String user;
    private String client;
    private Integer expired;
    private Integer expiredRefresh;
    private String brokerSessionId;
    private String brokerUserId;

    private UserSessionPredicate(String realm) {
        this.realm = realm;
    }

    public static UserSessionPredicate create(String realm) {
        return new UserSessionPredicate(realm);
    }

    public UserSessionPredicate user(String user) {
        this.user = user;
        return this;
    }

    public UserSessionPredicate client(String clientUUID) {
        this.client = clientUUID;
        return this;
    }

    public UserSessionPredicate expired(Integer expired, Integer expiredRefresh) {
        this.expired = expired;
        this.expiredRefresh = expiredRefresh;
        return this;
    }

    public UserSessionPredicate brokerSessionId(String id) {
        this.brokerSessionId = id;
        return this;
    }

    public UserSessionPredicate brokerUserId(String id) {
        this.brokerUserId = id;
        return this;
    }

    @Override
    public boolean test(Map.Entry<String, SessionEntityWrapper<UserSessionEntity>> entry) {
        UserSessionEntity entity = entry.getValue().getEntity();
        if (!this.realm.equals(entity.getRealmId())) {
            return false;
        }
        if (this.user != null && !entity.getUser().equals(this.user)) {
            return false;
        }
        if (!(this.client == null || entity.getAuthenticatedClientSessions() != null && entity.getAuthenticatedClientSessions().containsKey(this.client))) {
            return false;
        }
        if (this.brokerSessionId != null && !this.brokerSessionId.equals(entity.getBrokerSessionId())) {
            return false;
        }
        if (this.brokerUserId != null && !this.brokerUserId.equals(entity.getBrokerUserId())) {
            return false;
        }
        if (this.expired != null && this.expiredRefresh != null && entity.getStarted() > this.expired && entity.getLastSessionRefresh() > this.expiredRefresh) {
            return false;
        }
        return this.expired != null || this.expiredRefresh == null || entity.getLastSessionRefresh() <= this.expiredRefresh;
    }

    public static class ExternalizerImpl
    implements Externalizer<UserSessionPredicate> {
        private static final int VERSION_1 = 1;

        public void writeObject(ObjectOutput output, UserSessionPredicate obj) throws IOException {
            output.writeByte(1);
            MarshallUtil.marshallString((String)obj.realm, (ObjectOutput)output);
            MarshallUtil.marshallString((String)obj.user, (ObjectOutput)output);
            MarshallUtil.marshallString((String)obj.client, (ObjectOutput)output);
            KeycloakMarshallUtil.marshall(obj.expired, output);
            KeycloakMarshallUtil.marshall(obj.expiredRefresh, output);
            MarshallUtil.marshallString((String)obj.brokerSessionId, (ObjectOutput)output);
            MarshallUtil.marshallString((String)obj.brokerUserId, (ObjectOutput)output);
        }

        public UserSessionPredicate readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            switch (input.readByte()) {
                case 1: {
                    return this.readObjectVersion1(input);
                }
            }
            throw new IOException("Unknown version");
        }

        public UserSessionPredicate readObjectVersion1(ObjectInput input) throws IOException, ClassNotFoundException {
            UserSessionPredicate res = new UserSessionPredicate(MarshallUtil.unmarshallString((ObjectInput)input));
            res.user(MarshallUtil.unmarshallString((ObjectInput)input));
            res.client(MarshallUtil.unmarshallString((ObjectInput)input));
            res.expired(KeycloakMarshallUtil.unmarshallInteger(input), KeycloakMarshallUtil.unmarshallInteger(input));
            res.brokerSessionId(MarshallUtil.unmarshallString((ObjectInput)input));
            res.brokerUserId(MarshallUtil.unmarshallString((ObjectInput)input));
            return res;
        }
    }
}

