/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.jose.jwk;

import com.fasterxml.jackson.core.type.TypeReference;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.Map;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.jce.spec.ECNamedCurveSpec;
import org.keycloak.common.util.Base64Url;
import org.keycloak.jose.jwk.JWK;
import org.keycloak.util.JsonSerialization;

public class JWKParser {
    private static TypeReference<Map<String, String>> typeRef = new TypeReference<Map<String, String>>(){};
    private JWK jwk;

    private JWKParser() {
    }

    public JWKParser(JWK jwk) {
        this.jwk = jwk;
    }

    public static JWKParser create() {
        return new JWKParser();
    }

    public static JWKParser create(JWK jwk) {
        return new JWKParser(jwk);
    }

    public JWKParser parse(String jwk) {
        try {
            this.jwk = JsonSerialization.mapper.readValue(jwk, JWK.class);
            return this;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public JWK getJwk() {
        return this.jwk;
    }

    public PublicKey toPublicKey() {
        String keyType = this.jwk.getKeyType();
        if (keyType.equals("RSA")) {
            return this.createRSAPublicKey();
        }
        if (keyType.equals("EC")) {
            return this.createECPublicKey();
        }
        throw new RuntimeException("Unsupported keyType " + keyType);
    }

    private PublicKey createECPublicKey() {
        String name;
        String crv = (String)this.jwk.getOtherClaims().get("crv");
        BigInteger x = new BigInteger(1, Base64Url.decode((String)this.jwk.getOtherClaims().get("x")));
        BigInteger y = new BigInteger(1, Base64Url.decode((String)this.jwk.getOtherClaims().get("y")));
        switch (crv) {
            case "P-256": {
                name = "secp256r1";
                break;
            }
            case "P-384": {
                name = "secp384r1";
                break;
            }
            case "P-521": {
                name = "secp521r1";
                break;
            }
            default: {
                throw new RuntimeException("Unsupported curve");
            }
        }
        try {
            ECNamedCurveParameterSpec spec = ECNamedCurveTable.getParameterSpec(name);
            ECNamedCurveSpec params = new ECNamedCurveSpec("prime256v1", spec.getCurve(), spec.getG(), spec.getN());
            ECPoint point = new ECPoint(x, y);
            ECPublicKeySpec pubKeySpec = new ECPublicKeySpec(point, params);
            KeyFactory kf = KeyFactory.getInstance("ECDSA");
            return kf.generatePublic(pubKeySpec);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private PublicKey createRSAPublicKey() {
        BigInteger modulus = new BigInteger(1, Base64Url.decode(this.jwk.getOtherClaims().get("n").toString()));
        BigInteger publicExponent = new BigInteger(1, Base64Url.decode(this.jwk.getOtherClaims().get("e").toString()));
        try {
            KeyFactory kf = KeyFactory.getInstance("RSA");
            return kf.generatePublic(new RSAPublicKeySpec(modulus, publicExponent));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isKeyTypeSupported(String keyType) {
        return "RSA".equals(keyType);
    }
}

