/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import twitter4j.EntityIndex;
import twitter4j.JSONArray;
import twitter4j.JSONException;
import twitter4j.JSONObject;
import twitter4j.TwitterException;
import twitter4j.URLEntity;

final class URLEntityJSONImpl
extends EntityIndex
implements URLEntity {
    private static final long serialVersionUID = 7333552738058031524L;
    private String url;
    private String expandedURL;
    private String displayURL;

    URLEntityJSONImpl(JSONObject json) throws TwitterException {
        this.init(json);
    }

    URLEntityJSONImpl(int start, int end, String url, String expandedURL, String displayURL) {
        this.setStart(start);
        this.setEnd(end);
        this.url = url;
        this.expandedURL = expandedURL;
        this.displayURL = displayURL;
    }

    URLEntityJSONImpl() {
    }

    private void init(JSONObject json) throws TwitterException {
        try {
            JSONArray indicesArray = json.getJSONArray("indices");
            this.setStart(indicesArray.getInt(0));
            this.setEnd(indicesArray.getInt(1));
            this.url = json.getString("url");
            this.expandedURL = !json.isNull("expanded_url") ? json.getString("expanded_url") : this.url;
            this.displayURL = !json.isNull("display_url") ? json.getString("display_url") : this.url;
        }
        catch (JSONException jsone) {
            throw new TwitterException(jsone);
        }
    }

    @Override
    public String getText() {
        return this.url;
    }

    @Override
    public String getURL() {
        return this.url;
    }

    @Override
    public String getExpandedURL() {
        return this.expandedURL;
    }

    @Override
    public String getDisplayURL() {
        return this.displayURL;
    }

    @Override
    public int getStart() {
        return super.getStart();
    }

    @Override
    public int getEnd() {
        return super.getEnd();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        URLEntityJSONImpl that = (URLEntityJSONImpl)o;
        if (this.displayURL != null ? !this.displayURL.equals(that.displayURL) : that.displayURL != null) {
            return false;
        }
        if (this.expandedURL != null ? !this.expandedURL.equals(that.expandedURL) : that.expandedURL != null) {
            return false;
        }
        return !(this.url != null ? !this.url.equals(that.url) : that.url != null);
    }

    public int hashCode() {
        int result = this.url != null ? this.url.hashCode() : 0;
        result = 31 * result + (this.expandedURL != null ? this.expandedURL.hashCode() : 0);
        result = 31 * result + (this.displayURL != null ? this.displayURL.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "URLEntityJSONImpl{url='" + this.url + '\'' + ", expandedURL='" + this.expandedURL + '\'' + ", displayURL='" + this.displayURL + '\'' + '}';
    }
}

