/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.endpoints.request;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.keycloak.jose.jws.Algorithm;
import org.keycloak.jose.jws.JWSHeader;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.protocol.oidc.OIDCAdvancedConfigWrapper;
import org.keycloak.protocol.oidc.endpoints.request.AuthzEndpointRequestParser;
import org.keycloak.util.JsonSerialization;

class AuthzEndpointRequestObjectParser
extends AuthzEndpointRequestParser {
    private final JsonNode requestParams;

    public AuthzEndpointRequestObjectParser(KeycloakSession session, String requestObject, ClientModel client) throws Exception {
        JWSInput input = new JWSInput(requestObject);
        JWSHeader header = input.getHeader();
        Algorithm headerAlgorithm = header.getAlgorithm();
        Algorithm requestedSignatureAlgorithm = OIDCAdvancedConfigWrapper.fromClientModel(client).getRequestObjectSignatureAlg();
        if (headerAlgorithm == null) {
            throw new RuntimeException("Request object signed algorithm not specified");
        }
        if (requestedSignatureAlgorithm != null && requestedSignatureAlgorithm != headerAlgorithm) {
            throw new RuntimeException("Request object signed with different algorithm than client requested algorithm");
        }
        if (header.getAlgorithm() == Algorithm.none) {
            this.requestParams = (JsonNode)JsonSerialization.readValue((byte[])input.getContent(), JsonNode.class);
        } else {
            this.requestParams = (JsonNode)session.tokens().decodeClientJWT(requestObject, client, JsonNode.class);
            if (this.requestParams == null) {
                throw new RuntimeException("Failed to verify signature on 'request' object");
            }
        }
    }

    @Override
    protected String getParameter(String paramName) {
        JsonNode val = this.requestParams.get(paramName);
        if (val == null) {
            return null;
        }
        if (val.isValueNode()) {
            return val.asText();
        }
        return val.toString();
    }

    @Override
    protected Integer getIntParameter(String paramName) {
        JsonNode val = this.requestParams.get(paramName);
        return val == null ? null : Integer.valueOf(Integer.parseInt(this.getParameter(paramName)));
    }

    @Override
    protected Set<String> keySet() {
        HashSet<String> keys = new HashSet<String>();
        this.requestParams.fieldNames().forEachRemaining(keys::add);
        return keys;
    }

    static class TypedHashMap
    extends HashMap<String, Object> {
        TypedHashMap() {
        }
    }
}

