/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.locale;

import java.util.Locale;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.UriInfo;
import org.keycloak.locale.LocaleNegotiator;
import org.keycloak.locale.LocaleSelection;
import org.keycloak.locale.LocaleSelectorProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakUriInfo;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.util.CookieHelper;

public class DefaultLocaleSelectorProvider
implements LocaleSelectorProvider {
    protected static final String LOCALE_COOKIE = "KEYCLOAK_LOCALE";
    protected static final String KC_LOCALE_PARAM = "kc_locale";
    protected final KeycloakSession session;

    public DefaultLocaleSelectorProvider(KeycloakSession session) {
        this.session = session;
    }

    public Locale resolveLocale(RealmModel realm, UserModel user) {
        HttpHeaders requestHeaders = this.session.getContext().getRequestHeaders();
        KeycloakUriInfo uri = this.session.getContext().getUri();
        return this.getLocale(realm, user, requestHeaders, (UriInfo)uri);
    }

    public void close() {
    }

    protected Locale getLocale(RealmModel realm, UserModel user, HttpHeaders requestHeaders, UriInfo uriInfo) {
        if (!realm.isInternationalizationEnabled()) {
            return Locale.ENGLISH;
        }
        Locale locale = this.getUserLocale(realm, user, requestHeaders, uriInfo);
        return locale != null ? locale : Locale.forLanguageTag(realm.getDefaultLocale());
    }

    protected Locale getUserLocale(RealmModel realm, UserModel user, HttpHeaders requestHeaders, UriInfo uriInfo) {
        LocaleSelection kcLocaleQueryParamSelection = this.getKcLocaleQueryParamSelection(realm, uriInfo);
        if (kcLocaleQueryParamSelection != null) {
            this.updateLocaleCookie(realm, kcLocaleQueryParamSelection.getLocaleString(), uriInfo);
            if (user != null) {
                this.updateUsersLocale(user, kcLocaleQueryParamSelection.getLocaleString());
            }
            return kcLocaleQueryParamSelection.getLocale();
        }
        LocaleSelection localeCookieSelection = this.getLocaleCookieSelection(realm, requestHeaders);
        if (localeCookieSelection != null) {
            if (user != null) {
                this.updateUsersLocale(user, localeCookieSelection.getLocaleString());
            }
            return localeCookieSelection.getLocale();
        }
        LocaleSelection userProfileSelection = this.getUserProfileSelection(realm, user);
        if (userProfileSelection != null) {
            this.updateLocaleCookie(realm, userProfileSelection.getLocaleString(), uriInfo);
            return userProfileSelection.getLocale();
        }
        LocaleSelection uiLocalesQueryParamSelection = this.getUiLocalesQueryParamSelection(realm, uriInfo);
        if (uiLocalesQueryParamSelection != null) {
            return uiLocalesQueryParamSelection.getLocale();
        }
        LocaleSelection acceptLanguageHeaderSelection = this.getAcceptLanguageHeaderLocale(realm, requestHeaders);
        if (acceptLanguageHeaderSelection != null) {
            return acceptLanguageHeaderSelection.getLocale();
        }
        return null;
    }

    protected LocaleSelection getKcLocaleQueryParamSelection(RealmModel realm, UriInfo uriInfo) {
        if (uriInfo == null || !uriInfo.getQueryParameters().containsKey((Object)KC_LOCALE_PARAM)) {
            return null;
        }
        String localeString = (String)uriInfo.getQueryParameters().getFirst((Object)KC_LOCALE_PARAM);
        return this.findLocale(realm, localeString);
    }

    protected LocaleSelection getLocaleCookieSelection(RealmModel realm, HttpHeaders httpHeaders) {
        if (httpHeaders == null || !httpHeaders.getCookies().containsKey(LOCALE_COOKIE)) {
            return null;
        }
        String localeString = ((Cookie)httpHeaders.getCookies().get(LOCALE_COOKIE)).getValue();
        return this.findLocale(realm, localeString);
    }

    protected LocaleSelection getUserProfileSelection(RealmModel realm, UserModel user) {
        if (user == null || !user.getAttributes().containsKey("locale")) {
            return null;
        }
        String localeString = user.getFirstAttribute("locale");
        return this.findLocale(realm, localeString);
    }

    protected LocaleSelection getUiLocalesQueryParamSelection(RealmModel realm, UriInfo uriInfo) {
        if (uriInfo == null || !uriInfo.getQueryParameters().containsKey((Object)"ui_locales")) {
            return null;
        }
        String localeString = (String)uriInfo.getQueryParameters().getFirst((Object)"ui_locales");
        return this.findLocale(realm, localeString.split(" "));
    }

    protected LocaleSelection getAcceptLanguageHeaderLocale(RealmModel realm, HttpHeaders httpHeaders) {
        if (httpHeaders == null || httpHeaders.getAcceptableLanguages() == null || httpHeaders.getAcceptableLanguages().isEmpty()) {
            return null;
        }
        for (Locale l : httpHeaders.getAcceptableLanguages()) {
            String localeString = l.toLanguageTag();
            LocaleSelection localeSelection = this.findLocale(realm, localeString);
            if (localeSelection == null) continue;
            return localeSelection;
        }
        return null;
    }

    protected void updateLocaleCookie(RealmModel realm, String locale, UriInfo uriInfo) {
        boolean secure = realm.getSslRequired().isRequired(uriInfo.getRequestUri().getHost());
        CookieHelper.addCookie(LOCALE_COOKIE, locale, AuthenticationManager.getRealmCookiePath(realm, uriInfo), null, null, -1, secure, true);
    }

    protected LocaleSelection findLocale(RealmModel realm, String ... localeStrings) {
        return new LocaleNegotiator(realm.getSupportedLocales()).invoke(localeStrings);
    }

    protected void updateUsersLocale(UserModel user, String locale) {
        if (!locale.equals(user.getFirstAttribute("locale"))) {
            user.setSingleAttribute("locale", locale);
        }
    }
}

