/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.store.syncronization;

import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.store.PolicyStore;
import org.keycloak.authorization.store.ResourceServerStore;
import org.keycloak.authorization.store.ResourceStore;
import org.keycloak.authorization.store.StoreFactory;
import org.keycloak.authorization.store.syncronization.Synchronizer;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.provider.ProviderFactory;
import org.keycloak.representations.idm.authorization.UserPolicyRepresentation;

public class UserSynchronizer
implements Synchronizer<UserModel.UserRemovedEvent> {
    @Override
    public void synchronize(UserModel.UserRemovedEvent event, KeycloakSessionFactory factory) {
        ProviderFactory providerFactory = factory.getProviderFactory(AuthorizationProvider.class);
        AuthorizationProvider authorizationProvider = (AuthorizationProvider)providerFactory.create(event.getKeycloakSession());
        this.removeUserResources(event, authorizationProvider);
        this.removeFromUserPolicies(event, authorizationProvider);
    }

    private void removeFromUserPolicies(UserModel.UserRemovedEvent event, AuthorizationProvider authorizationProvider) {
        StoreFactory storeFactory = authorizationProvider.getStoreFactory();
        PolicyStore policyStore = storeFactory.getPolicyStore();
        UserModel userModel = event.getUser();
        HashMap<String, String[]> attributes = new HashMap<String, String[]>();
        attributes.put("type", new String[]{"user"});
        attributes.put("config:users", new String[]{userModel.getId()});
        List<Policy> search = policyStore.findByResourceServer(attributes, null, -1, -1);
        for (Policy policy : search) {
            Object policyFactory = authorizationProvider.getProviderFactory(policy.getType());
            UserPolicyRepresentation representation = (UserPolicyRepresentation)UserPolicyRepresentation.class.cast(policyFactory.toRepresentation(policy, authorizationProvider));
            Set users = representation.getUsers();
            users.remove(userModel.getId());
            if (users.isEmpty()) {
                policyFactory.onRemove(policy, authorizationProvider);
                policyStore.delete(policy.getId());
                continue;
            }
            policyFactory.onUpdate(policy, (UserPolicyRepresentation)representation, authorizationProvider);
        }
    }

    private void removeUserResources(UserModel.UserRemovedEvent event, AuthorizationProvider authorizationProvider) {
        StoreFactory storeFactory = authorizationProvider.getStoreFactory();
        PolicyStore policyStore = storeFactory.getPolicyStore();
        ResourceStore resourceStore = storeFactory.getResourceStore();
        ResourceServerStore resourceServerStore = storeFactory.getResourceServerStore();
        RealmModel realm = event.getRealm();
        UserModel userModel = event.getUser();
        realm.getClients().forEach(clientModel -> {
            ResourceServer resourceServer = resourceServerStore.findById(clientModel.getId());
            if (resourceServer != null) {
                resourceStore.findByOwner(userModel.getId(), resourceServer.getId()).forEach(resource -> {
                    String resourceId = resource.getId();
                    policyStore.findByResource(resourceId, resourceServer.getId()).forEach(policy -> {
                        if (policy.getResources().size() == 1) {
                            policyStore.delete(policy.getId());
                        } else {
                            policy.removeResource((Resource)resource);
                        }
                    });
                    resourceStore.delete(resourceId);
                });
            }
        });
    }
}

