/*
 * Decompiled with CFR 0.152.
 */
package liquibase.datatype.core;

import liquibase.configuration.GlobalConfiguration;
import liquibase.configuration.LiquibaseConfiguration;
import liquibase.database.Database;
import liquibase.database.core.DB2Database;
import liquibase.database.core.HsqlDatabase;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.MySQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.database.core.PostgresDatabase;
import liquibase.database.core.SybaseDatabase;
import liquibase.datatype.DataTypeInfo;
import liquibase.datatype.DatabaseDataType;
import liquibase.datatype.core.DateTimeType;
import liquibase.util.StringUtils;

@DataTypeInfo(name="timestamp", aliases={"java.sql.Types.TIMESTAMP", "java.sql.Timestamp", "timestamptz"}, minParameters=0, maxParameters=1, priority=1)
public class TimestampType
extends DateTimeType {
    @Override
    public DatabaseDataType toDatabaseDataType(Database database) {
        String originalDefinition = StringUtils.trimToEmpty(this.getRawDefinition());
        if (database instanceof MySQLDatabase) {
            if (this.getRawDefinition().contains(" ") || this.getRawDefinition().contains("(")) {
                return new DatabaseDataType(this.getRawDefinition());
            }
            return super.toDatabaseDataType(database);
        }
        if (database instanceof MSSQLDatabase) {
            if (!LiquibaseConfiguration.getInstance().getProperty(GlobalConfiguration.class, "convertDataTypes").getValue(Boolean.class).booleanValue() && originalDefinition.toLowerCase().startsWith("timestamp")) {
                return new DatabaseDataType(database.escapeDataTypeName("timestamp"));
            }
            return new DatabaseDataType(database.escapeDataTypeName("datetime"));
        }
        if (database instanceof SybaseDatabase) {
            return new DatabaseDataType(database.escapeDataTypeName("datetime"));
        }
        if (database instanceof DB2Database) {
            Object[] parameters = this.getParameters();
            if (parameters != null && parameters.length > 1) {
                parameters = new Object[]{parameters[1]};
            }
            return new DatabaseDataType(database.escapeDataTypeName("timestamp"), parameters);
        }
        if (this.getAdditionalInformation() != null && (database instanceof PostgresDatabase || database instanceof OracleDatabase) || database instanceof HsqlDatabase) {
            DatabaseDataType type = new DatabaseDataType("TIMESTAMP");
            String additionalInformation = this.getAdditionalInformation();
            if (additionalInformation != null && database instanceof PostgresDatabase && additionalInformation.toUpperCase().contains("TIMEZONE")) {
                additionalInformation = additionalInformation.toUpperCase().replace("TIMEZONE", "TIME ZONE");
            }
            type.addAdditionalInformation(additionalInformation);
            return type;
        }
        return super.toDatabaseDataType(database);
    }
}

