/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.ldap.mappers.membership.role;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jboss.logging.Logger;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ModelException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.RoleUtils;
import org.keycloak.models.utils.UserModelDelegate;
import org.keycloak.storage.ldap.LDAPConfig;
import org.keycloak.storage.ldap.LDAPStorageProvider;
import org.keycloak.storage.ldap.LDAPUtils;
import org.keycloak.storage.ldap.idm.model.LDAPObject;
import org.keycloak.storage.ldap.idm.query.Condition;
import org.keycloak.storage.ldap.idm.query.internal.LDAPQuery;
import org.keycloak.storage.ldap.idm.query.internal.LDAPQueryConditionsBuilder;
import org.keycloak.storage.ldap.mappers.AbstractLDAPStorageMapper;
import org.keycloak.storage.ldap.mappers.membership.CommonLDAPGroupMapper;
import org.keycloak.storage.ldap.mappers.membership.CommonLDAPGroupMapperConfig;
import org.keycloak.storage.ldap.mappers.membership.LDAPGroupMapperMode;
import org.keycloak.storage.ldap.mappers.membership.UserRolesRetrieveStrategy;
import org.keycloak.storage.ldap.mappers.membership.role.RoleLDAPStorageMapperFactory;
import org.keycloak.storage.ldap.mappers.membership.role.RoleMapperConfig;
import org.keycloak.storage.user.SynchronizationResult;

public class RoleLDAPStorageMapper
extends AbstractLDAPStorageMapper
implements CommonLDAPGroupMapper {
    private static final Logger logger = Logger.getLogger(RoleLDAPStorageMapper.class);
    private final RoleMapperConfig config;
    private final RoleLDAPStorageMapperFactory factory;

    public RoleLDAPStorageMapper(ComponentModel mapperModel, LDAPStorageProvider ldapProvider, RoleLDAPStorageMapperFactory factory) {
        super(mapperModel, ldapProvider);
        this.config = new RoleMapperConfig(mapperModel);
        this.factory = factory;
    }

    @Override
    public LDAPQuery createLDAPGroupQuery() {
        return this.createRoleQuery(false);
    }

    @Override
    public CommonLDAPGroupMapperConfig getConfig() {
        return this.config;
    }

    @Override
    public void onImportUserFromLDAP(LDAPObject ldapUser, UserModel user, RealmModel realm, boolean isCreate) {
        LDAPGroupMapperMode mode = this.config.getMode();
        if (mode == LDAPGroupMapperMode.IMPORT && isCreate) {
            List<LDAPObject> ldapRoles = this.getLDAPRoleMappings(ldapUser);
            String roleNameAttr = this.config.getRoleNameLdapAttribute();
            for (LDAPObject ldapRole : ldapRoles) {
                String roleName = ldapRole.getAttributeAsString(roleNameAttr);
                RoleContainerModel roleContainer = this.getTargetRoleContainer(realm);
                RoleModel role = roleContainer.getRole(roleName);
                if (role == null) {
                    role = roleContainer.addRole(roleName);
                }
                logger.debugf("Granting role [%s] to user [%s] during import from LDAP", (Object)roleName, (Object)user.getUsername());
                user.grantRole(role);
            }
        }
    }

    @Override
    public void onRegisterUserToLDAP(LDAPObject ldapUser, UserModel localUser, RealmModel realm) {
    }

    @Override
    public SynchronizationResult syncDataFromFederationProviderToKeycloak(RealmModel realm) {
        SynchronizationResult syncResult = new SynchronizationResult(){

            public String getStatus() {
                return String.format("%d imported roles, %d roles already exists in Keycloak", this.getAdded(), this.getUpdated());
            }
        };
        logger.debugf("Syncing roles from LDAP into Keycloak DB. Mapper is [%s], LDAP provider is [%s]", (Object)this.mapperModel.getName(), (Object)this.ldapProvider.getModel().getName());
        try (LDAPQuery ldapRoleQuery = this.createRoleQuery(false);){
            List<LDAPObject> ldapRoles = LDAPUtils.loadAllLDAPObjects(ldapRoleQuery, this.ldapProvider);
            RoleContainerModel roleContainer = this.getTargetRoleContainer(realm);
            String rolesRdnAttr = this.config.getRoleNameLdapAttribute();
            for (LDAPObject ldapRole : ldapRoles) {
                String roleName = ldapRole.getAttributeAsString(rolesRdnAttr);
                if (roleContainer.getRole(roleName) == null) {
                    logger.debugf("Syncing role [%s] from LDAP to keycloak DB", (Object)roleName);
                    roleContainer.addRole(roleName);
                    syncResult.increaseAdded();
                    continue;
                }
                syncResult.increaseUpdated();
            }
            Iterator<LDAPObject> iterator = syncResult;
            return iterator;
        }
    }

    @Override
    public SynchronizationResult syncDataFromKeycloakToFederationProvider(RealmModel realm) {
        SynchronizationResult syncResult = new SynchronizationResult(){

            public String getStatus() {
                return String.format("%d roles imported to LDAP, %d roles already existed in LDAP", this.getAdded(), this.getUpdated());
            }
        };
        if (this.config.getMode() != LDAPGroupMapperMode.LDAP_ONLY) {
            logger.warnf("Ignored sync for federation mapper '%s' as it's mode is '%s'", (Object)this.mapperModel.getName(), (Object)this.config.getMode().toString());
            return syncResult;
        }
        logger.debugf("Syncing roles from Keycloak into LDAP. Mapper is [%s], LDAP provider is [%s]", (Object)this.mapperModel.getName(), (Object)this.ldapProvider.getModel().getName());
        try (LDAPQuery ldapQuery = this.createRoleQuery(false);){
            List<LDAPObject> ldapRoles = LDAPUtils.loadAllLDAPObjects(ldapQuery, this.ldapProvider);
            HashSet<String> ldapRoleNames = new HashSet<String>();
            String rolesRdnAttr = this.config.getRoleNameLdapAttribute();
            for (LDAPObject ldapRole : ldapRoles) {
                String roleName = ldapRole.getAttributeAsString(rolesRdnAttr);
                ldapRoleNames.add(roleName);
            }
            RoleContainerModel roleContainer = this.getTargetRoleContainer(realm);
            Set keycloakRoles = roleContainer.getRoles();
            for (RoleModel keycloakRole : keycloakRoles) {
                String roleName = keycloakRole.getName();
                if (ldapRoleNames.contains(roleName)) {
                    syncResult.increaseUpdated();
                    continue;
                }
                logger.debugf("Syncing role [%s] from Keycloak to LDAP", (Object)roleName);
                this.createLDAPRole(roleName);
                syncResult.increaseAdded();
            }
            Iterator iterator = syncResult;
            return iterator;
        }
    }

    public LDAPQuery createRoleQuery(boolean includeMemberAttribute) {
        LDAPQuery ldapQuery = new LDAPQuery(this.ldapProvider);
        ldapQuery.setSearchScope(this.ldapProvider.getLdapIdentityStore().getConfig().getSearchScope());
        String rolesDn = this.config.getRolesDn();
        ldapQuery.setSearchDn(rolesDn);
        Collection<String> roleObjectClasses = this.config.getRoleObjectClasses(this.ldapProvider);
        ldapQuery.addObjectClasses(roleObjectClasses);
        String rolesRdnAttr = this.config.getRoleNameLdapAttribute();
        String customFilter = this.config.getCustomLdapFilter();
        if (customFilter != null && customFilter.trim().length() > 0) {
            Condition customFilterCondition = new LDAPQueryConditionsBuilder().addCustomLDAPFilter(customFilter);
            ldapQuery.addWhereCondition(customFilterCondition);
        }
        ldapQuery.addReturningLdapAttribute(rolesRdnAttr);
        if (includeMemberAttribute) {
            String membershipAttr = this.config.getMembershipLdapAttribute();
            ldapQuery.addReturningLdapAttribute(membershipAttr);
        }
        return ldapQuery;
    }

    protected RoleContainerModel getTargetRoleContainer(RealmModel realm) {
        boolean realmRolesMapping = this.config.isRealmRolesMapping();
        if (realmRolesMapping) {
            return realm;
        }
        String clientId = this.config.getClientId();
        if (clientId == null) {
            throw new ModelException("Using client roles mapping is requested, but parameter client.id not found!");
        }
        ClientModel client = realm.getClientByClientId(clientId);
        if (client == null) {
            throw new ModelException("Can't found requested client with clientId: " + clientId);
        }
        return client;
    }

    public LDAPObject createLDAPRole(String roleName) {
        LDAPObject ldapRole = LDAPUtils.createLDAPGroup(this.ldapProvider, roleName, this.config.getRoleNameLdapAttribute(), this.config.getRoleObjectClasses(this.ldapProvider), this.config.getRolesDn(), Collections.emptyMap(), this.config.getMembershipLdapAttribute());
        logger.debugf("Creating role [%s] to LDAP with DN [%s]", (Object)roleName, (Object)ldapRole.getDn().toString());
        return ldapRole;
    }

    public void addRoleMappingInLDAP(String roleName, LDAPObject ldapUser) {
        LDAPObject ldapRole = this.loadLDAPRoleByName(roleName);
        if (ldapRole == null) {
            ldapRole = this.createLDAPRole(roleName);
        }
        String membershipUserAttrName = this.getMembershipUserLdapAttribute();
        LDAPUtils.addMember(this.ldapProvider, this.config.getMembershipTypeLdapAttribute(), this.config.getMembershipLdapAttribute(), membershipUserAttrName, ldapRole, ldapUser, true);
    }

    public void deleteRoleMappingInLDAP(LDAPObject ldapUser, LDAPObject ldapRole) {
        String membershipUserAttrName = this.getMembershipUserLdapAttribute();
        LDAPUtils.deleteMember(this.ldapProvider, this.config.getMembershipTypeLdapAttribute(), this.config.getMembershipLdapAttribute(), membershipUserAttrName, ldapRole, ldapUser);
    }

    public LDAPObject loadLDAPRoleByName(String roleName) {
        LDAPQuery ldapQuery = this.createRoleQuery(true);
        Condition roleNameCondition = new LDAPQueryConditionsBuilder().equal(this.config.getRoleNameLdapAttribute(), roleName);
        ldapQuery.addWhereCondition(roleNameCondition);
        return ldapQuery.getFirstResult();
    }

    protected List<LDAPObject> getLDAPRoleMappings(LDAPObject ldapUser) {
        String strategyKey = this.config.getUserRolesRetrieveStrategy();
        UserRolesRetrieveStrategy strategy = this.factory.getUserRolesRetrieveStrategy(strategyKey);
        LDAPConfig ldapConfig = this.ldapProvider.getLdapIdentityStore().getConfig();
        return strategy.getLDAPRoleMappings(this, ldapUser, ldapConfig);
    }

    @Override
    public UserModel proxy(LDAPObject ldapUser, UserModel delegate, RealmModel realm) {
        LDAPGroupMapperMode mode = this.config.getMode();
        if (mode == LDAPGroupMapperMode.IMPORT) {
            return delegate;
        }
        return new LDAPRoleMappingsUserDelegate(realm, delegate, ldapUser);
    }

    @Override
    public void beforeLDAPQuery(LDAPQuery query) {
        String strategyKey = this.config.getUserRolesRetrieveStrategy();
        UserRolesRetrieveStrategy strategy = this.factory.getUserRolesRetrieveStrategy(strategyKey);
        strategy.beforeUserLDAPQuery(this, query);
    }

    protected String getMembershipUserLdapAttribute() {
        LDAPConfig ldapConfig = this.ldapProvider.getLdapIdentityStore().getConfig();
        return this.config.getMembershipUserLdapAttribute(ldapConfig);
    }

    public class LDAPRoleMappingsUserDelegate
    extends UserModelDelegate {
        private final RealmModel realm;
        private final LDAPObject ldapUser;
        private final RoleContainerModel roleContainer;
        private Set<RoleModel> cachedLDAPRoleMappings;

        public LDAPRoleMappingsUserDelegate(RealmModel realm, UserModel user, LDAPObject ldapUser) {
            super(user);
            this.realm = realm;
            this.ldapUser = ldapUser;
            this.roleContainer = RoleLDAPStorageMapper.this.getTargetRoleContainer(realm);
        }

        public Set<RoleModel> getRealmRoleMappings() {
            if (this.roleContainer.equals(this.realm)) {
                Set<RoleModel> ldapRoleMappings = this.getLDAPRoleMappingsConverted();
                if (RoleLDAPStorageMapper.this.config.getMode() == LDAPGroupMapperMode.LDAP_ONLY) {
                    return ldapRoleMappings;
                }
                Set modelRoleMappings = super.getRealmRoleMappings();
                ldapRoleMappings.addAll(modelRoleMappings);
                return ldapRoleMappings;
            }
            return super.getRealmRoleMappings();
        }

        public Set<RoleModel> getClientRoleMappings(ClientModel client) {
            if (this.roleContainer.equals(client)) {
                Set<RoleModel> ldapRoleMappings = this.getLDAPRoleMappingsConverted();
                if (RoleLDAPStorageMapper.this.config.getMode() == LDAPGroupMapperMode.LDAP_ONLY) {
                    return ldapRoleMappings;
                }
                Set modelRoleMappings = super.getClientRoleMappings(client);
                ldapRoleMappings.addAll(modelRoleMappings);
                return ldapRoleMappings;
            }
            return super.getClientRoleMappings(client);
        }

        public boolean hasRole(RoleModel role) {
            Set<RoleModel> roles = this.getRoleMappings();
            return RoleUtils.hasRole(roles, (RoleModel)role) || RoleUtils.hasRoleFromGroup((Iterable)this.getGroups(), (RoleModel)role, (boolean)true);
        }

        public void grantRole(RoleModel role) {
            if (RoleLDAPStorageMapper.this.config.getMode() == LDAPGroupMapperMode.LDAP_ONLY) {
                if (role.getContainer().equals(this.roleContainer)) {
                    this.cachedLDAPRoleMappings = null;
                    RoleLDAPStorageMapper.this.addRoleMappingInLDAP(role.getName(), this.ldapUser);
                } else {
                    super.grantRole(role);
                }
            } else {
                super.grantRole(role);
            }
        }

        public Set<RoleModel> getRoleMappings() {
            Set modelRoleMappings = super.getRoleMappings();
            Set<RoleModel> ldapRoleMappings = this.getLDAPRoleMappingsConverted();
            if (RoleLDAPStorageMapper.this.config.getMode() == LDAPGroupMapperMode.LDAP_ONLY) {
                HashSet modelRolesCopy = new HashSet(modelRoleMappings);
                for (RoleModel role : modelRolesCopy) {
                    if (!role.getContainer().equals(this.roleContainer)) continue;
                    modelRoleMappings.remove(role);
                }
            }
            modelRoleMappings.addAll(ldapRoleMappings);
            return modelRoleMappings;
        }

        protected Set<RoleModel> getLDAPRoleMappingsConverted() {
            if (this.cachedLDAPRoleMappings != null) {
                return new HashSet<RoleModel>(this.cachedLDAPRoleMappings);
            }
            List<LDAPObject> ldapRoles = RoleLDAPStorageMapper.this.getLDAPRoleMappings(this.ldapUser);
            HashSet<RoleModel> roles = new HashSet<RoleModel>();
            String roleNameLdapAttr = RoleLDAPStorageMapper.this.config.getRoleNameLdapAttribute();
            for (LDAPObject role : ldapRoles) {
                String roleName = role.getAttributeAsString(roleNameLdapAttr);
                RoleModel modelRole = this.roleContainer.getRole(roleName);
                if (modelRole == null) {
                    modelRole = this.roleContainer.addRole(roleName);
                }
                roles.add(modelRole);
            }
            this.cachedLDAPRoleMappings = new HashSet<RoleModel>(roles);
            return roles;
        }

        public void deleteRoleMapping(RoleModel role) {
            if (role.getContainer().equals(this.roleContainer)) {
                LDAPQuery ldapQuery = RoleLDAPStorageMapper.this.createRoleQuery(true);
                LDAPQueryConditionsBuilder conditionsBuilder = new LDAPQueryConditionsBuilder();
                Condition roleNameCondition = conditionsBuilder.equal(RoleLDAPStorageMapper.this.config.getRoleNameLdapAttribute(), role.getName());
                String membershipUserAttrName = RoleLDAPStorageMapper.this.getMembershipUserLdapAttribute();
                String membershipUserAttr = LDAPUtils.getMemberValueOfChildObject(this.ldapUser, RoleLDAPStorageMapper.this.config.getMembershipTypeLdapAttribute(), membershipUserAttrName);
                Condition membershipCondition = conditionsBuilder.equal(RoleLDAPStorageMapper.this.config.getMembershipLdapAttribute(), membershipUserAttr);
                ldapQuery.addWhereCondition(roleNameCondition).addWhereCondition(membershipCondition);
                LDAPObject ldapRole = ldapQuery.getFirstResult();
                if (ldapRole == null) {
                    if (RoleLDAPStorageMapper.this.config.getMode() == LDAPGroupMapperMode.READ_ONLY) {
                        super.deleteRoleMapping(role);
                    }
                } else {
                    if (RoleLDAPStorageMapper.this.config.getMode() == LDAPGroupMapperMode.READ_ONLY) {
                        throw new ModelException("Not possible to delete LDAP role mappings as mapper mode is READ_ONLY");
                    }
                    this.cachedLDAPRoleMappings = null;
                    RoleLDAPStorageMapper.this.deleteRoleMappingInLDAP(this.ldapUser, ldapRole);
                }
            } else {
                super.deleteRoleMapping(role);
            }
        }
    }
}

