/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models;

import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakTransaction;

public abstract class AbstractKeycloakTransaction
implements KeycloakTransaction {
    public static final Logger logger = Logger.getLogger(AbstractKeycloakTransaction.class);
    protected TransactionState state = TransactionState.NOT_STARTED;

    @Override
    public void begin() {
        if (this.state != TransactionState.NOT_STARTED) {
            throw new IllegalStateException("Transaction already started");
        }
        this.state = TransactionState.STARTED;
    }

    @Override
    public void commit() {
        if (this.state != TransactionState.STARTED) {
            throw new IllegalStateException("Transaction in illegal state for commit: " + (Object)((Object)this.state));
        }
        this.commitImpl();
        this.state = TransactionState.FINISHED;
    }

    @Override
    public void rollback() {
        if (this.state != TransactionState.STARTED && this.state != TransactionState.ROLLBACK_ONLY) {
            throw new IllegalStateException("Transaction in illegal state for rollback: " + (Object)((Object)this.state));
        }
        this.rollbackImpl();
        this.state = TransactionState.FINISHED;
    }

    @Override
    public void setRollbackOnly() {
        this.state = TransactionState.ROLLBACK_ONLY;
    }

    @Override
    public boolean getRollbackOnly() {
        return this.state == TransactionState.ROLLBACK_ONLY;
    }

    @Override
    public boolean isActive() {
        return this.state == TransactionState.STARTED || this.state == TransactionState.ROLLBACK_ONLY;
    }

    public TransactionState getState() {
        return this.state;
    }

    protected abstract void commitImpl();

    protected abstract void rollbackImpl();

    public static enum TransactionState {
        NOT_STARTED,
        STARTED,
        ROLLBACK_ONLY,
        FINISHED;

    }
}

