/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.forms.login.freemarker.model;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.OrderedModel;

public class OAuthGrantBean {
    private static OrderedModel.OrderedModelComparator<ClientScopeEntry> COMPARATOR_INSTANCE = new OrderedModel.OrderedModelComparator();
    private List<ClientScopeEntry> clientScopesRequested = new ArrayList<ClientScopeEntry>();
    private String code;
    private ClientModel client;

    public OAuthGrantBean(String code, ClientModel client, List<ClientScopeModel> clientScopesRequested) {
        this.code = code;
        this.client = client;
        for (ClientScopeModel clientScope : clientScopesRequested) {
            this.clientScopesRequested.add(new ClientScopeEntry(clientScope.getConsentScreenText(), clientScope.getGuiOrder()));
        }
        this.clientScopesRequested.sort((Comparator<ClientScopeEntry>)COMPARATOR_INSTANCE);
    }

    public String getCode() {
        return this.code;
    }

    public String getClient() {
        return this.client.getClientId();
    }

    public List<ClientScopeEntry> getClientScopesRequested() {
        return this.clientScopesRequested;
    }

    public static class ClientScopeEntry
    implements OrderedModel {
        private final String consentScreenText;
        private final String guiOrder;

        private ClientScopeEntry(String consentScreenText, String guiOrder) {
            this.consentScreenText = consentScreenText;
            this.guiOrder = guiOrder;
        }

        public String getConsentScreenText() {
            return this.consentScreenText;
        }

        public String getGuiOrder() {
            return this.guiOrder;
        }
    }
}

