/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class OAuth2Code {
    private static final String ID_NOTE = "id";
    private static final String EXPIRATION_NOTE = "exp";
    private static final String NONCE_NOTE = "nonce";
    private static final String SCOPE_NOTE = "scope";
    private static final String REDIRECT_URI_PARAM_NOTE = "redirectUri";
    private static final String CODE_CHALLENGE_NOTE = "code_challenge";
    private static final String CODE_CHALLENGE_METHOD_NOTE = "code_challenge_method";
    private final UUID id;
    private final int expiration;
    private final String nonce;
    private final String scope;
    private final String redirectUriParam;
    private final String codeChallenge;
    private final String codeChallengeMethod;

    public OAuth2Code(UUID id, int expiration, String nonce, String scope, String redirectUriParam, String codeChallenge, String codeChallengeMethod) {
        this.id = id;
        this.expiration = expiration;
        this.nonce = nonce;
        this.scope = scope;
        this.redirectUriParam = redirectUriParam;
        this.codeChallenge = codeChallenge;
        this.codeChallengeMethod = codeChallengeMethod;
    }

    private OAuth2Code(Map<String, String> data) {
        this.id = UUID.fromString(data.get(ID_NOTE));
        this.expiration = Integer.parseInt(data.get(EXPIRATION_NOTE));
        this.nonce = data.get(NONCE_NOTE);
        this.scope = data.get(SCOPE_NOTE);
        this.redirectUriParam = data.get(REDIRECT_URI_PARAM_NOTE);
        this.codeChallenge = data.get(CODE_CHALLENGE_NOTE);
        this.codeChallengeMethod = data.get(CODE_CHALLENGE_METHOD_NOTE);
    }

    public static final OAuth2Code deserializeCode(Map<String, String> data) {
        return new OAuth2Code(data);
    }

    public Map<String, String> serializeCode() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put(ID_NOTE, this.id.toString());
        result.put(EXPIRATION_NOTE, String.valueOf(this.expiration));
        result.put(NONCE_NOTE, this.nonce);
        result.put(SCOPE_NOTE, this.scope);
        result.put(REDIRECT_URI_PARAM_NOTE, this.redirectUriParam);
        result.put(CODE_CHALLENGE_NOTE, this.codeChallenge);
        result.put(CODE_CHALLENGE_METHOD_NOTE, this.codeChallengeMethod);
        return result;
    }

    public UUID getId() {
        return this.id;
    }

    public int getExpiration() {
        return this.expiration;
    }

    public String getNonce() {
        return this.nonce;
    }

    public String getScope() {
        return this.scope;
    }

    public String getRedirectUriParam() {
        return this.redirectUriParam;
    }

    public String getCodeChallenge() {
        return this.codeChallenge;
    }

    public String getCodeChallengeMethod() {
        return this.codeChallengeMethod;
    }
}

