/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan.events;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.marshall.SerializeWith;
import org.keycloak.models.cache.infinispan.UserCacheManager;
import org.keycloak.models.cache.infinispan.events.InvalidationEvent;
import org.keycloak.models.cache.infinispan.events.UserCacheInvalidationEvent;

@SerializeWith(value=ExternalizerImpl.class)
public class UserConsentsUpdatedEvent
extends InvalidationEvent
implements UserCacheInvalidationEvent {
    private String userId;

    public static UserConsentsUpdatedEvent create(String userId) {
        UserConsentsUpdatedEvent event = new UserConsentsUpdatedEvent();
        event.userId = userId;
        return event;
    }

    @Override
    public String getId() {
        return this.userId;
    }

    public String toString() {
        return String.format("UserConsentsUpdatedEvent [ userId=%s ]", this.userId);
    }

    @Override
    public void addInvalidations(UserCacheManager userCache, Set<String> invalidations) {
        userCache.consentInvalidation(this.userId, invalidations);
    }

    public static class ExternalizerImpl
    implements Externalizer<UserConsentsUpdatedEvent> {
        private static final int VERSION_1 = 1;

        public void writeObject(ObjectOutput output, UserConsentsUpdatedEvent obj) throws IOException {
            output.writeByte(1);
            MarshallUtil.marshallString((String)obj.userId, (ObjectOutput)output);
        }

        public UserConsentsUpdatedEvent readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            switch (input.readByte()) {
                case 1: {
                    return this.readObjectVersion1(input);
                }
            }
            throw new IOException("Unknown version");
        }

        public UserConsentsUpdatedEvent readObjectVersion1(ObjectInput input) throws IOException, ClassNotFoundException {
            UserConsentsUpdatedEvent res = new UserConsentsUpdatedEvent();
            res.userId = MarshallUtil.unmarshallString((ObjectInput)input);
            return res;
        }
    }
}

