/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan;

import java.util.function.Supplier;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.commons.api.BasicCache;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.connections.infinispan.InfinispanConnectionProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.SingleUseTokenStoreProviderFactory;
import org.keycloak.models.sessions.infinispan.InfinispanSingleUseTokenStoreProvider;
import org.keycloak.models.sessions.infinispan.entities.ActionTokenValueEntity;
import org.keycloak.models.sessions.infinispan.util.InfinispanUtil;

public class InfinispanSingleUseTokenStoreProviderFactory
implements SingleUseTokenStoreProviderFactory {
    private static final Logger LOG = Logger.getLogger(InfinispanSingleUseTokenStoreProviderFactory.class);
    private volatile Supplier<BasicCache<String, ActionTokenValueEntity>> tokenCache;

    public InfinispanSingleUseTokenStoreProvider create(KeycloakSession session) {
        this.lazyInit(session);
        return new InfinispanSingleUseTokenStoreProvider(session, this.tokenCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lazyInit(KeycloakSession session) {
        if (this.tokenCache == null) {
            InfinispanSingleUseTokenStoreProviderFactory infinispanSingleUseTokenStoreProviderFactory = this;
            synchronized (infinispanSingleUseTokenStoreProviderFactory) {
                if (this.tokenCache == null) {
                    InfinispanConnectionProvider connections = (InfinispanConnectionProvider)session.getProvider(InfinispanConnectionProvider.class);
                    Cache cache = connections.getCache("actionTokens");
                    RemoteCache remoteCache = InfinispanUtil.getRemoteCache(cache);
                    if (remoteCache != null) {
                        LOG.debugf("Having remote stores. Using remote cache '%s' for single-use cache of token", (Object)remoteCache.getName());
                        this.tokenCache = () -> remoteCache.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE});
                    } else {
                        LOG.debugf("Not having remote stores. Using normal cache '%s' for single-use cache of token", (Object)cache.getName());
                        this.tokenCache = () -> cache;
                    }
                }
            }
        }
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return "infinispan";
    }
}

