/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.initializer;

import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.dblock.DBLockManager;
import org.keycloak.models.dblock.DBLockProvider;
import org.keycloak.models.sessions.infinispan.initializer.CacheInitializer;

public class DBLockBasedCacheInitializer
extends CacheInitializer {
    private static final Logger log = Logger.getLogger(DBLockBasedCacheInitializer.class);
    private final KeycloakSession session;
    private final CacheInitializer delegate;

    public DBLockBasedCacheInitializer(KeycloakSession session, CacheInitializer delegate) {
        this.session = session;
        this.delegate = delegate;
    }

    @Override
    public void initCache() {
        this.delegate.initCache();
    }

    @Override
    protected boolean isFinished() {
        return this.delegate.isFinished();
    }

    @Override
    protected boolean isCoordinator() {
        return this.delegate.isCoordinator();
    }

    @Override
    protected void startLoading() {
        DBLockManager dbLockManager = new DBLockManager(this.session);
        dbLockManager.checkForcedUnlock();
        DBLockProvider dbLock = dbLockManager.getDBLock();
        dbLock.waitForLock();
        try {
            if (this.isFinished()) {
                log.infof("Task already finished when DBLock retrieved", new Object[0]);
            } else {
                this.delegate.startLoading();
            }
        }
        finally {
            dbLock.releaseLock();
        }
    }
}

