/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.subsystem.server.extension;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.keycloak.subsystem.server.extension.JsonConfigConverter;
import org.keycloak.subsystem.server.extension.KeycloakExtension;

public class MigrateJsonOperation
implements OperationStepHandler {
    public static final String OPERATION_NAME = "migrate-json";
    private static final String CONFIG_DIR = System.getProperty("jboss.server.config.dir");
    private static final Path DEFAULT_CONFIG_FILE = Paths.get(CONFIG_DIR, "keycloak-server.json");
    private static final AttributeDefinition FILE_ATTRIBUTE = SimpleAttributeDefinitionBuilder.create((String)"file", (ModelType)ModelType.BYTES, (boolean)true).build();
    public static final OperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("migrate-json", (ResourceDescriptionResolver)KeycloakExtension.getResourceDescriptionResolver(new String[0])).setRuntimeOnly().setReadOnly().setReplyType(ModelType.STRING).setParameters(new AttributeDefinition[]{FILE_ATTRIBUTE}).build();

    private String localConfig() throws IOException {
        if (Files.notExists(DEFAULT_CONFIG_FILE, new LinkOption[0])) {
            return null;
        }
        return new String(Files.readAllBytes(DEFAULT_CONFIG_FILE));
    }

    private String readConfig(ModelNode operation) throws IOException {
        ModelNode file = operation.get(FILE_ATTRIBUTE.getName());
        if (file.isDefined() && file.asBytes().length > 0) {
            return new String(file.asBytes());
        }
        String localConfig = this.localConfig();
        if (localConfig != null) {
            return localConfig;
        }
        throw new IOException("Can not find json file to migrate");
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        List<ModelNode> ops = null;
        try {
            PathAddress currentAddr = context.getCurrentAddress();
            ops = JsonConfigConverter.convertJsonConfig(this.readConfig(operation), currentAddr);
        }
        catch (IOException ioe) {
            throw new OperationFailedException((Throwable)ioe);
        }
        for (ModelNode op : ops) {
            PathAddress addr = PathAddress.pathAddress((ModelNode)op.get("address"));
            String opName = op.get("operation").asString();
            context.addStep(op, context.getRootResourceRegistration().getOperationHandler(addr, opName), OperationContext.Stage.MODEL);
        }
        context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
    }
}

