/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.restclient.model;

import com.openshift.internal.restclient.model.KubernetesResource;
import com.openshift.restclient.IClient;
import com.openshift.restclient.model.secret.ISecret;
import com.openshift.restclient.utils.Base64Coder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.jboss.dmr.ModelNode;

public class Secret
extends KubernetesResource
implements ISecret {
    private static final String SECRET_TYPE = "type";
    private static final String SECRET_DATA = "data";

    public Secret(ModelNode node, IClient client, Map<String, String[]> propertyKeys) {
        super(node, client, propertyKeys);
    }

    @Override
    public void addData(String key, InputStream data) {
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)data, (OutputStream)os);
            this.addData(key, os.toByteArray());
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not process data stream", e);
        }
    }

    @Override
    public void addData(String key, byte[] data) {
        ModelNode dataNode = this.get(SECRET_DATA);
        dataNode.get(key).set(Base64Coder.encode(data));
    }

    @Override
    public byte[] getData(String key) {
        return Base64Coder.decodeBinary(this.asMap(SECRET_DATA).get(key));
    }

    @Override
    public void setType(String type) {
        this.get(SECRET_TYPE).set(type.toString());
    }

    @Override
    public String getType() {
        return this.asString(SECRET_TYPE);
    }
}

