/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class JBossDmrExtentions {
    private JBossDmrExtentions() {
    }

    public static String toJsonString(ModelNode node, boolean compact) {
        JBossDmrExtentions.sanitize(node);
        StringWriter writer = new StringWriter();
        node.writeJSONString(new PrintWriter((Writer)writer, true), compact);
        return writer.toString();
    }

    private static void sanitize(ModelNode node) {
        if (node.getType() == ModelType.OBJECT) {
            ArrayList<String> emptyKeys = new ArrayList<String>(node.keys().size());
            for (String key2 : node.keys()) {
                ModelNode child = node.get(key2);
                if (child.getType() == ModelType.UNDEFINED) {
                    emptyKeys.add(key2);
                } else {
                    JBossDmrExtentions.sanitize(child);
                }
                if (child.getType() != ModelType.LIST) continue;
                List entries = child.asList();
                if (entries.isEmpty()) {
                    emptyKeys.add(key2);
                    continue;
                }
                int listSize = entries.size();
                ArrayList<Integer> nulls = new ArrayList<Integer>(listSize);
                for (int i2 = 0; i2 < listSize; ++i2) {
                    ModelNode e = (ModelNode)entries.get(i2);
                    if (!e.isDefined()) {
                        nulls.add(i2);
                        continue;
                    }
                    JBossDmrExtentions.sanitize(e);
                }
                Collections.reverse(nulls);
                nulls.stream().forEach(i -> child.remove(i.intValue()));
                if (child.asList().size() != 0) continue;
                emptyKeys.add(key2);
            }
            emptyKeys.stream().forEach(key -> node.remove(key));
        }
    }

    public static void set(ModelNode node, Map<String, String[]> propertyKeys, String key, boolean value) {
        if (propertyKeys == null) {
            return;
        }
        ModelNode modelNode = node.get(JBossDmrExtentions.getPath(propertyKeys, key));
        modelNode.set(value);
    }

    public static void set(ModelNode node, Map<String, String[]> propertyKeys, String key, String value) {
        if (propertyKeys == null) {
            return;
        }
        JBossDmrExtentions.set(node, JBossDmrExtentions.getPath(propertyKeys, key), value);
    }

    public static void set(ModelNode node, String[] path, String value) {
        if (value == null) {
            return;
        }
        ModelNode modelNode = node.get(path);
        modelNode.set(value);
    }

    public static void set(ModelNode node, Map<String, String[]> propertyKeys, String key, int value) {
        if (propertyKeys == null) {
            return;
        }
        ModelNode modelNode = node.get(JBossDmrExtentions.getPath(propertyKeys, key));
        modelNode.set(value);
    }

    public static void set(ModelNode node, Map<String, String[]> propertyKeys, String key, Map<String, String> values) {
        if (propertyKeys == null) {
            return;
        }
        ModelNode modelNode = node.get(JBossDmrExtentions.getPath(propertyKeys, key));
        for (Map.Entry<String, String> entry : values.entrySet()) {
            modelNode.get(entry.getKey()).set(entry.getValue());
        }
    }

    public static void set(ModelNode root, Map<String, String[]> propertyKeys, String key, Set<String> values) {
        String[] path = JBossDmrExtentions.getPath(propertyKeys, key);
        ModelNode node = root.get(path);
        for (String entry : values) {
            node.add(entry);
        }
    }

    public static void set(ModelNode root, Map<String, String[]> propertyKeys, String key, String ... values) {
        String[] path = JBossDmrExtentions.getPath(propertyKeys, key);
        ModelNode node = root.get(path);
        for (String value : values) {
            node.add(value);
        }
    }

    public static Map<String, String> asMap(ModelNode root, Map<String, String[]> propertyKeys, String key) {
        String[] path;
        HashMap<String, String> map = new HashMap<String, String>();
        if (propertyKeys != null && root.has(path = JBossDmrExtentions.getPath(propertyKeys, key))) {
            ModelNode node = root.get(path);
            if (!node.isDefined()) {
                return map;
            }
            for (String k : node.keys()) {
                map.put(k, node.get(k).asString());
            }
        }
        return map;
    }

    public static Set asSet(ModelNode root, Map<String, String[]> propertyKeys, String key, ModelType type) {
        HashSet<String> set = new HashSet<String>();
        String[] path = JBossDmrExtentions.getPath(propertyKeys, key);
        if (root.has(path)) {
            ModelNode node = root.get(path);
            if (!node.isDefined()) {
                return set;
            }
            for (ModelNode entry : node.asList()) {
                Object instance = null;
                switch (type) {
                    case STRING: {
                        instance = entry.asString();
                        break;
                    }
                    case BOOLEAN: {
                        instance = entry.asBoolean();
                        break;
                    }
                    case INT: {
                        instance = entry.asInt();
                        break;
                    }
                }
                set.add((String)instance);
            }
        }
        return set;
    }

    public static List asList(ModelNode root, Map<String, String[]> propertyKeys, String key, ModelType type) {
        ArrayList<String> list = new ArrayList<String>();
        String[] path = JBossDmrExtentions.getPath(propertyKeys, key);
        if (root.has(path)) {
            ModelNode node = root.get(path);
            if (!node.isDefined()) {
                return list;
            }
            for (ModelNode entry : node.asList()) {
                Object instance = null;
                switch (type) {
                    case STRING: {
                        instance = entry.asString();
                        break;
                    }
                    case BOOLEAN: {
                        instance = entry.asBoolean();
                        break;
                    }
                    case INT: {
                        instance = entry.asInt();
                        break;
                    }
                }
                list.add((String)instance);
            }
        }
        return list;
    }

    public static int asInt(ModelNode node, Map<String, String[]> propertyKeys, String key) {
        String[] path = JBossDmrExtentions.getPath(propertyKeys, key);
        if (node.has(path)) {
            ModelNode modelNode = node.get(path);
            if (!modelNode.isDefined()) {
                return 0;
            }
            return modelNode.asInt();
        }
        return 0;
    }

    public static String asString(ModelNode node, Map<String, String[]> propertyKeys, String key) {
        String[] path = JBossDmrExtentions.getPath(propertyKeys, key);
        if (!node.has(path)) {
            return "";
        }
        ModelNode modelNode = node.get(path);
        if (!modelNode.isDefined()) {
            return "";
        }
        return modelNode.asString();
    }

    public static boolean asBoolean(ModelNode node, Map<String, String[]> propertyKeys, String key) {
        String[] path = JBossDmrExtentions.getPath(propertyKeys, key);
        if (!node.has(path)) {
            return false;
        }
        ModelNode modelNode = node.get(path);
        if (!modelNode.isDefined()) {
            return false;
        }
        return modelNode.asBoolean();
    }

    public static ModelNode get(ModelNode node, Map<String, String[]> propertyKeys, String key) {
        return node.get(JBossDmrExtentions.getPath(propertyKeys, key));
    }

    public static String[] getPath(Map<String, String[]> propertyKeys, String key) {
        if (propertyKeys != null && propertyKeys.containsKey(key)) {
            return propertyKeys.get(key);
        }
        return key.split("\\.");
    }

    public static String[] getPath(String key) {
        return JBossDmrExtentions.getPath(Collections.EMPTY_MAP, key);
    }
}

