/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.command.runtime.rule;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.drools.core.command.impl.RegistryContext;
import org.drools.core.common.DisconnectedFactHandle;
import org.drools.core.util.MVELSafeHelper;
import org.kie.api.command.ExecutableCommand;
import org.kie.api.command.Setter;
import org.kie.api.runtime.Context;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.EntryPoint;
import org.kie.api.runtime.rule.FactHandle;

@XmlAccessorType(value=XmlAccessType.NONE)
public class ModifyCommand
implements ExecutableCommand<Object> {
    @XmlAttribute(name="allow-modify-expr")
    public boolean ALLOW_MODIFY_EXPRESSIONS = true;
    @XmlElement(name="fact-handle", required=true)
    private DisconnectedFactHandle factHandle;
    private List<Setter> setters;

    public ModifyCommand() {
    }

    public ModifyCommand(FactHandle handle, List<Setter> setters) {
        this.factHandle = DisconnectedFactHandle.newFrom(handle);
        this.setSetters(setters);
    }

    public FactHandle getFactHandle() {
        return this.factHandle;
    }

    public void setFactHandle(DisconnectedFactHandle factHandle) {
        this.factHandle = factHandle;
    }

    public void setFactHandleFromString(String factHandleId) {
        this.factHandle = new DisconnectedFactHandle(factHandleId);
    }

    public String getFactHandleFromString() {
        return this.factHandle.toExternalForm();
    }

    @XmlElement(type=SetterImpl.class)
    public List<Setter> getSetters() {
        if (this.setters == null) {
            this.setters = new ArrayList<Setter>();
        }
        this.checkSetters();
        return this.setters;
    }

    public void setSetters(List<Setter> setters) {
        this.setters = setters;
        if (this.setters != null) {
            this.checkSetters();
        }
    }

    private void checkSetters() {
        for (int i = 0; i < this.setters.size(); ++i) {
            Setter setter = this.setters.get(i);
            if (this.setters instanceof SetterImpl) continue;
            this.setters.set(i, new SetterImpl(setter.getAccessor(), setter.getValue()));
        }
    }

    private String getMvelExpr() {
        StringBuilder sbuilder = new StringBuilder();
        sbuilder.append("with (this) {\n");
        int i = 0;
        for (Setter setter : this.getSetters()) {
            if (i++ > 0) {
                sbuilder.append(",");
            }
            if (this.ALLOW_MODIFY_EXPRESSIONS) {
                sbuilder.append(setter.getAccessor() + " = '" + setter.getValue() + "'\n");
                continue;
            }
            sbuilder.append(setter.getAccessor() + " = '" + setter.getValue().replace("\"", "") + "'\n");
        }
        sbuilder.append("}");
        return sbuilder.toString();
    }

    public Object execute(Context context) {
        KieSession ksession = ((RegistryContext)context).lookup(KieSession.class);
        EntryPoint wmep = ksession.getEntryPoint(this.factHandle.getEntryPointId());
        Object object = wmep.getObject((FactHandle)this.factHandle);
        MVELSafeHelper.getEvaluator().eval(this.getMvelExpr(), object);
        wmep.update((FactHandle)this.factHandle, object);
        return object;
    }

    public String toString() {
        return "modify() " + this.getMvelExpr();
    }

    @XmlRootElement(name="setter")
    public static class SetterImpl
    implements Setter {
        @XmlAttribute
        private String accessor;
        @XmlAttribute
        private String value;

        public SetterImpl() {
        }

        public SetterImpl(String accessor, String value) {
            this.accessor = accessor;
            this.value = value;
        }

        public String getAccessor() {
            return this.accessor;
        }

        public String getValue() {
            return this.value;
        }
    }
}

