/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.ruleunit;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.drools.core.WorkingMemoryEntryPoint;
import org.drools.core.datasources.BindableArray;
import org.drools.core.datasources.BindableDataProvider;
import org.drools.core.datasources.BindableIterable;
import org.drools.core.datasources.BindableObject;
import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.drools.core.rule.EntryPointId;
import org.drools.core.util.ClassUtils;
import org.kie.api.runtime.rule.RuleUnit;

public class RuleUnitDescr {
    private final Class<? extends RuleUnit> ruleUnitClass;
    private final Map<String, String> datasources = new HashMap<String, String>();
    private final Map<String, Class<?>> datasourceTypes = new HashMap();
    private final Map<String, Method> varAccessors = new HashMap<String, Method>();

    public RuleUnitDescr(Class<? extends RuleUnit> ruleUnitClass) {
        this.ruleUnitClass = ruleUnitClass;
        this.indexUnitVars();
    }

    public Class<? extends RuleUnit> getRuleUnitClass() {
        return this.ruleUnitClass;
    }

    public String getRuleUnitName() {
        return this.ruleUnitClass.getName();
    }

    private String getEntryPointName(String name) {
        return this.getRuleUnitName() + "." + name;
    }

    public Optional<EntryPointId> getEntryPointId(String name) {
        return Optional.ofNullable(this.datasources.get(name)).map(ds -> new EntryPointId(this.getEntryPointName(name)));
    }

    public Optional<Class<?>> getDatasourceType(String name) {
        return Optional.ofNullable(this.datasourceTypes.get(name));
    }

    public Optional<Class<?>> getVarType(String name) {
        return Optional.ofNullable(this.varAccessors.get(name)).map(Method::getReturnType);
    }

    public boolean hasVar(String name) {
        return this.varAccessors.containsKey(name);
    }

    public Collection<String> getUnitVars() {
        return this.varAccessors.keySet();
    }

    public Map<String, Method> getUnitVarAccessors() {
        return this.varAccessors;
    }

    public boolean hasDataSource(String name) {
        return this.datasources.containsKey(name);
    }

    public void bindDataSources(StatefulKnowledgeSessionImpl wm, RuleUnit ruleUnit) {
        this.datasources.forEach((name, accessor) -> this.bindDataSource(wm, ruleUnit, (String)name, (String)accessor));
    }

    private void bindDataSource(StatefulKnowledgeSessionImpl wm, RuleUnit ruleUnit, String name, String accessor) {
        BindableDataProvider dataSource;
        WorkingMemoryEntryPoint entryPoint = wm.getEntryPoint(this.getEntryPointName(name));
        if (entryPoint != null && (dataSource = this.findDataSource(ruleUnit, accessor)) != null) {
            dataSource.bind(ruleUnit, entryPoint);
        }
    }

    public void unbindDataSources(StatefulKnowledgeSessionImpl wm, RuleUnit ruleUnit) {
        this.datasources.values().forEach(accessor -> this.unbindDataSource(ruleUnit, (String)accessor));
    }

    private void unbindDataSource(RuleUnit ruleUnit, String accessor) {
        BindableDataProvider dataSource = this.findDataSource(ruleUnit, accessor);
        if (dataSource != null) {
            dataSource.unbind(ruleUnit);
        }
    }

    public Object getValue(RuleUnit ruleUnit, String identifier) {
        Method m = this.varAccessors.get(identifier);
        if (m != null) {
            try {
                return m.invoke((Object)ruleUnit, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    private BindableDataProvider findDataSource(RuleUnit ruleUnit, String accessor) {
        try {
            Object value = ruleUnit.getClass().getMethod(accessor, new Class[0]).invoke((Object)ruleUnit, new Object[0]);
            if (value == null) {
                return null;
            }
            if (value instanceof BindableDataProvider) {
                return (BindableDataProvider)value;
            }
            if (value instanceof Iterable) {
                return new BindableIterable((Iterable)value);
            }
            if (value.getClass().isArray()) {
                return new BindableArray((Object[])value);
            }
            return new BindableObject(value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void indexUnitVars() {
        for (Method m : this.ruleUnitClass.getMethods()) {
            String id;
            if (m.getDeclaringClass() == RuleUnit.class || m.getParameterCount() != 0 || (id = ClassUtils.getter2property(m.getName())) == null || id.equals("class")) continue;
            this.datasources.put(id, m.getName());
            this.varAccessors.put(id, m);
            Class<?> returnClass = m.getReturnType();
            if (returnClass.isArray()) {
                this.datasourceTypes.put(id, returnClass.getComponentType());
                continue;
            }
            if (Iterable.class.isAssignableFrom(returnClass)) {
                Type returnType = m.getGenericReturnType();
                Class sourceType = returnType instanceof ParameterizedType ? (Class)((ParameterizedType)returnType).getActualTypeArguments()[0] : Object.class;
                this.datasourceTypes.put(id, sourceType);
                continue;
            }
            this.datasourceTypes.put(id, returnClass);
        }
    }
}

