/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.converter.jackson.deserializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import com.webauthn4j.data.attestation.statement.ECCUnique;
import com.webauthn4j.data.attestation.statement.RSAUnique;
import com.webauthn4j.data.attestation.statement.TPMAObject;
import com.webauthn4j.data.attestation.statement.TPMEccCurve;
import com.webauthn4j.data.attestation.statement.TPMIAlgHash;
import com.webauthn4j.data.attestation.statement.TPMIAlgPublic;
import com.webauthn4j.data.attestation.statement.TPMSECCParms;
import com.webauthn4j.data.attestation.statement.TPMSRSAParms;
import com.webauthn4j.data.attestation.statement.TPMTPublic;
import com.webauthn4j.data.attestation.statement.TPMUPublicId;
import com.webauthn4j.data.attestation.statement.TPMUPublicParms;
import com.webauthn4j.util.UnsignedNumberUtil;
import com.webauthn4j.util.exception.NotImplementedException;
import java.io.IOException;
import java.nio.ByteBuffer;

public class TPMTPublicDeserializer
extends StdDeserializer<TPMTPublic> {
    public TPMTPublicDeserializer() {
        super(TPMTPublic.class);
    }

    public TPMTPublic deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        byte[] value = p.getBinaryValue();
        try {
            return this.deserialize(value);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidFormatException(p, "input byte array contains surplus data", (Object)value, TPMTPublic.class);
        }
    }

    TPMTPublic deserialize(byte[] value) {
        ByteBuffer buffer = ByteBuffer.wrap(value);
        int typeValue = UnsignedNumberUtil.getUnsignedShort((ByteBuffer)buffer);
        TPMIAlgPublic type = TPMIAlgPublic.create(typeValue);
        TPMIAlgHash nameAlgValue = TPMIAlgHash.create(UnsignedNumberUtil.getUnsignedShort((ByteBuffer)buffer));
        TPMAObject objectAttributes = this.extractTPMAObject(buffer);
        int authPolicySize = UnsignedNumberUtil.getUnsignedShort((ByteBuffer)buffer);
        byte[] authPolicy = new byte[authPolicySize];
        buffer.get(authPolicy);
        TPMUPublicParms parameters = this.extractTPMUPublicParms(type, buffer);
        TPMUPublicId unique = this.extractTPMUPublicId(type, buffer);
        if (buffer.remaining() > 0) {
            throw new IllegalArgumentException("input byte array contains surplus data");
        }
        return new TPMTPublic(type, nameAlgValue, objectAttributes, authPolicy, parameters, unique);
    }

    private TPMAObject extractTPMAObject(ByteBuffer buffer) {
        int value = buffer.getInt();
        return new TPMAObject(value);
    }

    private TPMUPublicParms extractTPMUPublicParms(TPMIAlgPublic type, ByteBuffer buffer) {
        switch (type) {
            case TPM_ALG_RSA: {
                return this.extractTPMSRSAParms(buffer);
            }
            case TPM_ALG_ECDSA: {
                return this.extractTPMSECDSAParms(buffer);
            }
        }
        throw new NotImplementedException();
    }

    private TPMSRSAParms extractTPMSRSAParms(ByteBuffer buffer) {
        byte[] symmetric = new byte[2];
        buffer.get(symmetric);
        byte[] scheme = new byte[2];
        buffer.get(scheme);
        byte[] keyBits = new byte[2];
        buffer.get(keyBits);
        byte[] exponent = new byte[4];
        buffer.get(exponent);
        return new TPMSRSAParms(symmetric, scheme, keyBits, exponent);
    }

    private TPMSECCParms extractTPMSECDSAParms(ByteBuffer buffer) {
        byte[] symmetric = new byte[2];
        buffer.get(symmetric);
        byte[] scheme = new byte[2];
        buffer.get(scheme);
        byte[] curveId = new byte[2];
        buffer.get(curveId);
        byte[] kdf = new byte[2];
        buffer.get(kdf);
        return new TPMSECCParms(symmetric, scheme, TPMEccCurve.create(UnsignedNumberUtil.getUnsignedShort((byte[])curveId)), kdf);
    }

    private TPMUPublicId extractTPMUPublicId(TPMIAlgPublic type, ByteBuffer buffer) {
        if (type == TPMIAlgPublic.TPM_ALG_RSA) {
            int nSize = UnsignedNumberUtil.getUnsignedShort((ByteBuffer)buffer);
            byte[] n = new byte[nSize];
            buffer.get(n);
            return new RSAUnique(n);
        }
        if (type == TPMIAlgPublic.TPM_ALG_ECDSA) {
            int xSize = UnsignedNumberUtil.getUnsignedShort((ByteBuffer)buffer);
            byte[] x = new byte[xSize];
            buffer.get(x);
            int ySize = UnsignedNumberUtil.getUnsignedShort((ByteBuffer)buffer);
            byte[] y = new byte[ySize];
            buffer.get(y);
            return new ECCUnique(x, y);
        }
        throw new NotImplementedException();
    }
}

