/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data;

import com.webauthn4j.data.AuthenticatorResponse;
import com.webauthn4j.data.AuthenticatorTransport;
import com.webauthn4j.util.ArrayUtil;
import com.webauthn4j.util.CollectionUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;

public class AuthenticatorAttestationResponse
extends AuthenticatorResponse {
    private byte[] attestationObject;
    private Set<AuthenticatorTransport> transports;

    public AuthenticatorAttestationResponse(byte[] clientDataJSON, byte[] attestationObject) {
        this(clientDataJSON, attestationObject, Collections.emptySet());
    }

    public AuthenticatorAttestationResponse(byte[] clientDataJSON, byte[] attestationObject, Set<AuthenticatorTransport> transports) {
        super(clientDataJSON);
        this.attestationObject = attestationObject;
        this.transports = CollectionUtil.unmodifiableSet(transports);
    }

    public byte[] getAttestationObject() {
        return ArrayUtil.clone((byte[])this.attestationObject);
    }

    public Set<AuthenticatorTransport> getTransports() {
        return this.transports;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthenticatorAttestationResponse that = (AuthenticatorAttestationResponse)o;
        return Arrays.equals(this.attestationObject, that.attestationObject) && Objects.equals(this.transports, that.transports);
    }

    public int hashCode() {
        int result = Objects.hash(this.transports);
        result = 31 * result + Arrays.hashCode(this.attestationObject);
        return result;
    }
}

