/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data;

import com.webauthn4j.data.PublicKeyCredentialDescriptor;
import com.webauthn4j.data.UserVerificationRequirement;
import com.webauthn4j.data.client.challenge.Challenge;
import com.webauthn4j.data.extension.client.AuthenticationExtensionClientInput;
import com.webauthn4j.data.extension.client.AuthenticationExtensionsClientInputs;
import com.webauthn4j.util.CollectionUtil;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;

public class PublicKeyCredentialRequestOptions
implements Serializable {
    private Challenge challenge;
    private Long timeout;
    private String rpId;
    private List<PublicKeyCredentialDescriptor> allowCredentials;
    private UserVerificationRequirement userVerification;
    private AuthenticationExtensionsClientInputs<AuthenticationExtensionClientInput> extensions;

    public PublicKeyCredentialRequestOptions(Challenge challenge, Long timeout, String rpId, List<PublicKeyCredentialDescriptor> allowCredentials, UserVerificationRequirement userVerification, AuthenticationExtensionsClientInputs<AuthenticationExtensionClientInput> extensions) {
        this.challenge = challenge;
        this.timeout = timeout;
        this.rpId = rpId;
        this.allowCredentials = CollectionUtil.unmodifiableList(allowCredentials);
        this.userVerification = userVerification;
        this.extensions = extensions;
    }

    public Challenge getChallenge() {
        return this.challenge;
    }

    public Long getTimeout() {
        return this.timeout;
    }

    public String getRpId() {
        return this.rpId;
    }

    public List<PublicKeyCredentialDescriptor> getAllowCredentials() {
        return this.allowCredentials;
    }

    public UserVerificationRequirement getUserVerification() {
        return this.userVerification;
    }

    public AuthenticationExtensionsClientInputs<AuthenticationExtensionClientInput> getExtensions() {
        return this.extensions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PublicKeyCredentialRequestOptions that = (PublicKeyCredentialRequestOptions)o;
        return Objects.equals(this.timeout, that.timeout) && Objects.equals(this.challenge, that.challenge) && Objects.equals(this.rpId, that.rpId) && Objects.equals(this.allowCredentials, that.allowCredentials) && this.userVerification == that.userVerification && Objects.equals(this.extensions, that.extensions);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.challenge, this.timeout, this.rpId, this.allowCredentials, this.userVerification, this.extensions});
    }
}

