/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import twitter4j.JSONObject;

public final class HttpParameter
implements Comparable<HttpParameter>,
Serializable {
    private static final long serialVersionUID = 4046908449190454692L;
    private String name = null;
    private String value = null;
    private JSONObject jsonObject = null;
    private File file = null;
    private InputStream fileBody = null;
    private static final String JPEG = "image/jpeg";
    private static final String GIF = "image/gif";
    private static final String PNG = "image/png";
    private static final String OCTET = "application/octet-stream";

    public HttpParameter(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public HttpParameter(JSONObject jsonObject) {
        this.jsonObject = jsonObject;
    }

    public HttpParameter(String name, File file) {
        this.name = name;
        this.file = file;
    }

    public HttpParameter(String name, String fileName, InputStream fileBody) {
        this.name = name;
        this.file = new File(fileName);
        this.fileBody = fileBody;
    }

    public HttpParameter(String name, int value) {
        this.name = name;
        this.value = String.valueOf(value);
    }

    public HttpParameter(String name, long value) {
        this.name = name;
        this.value = String.valueOf(value);
    }

    public HttpParameter(String name, double value) {
        this.name = name;
        this.value = String.valueOf(value);
    }

    public HttpParameter(String name, boolean value) {
        this.name = name;
        this.value = String.valueOf(value);
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public JSONObject getJsonObject() {
        return this.jsonObject;
    }

    public File getFile() {
        return this.file;
    }

    public InputStream getFileBody() {
        return this.fileBody;
    }

    public boolean isFile() {
        return this.file != null;
    }

    public boolean isJson() {
        return this.jsonObject != null;
    }

    public boolean hasFileBody() {
        return this.fileBody != null;
    }

    public String getContentType() {
        if (!this.isFile()) {
            throw new IllegalStateException("not a file");
        }
        String extensions = this.file.getName();
        int index = extensions.lastIndexOf(".");
        String contentType = -1 == index ? OCTET : ((extensions = extensions.substring(extensions.lastIndexOf(".") + 1).toLowerCase()).length() == 3 ? ("gif".equals(extensions) ? GIF : ("png".equals(extensions) ? PNG : ("jpg".equals(extensions) ? JPEG : OCTET))) : (extensions.length() == 4 ? ("jpeg".equals(extensions) ? JPEG : OCTET) : OCTET));
        return contentType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpParameter that = (HttpParameter)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.value != null ? !this.value.equals(that.value) : that.value != null) {
            return false;
        }
        if (this.jsonObject != null ? !this.jsonObject.equals(that.jsonObject) : that.jsonObject != null) {
            return false;
        }
        if (this.file != null ? !this.file.equals(that.file) : that.file != null) {
            return false;
        }
        return this.fileBody != null ? this.fileBody.equals(that.fileBody) : that.fileBody == null;
    }

    public static boolean containsJson(HttpParameter[] params) {
        return params.length == 1 && params[0].isJson();
    }

    public static boolean containsFile(HttpParameter[] params) {
        boolean containsFile = false;
        if (null == params) {
            return false;
        }
        for (HttpParameter param : params) {
            if (!param.isFile()) continue;
            containsFile = true;
            break;
        }
        return containsFile;
    }

    static boolean containsFile(List<HttpParameter> params) {
        boolean containsFile = false;
        for (HttpParameter param : params) {
            if (!param.isFile()) continue;
            containsFile = true;
            break;
        }
        return containsFile;
    }

    public static HttpParameter[] getParameterArray(String name, String value) {
        return new HttpParameter[]{new HttpParameter(name, value)};
    }

    public static HttpParameter[] getParameterArray(String name, int value) {
        return HttpParameter.getParameterArray(name, String.valueOf(value));
    }

    public static HttpParameter[] getParameterArray(String name1, String value1, String name2, String value2) {
        return new HttpParameter[]{new HttpParameter(name1, value1), new HttpParameter(name2, value2)};
    }

    public static HttpParameter[] getParameterArray(String name1, int value1, String name2, int value2) {
        return HttpParameter.getParameterArray(name1, String.valueOf(value1), name2, String.valueOf(value2));
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        result = 31 * result + (this.jsonObject != null ? this.jsonObject.hashCode() : 0);
        result = 31 * result + (this.file != null ? this.file.hashCode() : 0);
        result = 31 * result + (this.fileBody != null ? this.fileBody.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "HttpParameter{name='" + this.name + '\'' + ", value='" + this.value + '\'' + ", jsonObject=" + this.jsonObject + ", file=" + this.file + ", fileBody=" + this.fileBody + '}';
    }

    @Override
    public int compareTo(HttpParameter o) {
        int compared = 0;
        if (this.name != null) {
            compared = this.name.compareTo(o.name);
        }
        if (0 == compared && this.value != null) {
            compared = this.value.compareTo(o.value);
        }
        return compared;
    }

    public static String encodeParameters(HttpParameter[] httpParams) {
        if (null == httpParams) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        for (int j = 0; j < httpParams.length; ++j) {
            if (httpParams[j].isFile()) {
                throw new IllegalArgumentException("parameter [" + httpParams[j].name + "]should be text");
            }
            if (j != 0) {
                buf.append("&");
            }
            buf.append(HttpParameter.encode(httpParams[j].name)).append("=").append(HttpParameter.encode(httpParams[j].value));
        }
        return buf.toString();
    }

    public static String encode(String value) {
        String encoded = null;
        try {
            encoded = URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        StringBuilder buf = new StringBuilder(encoded.length());
        for (int i = 0; i < encoded.length(); ++i) {
            char focus = encoded.charAt(i);
            if (focus == '*') {
                buf.append("%2A");
                continue;
            }
            if (focus == '+') {
                buf.append("%20");
                continue;
            }
            if (focus == '%' && i + 1 < encoded.length() && encoded.charAt(i + 1) == '7' && encoded.charAt(i + 2) == 'E') {
                buf.append('~');
                i += 2;
                continue;
            }
            buf.append(focus);
        }
        return buf.toString();
    }

    public static String decode(String value) {
        value = value.replace("%2A", "*");
        value = value.replace("%2a", "*");
        value = value.replace("%20", " ");
        String decoded = null;
        try {
            decoded = URLDecoder.decode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return decoded;
    }

    public static List<HttpParameter> decodeParameters(String queryParameters) {
        ArrayList<HttpParameter> result = new ArrayList<HttpParameter>();
        for (String pair : queryParameters.split("&")) {
            String[] parts = pair.split("=", 2);
            if (parts.length != 2) continue;
            String name = HttpParameter.decode(parts[0]);
            String value = HttpParameter.decode(parts[1]);
            if (name.equals("") || value.equals("")) continue;
            result.add(new HttpParameter(name, value));
        }
        return result;
    }
}

