/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.utils;

import javax.ws.rs.BadRequestException;
import org.jboss.logging.Logger;

public class ReservedCharValidator {
    protected static final Logger logger = Logger.getLogger(ReservedCharValidator.class);
    private static final String[] RESERVED_CHARS = new String[]{":", "/", "?", "#", "[", "@", "!", "$", "&", "(", ")", "*", "+", ",", ";", "=", "]", "[", "\\"};

    private ReservedCharValidator() {
    }

    public static void validate(String str) throws ReservedCharException {
        if (str == null) {
            return;
        }
        for (String c : RESERVED_CHARS) {
            if (!str.contains(c)) continue;
            String message = "Character '" + c + "' not allowed.";
            ReservedCharException e = new ReservedCharException(message);
            logger.warn((Object)message, (Throwable)((Object)e));
            throw e;
        }
    }

    public static class ReservedCharException
    extends BadRequestException {
        ReservedCharException(String msg) {
            super(msg);
        }
    }
}

